/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.boot.config;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(value="db-scheduler")
public class DbSchedulerProperties {
    private boolean enabled = true;
    private int threads = 10;
    @DurationUnit(value=ChronoUnit.MINUTES)
    @NotNull
    private Duration heartbeatInterval = Duration.ofMinutes(5L);
    private String schedulerName;
    @NotNull
    private String tableName = "scheduled_tasks";
    private boolean immediateExecutionEnabled = false;
    @DurationUnit(value=ChronoUnit.SECONDS)
    @NotNull
    private Duration pollingInterval = Duration.ofSeconds(30L);
    private Optional<Integer> pollingLimit = Optional.empty();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public Duration getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public void setHeartbeatInterval(Duration heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
    }

    public String getSchedulerName() {
        return this.schedulerName;
    }

    public void setSchedulerName(String schedulerName) {
        this.schedulerName = schedulerName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public boolean isImmediateExecutionEnabled() {
        return this.immediateExecutionEnabled;
    }

    public void setImmediateExecutionEnabled(boolean immediateExecutionEnabled) {
        this.immediateExecutionEnabled = immediateExecutionEnabled;
    }

    public Duration getPollingInterval() {
        return this.pollingInterval;
    }

    public void setPollingInterval(Duration pollingInterval) {
        this.pollingInterval = pollingInterval;
    }

    public Optional<Integer> getPollingLimit() {
        return this.pollingLimit;
    }

    public void setPollingLimit(Optional<Integer> pollingLimit) {
        this.pollingLimit = pollingLimit;
    }
}

