/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.boot.actuator;

import com.github.kagkarlsson.scheduler.Scheduler;
import com.github.kagkarlsson.scheduler.SchedulerState;
import java.util.Objects;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;

public class DbSchedulerHealthIndicator
implements HealthIndicator {
    private final SchedulerState state;

    public DbSchedulerHealthIndicator(Scheduler scheduler) {
        this.state = Objects.requireNonNull(scheduler).getSchedulerState();
    }

    public Health health() {
        if (this.state.isStarted() && !this.state.isShuttingDown()) {
            return Health.up().withDetail("state", (Object)"started").build();
        }
        if (this.state.isStarted() && this.state.isShuttingDown()) {
            return Health.outOfService().withDetail("state", (Object)"shutting_down").build();
        }
        if (!this.state.isStarted() && !this.state.isShuttingDown()) {
            return Health.down().withDetail("state", (Object)"not_started").build();
        }
        return Health.down().build();
    }
}

