/*
 * Decompiled with CFR 0.152.
 */
package redux.api.helpers;

import java.util.ArrayList;
import redux.api.Reducer;
import redux.api.helpers.Actions;
import redux.api.helpers.State;
import redux.api.helpers.Todo;

public class Reducers {
    public static final Reducer<State> TODOS = new Reducer<State>(){

        public State reduce(State state, Object action) {
            if (action instanceof Actions.AddTodo) {
                String message = ((Actions.AddTodo)action).message;
                ArrayList<Todo> newTodos = new ArrayList<Todo>();
                newTodos.addAll(state.todos);
                newTodos.add(new Todo(Reducers.nexId(state), message));
                return new State(newTodos);
            }
            return state;
        }
    };
    public static final Reducer<State> TODOS_REVERSE = new Reducer<State>(){

        public State reduce(State state, Object action) {
            if (action instanceof Actions.AddTodo) {
                String message = ((Actions.AddTodo)action).message;
                ArrayList<Todo> newTodos = new ArrayList<Todo>();
                newTodos.add(new Todo(Reducers.nexId(state), message));
                newTodos.addAll(state.todos);
                return new State(newTodos);
            }
            return state;
        }
    };

    private static int nexId(State state) {
        int maxId = 0;
        for (Todo todo : state.todos) {
            maxId = Math.max(todo.id, maxId);
        }
        return maxId + 1;
    }
}

