/*
 * Decompiled with CFR 0.152.
 */
package redux.api;

import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import redux.api.Reducer;
import redux.api.Store;
import redux.api.helpers.ActionsCreator;
import redux.api.helpers.Reducers;
import redux.api.helpers.State;
import redux.api.helpers.Todo;

public abstract class StoreTest {
    @NotNull
    public abstract <S> Store<S> createStore(@NotNull Reducer<S> var1, @NotNull S var2);

    @Test
    public void passesTheInitialActionAndTheInitialState() {
        State initialState = new State(new Todo(1, "Hello"));
        Store<State> store = this.createStore(Reducers.TODOS, initialState);
        Assertions.assertThat((Object)store.getState()).isEqualTo((Object)initialState);
    }

    @Test
    public void appliesTheReducerToThePreviousState() {
        Store<State> store = this.createStore(Reducers.TODOS, new State());
        Assertions.assertThat((Object)store.getState()).isEqualTo((Object)new State());
        store.dispatch(ActionsCreator.unknownAction());
        Assertions.assertThat((Object)store.getState()).isEqualTo((Object)new State());
        store.dispatch(ActionsCreator.addTodo("Hello"));
        Assertions.assertThat((Object)store.getState()).isEqualTo((Object)new State(new Todo(1, "Hello")));
        store.dispatch(ActionsCreator.addTodo("World"));
        Assertions.assertThat((Object)store.getState()).isEqualTo((Object)new State(new Todo(1, "Hello"), new Todo(2, "World")));
    }

    @Test
    public void appliesTheReducerToTheInitialState() {
        Store<State> store = this.createStore(Reducers.TODOS, new State(new Todo(1, "Hello")));
        Assertions.assertThat((Object)store.getState()).isEqualTo((Object)new State(new Todo(1, "Hello")));
        store.dispatch(ActionsCreator.unknownAction());
        Assertions.assertThat((Object)store.getState()).isEqualTo((Object)new State(new Todo(1, "Hello")));
        store.dispatch(ActionsCreator.addTodo("World"));
        Assertions.assertThat((Object)store.getState()).isEqualTo((Object)new State(new Todo(1, "Hello"), new Todo(2, "World")));
    }

    @Test
    public void sendsInitWhenReplacingAReducer() {
        Store<State> store = this.createStore(Reducers.TODOS, new State());
        StubbedStateReducer reducer = new StubbedStateReducer();
        store.replaceReducer((Reducer)reducer);
        Assertions.assertThat((Object)reducer.receivedAction).isEqualTo(Store.INIT);
    }

    @Test
    public void preservesTheStateWhenReplacingAReducer() {
        Store<State> store = this.createStore(Reducers.TODOS, new State());
        store.dispatch(ActionsCreator.addTodo("Hello"));
        store.dispatch(ActionsCreator.addTodo("World"));
        Assertions.assertThat((Object)store.getState()).isEqualTo((Object)new State(new Todo(1, "Hello"), new Todo(2, "World")));
        store.replaceReducer(Reducers.TODOS_REVERSE);
        Assertions.assertThat((Object)store.getState()).isEqualTo((Object)new State(new Todo(1, "Hello"), new Todo(2, "World")));
        store.dispatch(ActionsCreator.addTodo("Perhaps"));
        Assertions.assertThat((Object)store.getState()).isEqualTo((Object)new State(new Todo(3, "Perhaps"), new Todo(1, "Hello"), new Todo(2, "World")));
        store.replaceReducer(Reducers.TODOS);
        Assertions.assertThat((Object)store.getState()).isEqualTo((Object)new State(new Todo(3, "Perhaps"), new Todo(1, "Hello"), new Todo(2, "World")));
        store.dispatch(ActionsCreator.addTodo("Surely"));
        Assertions.assertThat((Object)store.getState()).isEqualTo((Object)new State(new Todo(3, "Perhaps"), new Todo(1, "Hello"), new Todo(2, "World"), new Todo(4, "Surely")));
    }

    @Test
    public void supportsMultipleSubscriptions() {
        Store<State> store = this.createStore(Reducers.TODOS, new State());
        Store.Subscriber subscriberA = (Store.Subscriber)Mockito.mock(Store.Subscriber.class);
        Store.Subscriber subscriberB = (Store.Subscriber)Mockito.mock(Store.Subscriber.class);
        Store.Subscription subscriptionA = store.subscribe(subscriberA);
        store.dispatch(ActionsCreator.unknownAction());
        ((Store.Subscriber)Mockito.verify((Object)subscriberA, (VerificationMode)Mockito.times((int)1))).onStateChanged();
        ((Store.Subscriber)Mockito.verify((Object)subscriberB, (VerificationMode)Mockito.times((int)0))).onStateChanged();
        store.dispatch(ActionsCreator.unknownAction());
        ((Store.Subscriber)Mockito.verify((Object)subscriberA, (VerificationMode)Mockito.times((int)2))).onStateChanged();
        ((Store.Subscriber)Mockito.verify((Object)subscriberB, (VerificationMode)Mockito.times((int)0))).onStateChanged();
        Store.Subscription subscriptionB = store.subscribe(subscriberB);
        store.dispatch(ActionsCreator.unknownAction());
        ((Store.Subscriber)Mockito.verify((Object)subscriberA, (VerificationMode)Mockito.times((int)3))).onStateChanged();
        ((Store.Subscriber)Mockito.verify((Object)subscriberB, (VerificationMode)Mockito.times((int)1))).onStateChanged();
        subscriptionA.unsubscribe();
        ((Store.Subscriber)Mockito.verify((Object)subscriberA, (VerificationMode)Mockito.times((int)3))).onStateChanged();
        ((Store.Subscriber)Mockito.verify((Object)subscriberB, (VerificationMode)Mockito.times((int)1))).onStateChanged();
        store.dispatch(ActionsCreator.unknownAction());
        ((Store.Subscriber)Mockito.verify((Object)subscriberA, (VerificationMode)Mockito.times((int)3))).onStateChanged();
        ((Store.Subscriber)Mockito.verify((Object)subscriberB, (VerificationMode)Mockito.times((int)2))).onStateChanged();
        subscriptionB.unsubscribe();
        ((Store.Subscriber)Mockito.verify((Object)subscriberA, (VerificationMode)Mockito.times((int)3))).onStateChanged();
        ((Store.Subscriber)Mockito.verify((Object)subscriberB, (VerificationMode)Mockito.times((int)2))).onStateChanged();
        store.dispatch(ActionsCreator.unknownAction());
        ((Store.Subscriber)Mockito.verify((Object)subscriberA, (VerificationMode)Mockito.times((int)3))).onStateChanged();
        ((Store.Subscriber)Mockito.verify((Object)subscriberB, (VerificationMode)Mockito.times((int)2))).onStateChanged();
        store.subscribe(subscriberA);
        ((Store.Subscriber)Mockito.verify((Object)subscriberA, (VerificationMode)Mockito.times((int)3))).onStateChanged();
        ((Store.Subscriber)Mockito.verify((Object)subscriberB, (VerificationMode)Mockito.times((int)2))).onStateChanged();
        store.dispatch(ActionsCreator.unknownAction());
        ((Store.Subscriber)Mockito.verify((Object)subscriberA, (VerificationMode)Mockito.times((int)4))).onStateChanged();
        ((Store.Subscriber)Mockito.verify((Object)subscriberB, (VerificationMode)Mockito.times((int)2))).onStateChanged();
    }

    @Test
    public void onlyRemovesSubscriberOnceWhenUnsubscribeIsCalled() {
        Store<State> store = this.createStore(Reducers.TODOS, new State());
        Store.Subscriber subscriberA = (Store.Subscriber)Mockito.mock(Store.Subscriber.class);
        Store.Subscriber subscriberB = (Store.Subscriber)Mockito.mock(Store.Subscriber.class);
        Store.Subscription subscriptionA = store.subscribe(subscriberA);
        store.subscribe(subscriberB);
        subscriptionA.unsubscribe();
        subscriptionA.unsubscribe();
        store.dispatch(ActionsCreator.unknownAction());
        ((Store.Subscriber)Mockito.verify((Object)subscriberA, (VerificationMode)Mockito.times((int)0))).onStateChanged();
        ((Store.Subscriber)Mockito.verify((Object)subscriberB, (VerificationMode)Mockito.times((int)1))).onStateChanged();
    }

    @Test
    public void onlyRemovesRelevantSubscriberWhenUnsubscribeIsCalled() {
        Store<State> store = this.createStore(Reducers.TODOS, new State());
        SubbedSubscriber subscriber = new SubbedSubscriber();
        store.subscribe((Store.Subscriber)subscriber);
        Store.Subscription secondSubscription = store.subscribe((Store.Subscriber)subscriber);
        secondSubscription.unsubscribe();
        store.dispatch(ActionsCreator.unknownAction());
        Assertions.assertThat((int)subscriber.nbOnStateChangedCall).isEqualTo(1);
    }

    @Test
    public void supportsRemovingASubscriptionWithinASubscription() {
        Store<State> store = this.createStore(Reducers.TODOS, new State());
        Store.Subscriber subscriberA = (Store.Subscriber)Mockito.mock(Store.Subscriber.class);
        Store.Subscriber subscriberB = (Store.Subscriber)Mockito.mock(Store.Subscriber.class);
        Store.Subscriber subscriberC = (Store.Subscriber)Mockito.mock(Store.Subscriber.class);
        store.subscribe(subscriberA);
        OneTimeProxySubscriber subscriber = new OneTimeProxySubscriber(subscriberB);
        Store.Subscription subscriptionB = store.subscribe((Store.Subscriber)subscriber);
        subscriber.setCurrentSubscription(subscriptionB);
        store.subscribe(subscriberC);
        store.dispatch(ActionsCreator.unknownAction());
        store.dispatch(ActionsCreator.unknownAction());
        ((Store.Subscriber)Mockito.verify((Object)subscriberA, (VerificationMode)Mockito.times((int)2))).onStateChanged();
        ((Store.Subscriber)Mockito.verify((Object)subscriberB, (VerificationMode)Mockito.times((int)1))).onStateChanged();
        ((Store.Subscriber)Mockito.verify((Object)subscriberC, (VerificationMode)Mockito.times((int)2))).onStateChanged();
    }

    @Test
    public void delaysUnsubscribeUntilTheEndOfCurrentDispatch() {
        Store<State> store = this.createStore(Reducers.TODOS, new State());
        final ArrayList<Store.Subscription> subscriptions = new ArrayList<Store.Subscription>();
        Store.Subscriber subscriber1 = (Store.Subscriber)Mockito.mock(Store.Subscriber.class);
        final Store.Subscriber subscriber2 = (Store.Subscriber)Mockito.mock(Store.Subscriber.class);
        Store.Subscriber subscriber3 = (Store.Subscriber)Mockito.mock(Store.Subscriber.class);
        subscriptions.add(store.subscribe(subscriber1));
        subscriptions.add(store.subscribe(new Store.Subscriber(){

            public void onStateChanged() {
                subscriber2.onStateChanged();
                for (Store.Subscription subscription : subscriptions) {
                    subscription.unsubscribe();
                }
            }
        }));
        subscriptions.add(store.subscribe(subscriber3));
        store.dispatch(ActionsCreator.unknownAction());
        ((Store.Subscriber)Mockito.verify((Object)subscriber1, (VerificationMode)Mockito.times((int)1))).onStateChanged();
        ((Store.Subscriber)Mockito.verify((Object)subscriber2, (VerificationMode)Mockito.times((int)1))).onStateChanged();
        ((Store.Subscriber)Mockito.verify((Object)subscriber3, (VerificationMode)Mockito.times((int)1))).onStateChanged();
        store.dispatch(ActionsCreator.unknownAction());
        ((Store.Subscriber)Mockito.verify((Object)subscriber1, (VerificationMode)Mockito.times((int)1))).onStateChanged();
        ((Store.Subscriber)Mockito.verify((Object)subscriber2, (VerificationMode)Mockito.times((int)1))).onStateChanged();
        ((Store.Subscriber)Mockito.verify((Object)subscriber3, (VerificationMode)Mockito.times((int)1))).onStateChanged();
    }

    @Test
    public void delaysSubscribeUntilTheEndOfCurrentDispatch() {
        final Store<State> store = this.createStore(Reducers.TODOS, new State());
        Store.Subscriber subscriber1 = (Store.Subscriber)Mockito.mock(Store.Subscriber.class);
        final Store.Subscriber subscriber2 = (Store.Subscriber)Mockito.mock(Store.Subscriber.class);
        final Store.Subscriber subscriber3 = (Store.Subscriber)Mockito.mock(Store.Subscriber.class);
        store.subscribe(subscriber1);
        store.subscribe(new Store.Subscriber(){
            boolean subscriber3Added = false;

            public void onStateChanged() {
                subscriber2.onStateChanged();
                if (!this.subscriber3Added) {
                    this.subscriber3Added = true;
                    store.subscribe(subscriber3);
                }
            }
        });
        store.dispatch(ActionsCreator.unknownAction());
        ((Store.Subscriber)Mockito.verify((Object)subscriber1, (VerificationMode)Mockito.times((int)1))).onStateChanged();
        ((Store.Subscriber)Mockito.verify((Object)subscriber2, (VerificationMode)Mockito.times((int)1))).onStateChanged();
        ((Store.Subscriber)Mockito.verify((Object)subscriber3, (VerificationMode)Mockito.times((int)0))).onStateChanged();
        store.dispatch(ActionsCreator.unknownAction());
        ((Store.Subscriber)Mockito.verify((Object)subscriber1, (VerificationMode)Mockito.times((int)2))).onStateChanged();
        ((Store.Subscriber)Mockito.verify((Object)subscriber2, (VerificationMode)Mockito.times((int)2))).onStateChanged();
        ((Store.Subscriber)Mockito.verify((Object)subscriber3, (VerificationMode)Mockito.times((int)1))).onStateChanged();
    }

    @Test
    public void usesTheLastSnapshotOfSubscribersDuringNestedDispatch() {
        final Store<State> store = this.createStore(Reducers.TODOS, new State());
        final Store.Subscriber subscriber1 = (Store.Subscriber)Mockito.mock(Store.Subscriber.class);
        final Store.Subscriber subscriber2 = (Store.Subscriber)Mockito.mock(Store.Subscriber.class);
        final Store.Subscriber subscriber3 = (Store.Subscriber)Mockito.mock(Store.Subscriber.class);
        final Store.Subscriber subscriber4 = (Store.Subscriber)Mockito.mock(Store.Subscriber.class);
        class Subscriber
        implements Store.Subscriber {
            Store.Subscription subscription1 = Store.Subscription.EMPTY;
            Store.Subscription subscription4 = Store.Subscription.EMPTY;

            Subscriber() {
                this.subscription1 = store.subscribe((Store.Subscriber)this);
                store.subscribe(subscriber2);
                store.subscribe(subscriber3);
            }

            public void onStateChanged() {
                subscriber1.onStateChanged();
                ((Store.Subscriber)Mockito.verify((Object)subscriber1, (VerificationMode)Mockito.times((int)1))).onStateChanged();
                ((Store.Subscriber)Mockito.verify((Object)subscriber2, (VerificationMode)Mockito.times((int)0))).onStateChanged();
                ((Store.Subscriber)Mockito.verify((Object)subscriber3, (VerificationMode)Mockito.times((int)0))).onStateChanged();
                ((Store.Subscriber)Mockito.verify((Object)subscriber4, (VerificationMode)Mockito.times((int)0))).onStateChanged();
                this.subscription1.unsubscribe();
                this.subscription4 = store.subscribe(subscriber4);
                store.dispatch(ActionsCreator.unknownAction());
                ((Store.Subscriber)Mockito.verify((Object)subscriber1, (VerificationMode)Mockito.times((int)1))).onStateChanged();
                ((Store.Subscriber)Mockito.verify((Object)subscriber2, (VerificationMode)Mockito.times((int)1))).onStateChanged();
                ((Store.Subscriber)Mockito.verify((Object)subscriber3, (VerificationMode)Mockito.times((int)1))).onStateChanged();
                ((Store.Subscriber)Mockito.verify((Object)subscriber4, (VerificationMode)Mockito.times((int)1))).onStateChanged();
            }
        }
        Subscriber subscriber = new Subscriber();
        store.dispatch(ActionsCreator.unknownAction());
        ((Store.Subscriber)Mockito.verify((Object)subscriber1, (VerificationMode)Mockito.times((int)1))).onStateChanged();
        ((Store.Subscriber)Mockito.verify((Object)subscriber2, (VerificationMode)Mockito.times((int)2))).onStateChanged();
        ((Store.Subscriber)Mockito.verify((Object)subscriber3, (VerificationMode)Mockito.times((int)2))).onStateChanged();
        ((Store.Subscriber)Mockito.verify((Object)subscriber4, (VerificationMode)Mockito.times((int)1))).onStateChanged();
        subscriber.subscription4.unsubscribe();
        store.dispatch(ActionsCreator.unknownAction());
        ((Store.Subscriber)Mockito.verify((Object)subscriber1, (VerificationMode)Mockito.times((int)1))).onStateChanged();
        ((Store.Subscriber)Mockito.verify((Object)subscriber2, (VerificationMode)Mockito.times((int)3))).onStateChanged();
        ((Store.Subscriber)Mockito.verify((Object)subscriber3, (VerificationMode)Mockito.times((int)3))).onStateChanged();
        ((Store.Subscriber)Mockito.verify((Object)subscriber4, (VerificationMode)Mockito.times((int)1))).onStateChanged();
    }

    @Test
    public void providesAnUptodateStateWhenASubscriberIsNotified() {
        final Store<State> store = this.createStore(Reducers.TODOS, new State());
        store.subscribe(new Store.Subscriber(){

            public void onStateChanged() {
                Assertions.assertThat((Object)store.getState()).isEqualTo((Object)new State(new Todo(1, "Hello")));
            }
        });
        store.dispatch(ActionsCreator.addTodo("Hello"));
    }

    @Test
    public void handlesNestedDispatchesGracefully() {
        Reducer<Integer> foo = new Reducer<Integer>(){

            public Integer reduce(Integer state, Object action) {
                if ("foo".equals(action)) {
                    return 1;
                }
                return state;
            }
        };
        Reducer<Integer> bar = new Reducer<Integer>(){

            public Integer reduce(Integer state, Object action) {
                if ("bar".equals(action)) {
                    return 2;
                }
                return state;
            }
        };
        Reducer<CombinedStates> combineReducers = new Reducer<CombinedStates>((Reducer)foo, (Reducer)bar){
            final /* synthetic */ Reducer val$foo;
            final /* synthetic */ Reducer val$bar;
            {
                this.val$foo = reducer;
                this.val$bar = reducer2;
            }

            public CombinedStates reduce(CombinedStates state, Object action) {
                class CombinedStates {
                    final int foo;
                    final int bar;

                    CombinedStates(int foo, int bar) {
                        this.foo = foo;
                        this.bar = bar;
                    }
                }
                return new CombinedStates((Integer)this.val$foo.reduce((Object)state.foo, action), (Integer)this.val$bar.reduce((Object)state.bar, action));
            }
        };
        final Store<CombinedStates> store = this.createStore(combineReducers, new CombinedStates(0, 0));
        Store.Subscriber subscriberDispatching = new Store.Subscriber(){

            public void onStateChanged() {
                CombinedStates state = (CombinedStates)store.getState();
                if (state.bar == 0) {
                    store.dispatch((Object)"bar");
                }
            }
        };
        store.subscribe(subscriberDispatching);
        store.dispatch((Object)"foo");
        Assertions.assertThat((int)((CombinedStates)store.getState()).foo).isEqualTo(1);
        Assertions.assertThat((int)((CombinedStates)store.getState()).bar).isEqualTo(2);
    }

    @Test(expected=Throwable.class)
    public void doesNotAllowDispatchFromWithinAReducer() {
        Store<Integer> store = this.createStore(new Reducer<Integer>(){

            public Integer reduce(Integer state, Object action) {
                class DispatchInMiddle {
                    final Store<Integer> store;

                    DispatchInMiddle(Store<Integer> store) {
                        this.store = store;
                    }

                    void dispatch() {
                        this.store.dispatch((Object)"DispatchInMiddle");
                    }
                }
                if (action instanceof DispatchInMiddle) {
                    ((DispatchInMiddle)action).dispatch();
                }
                return state;
            }
        }, 0);
        store.dispatch((Object)new DispatchInMiddle(store));
    }

    @Test
    public void doesNotThrowIfActionTypeIsUnknown() {
        Store<State> store = this.createStore(Reducers.TODOS, new State());
        Assertions.assertThat((Object)store.dispatch((Object)"unknown")).isEqualTo((Object)"unknown");
    }

    private class SubbedSubscriber
    implements Store.Subscriber {
        private int nbOnStateChangedCall = 0;

        SubbedSubscriber() {
        }

        public void onStateChanged() {
            ++this.nbOnStateChangedCall;
        }
    }

    private static class StubbedStateReducer
    implements Reducer<State> {
        private Object receivedAction;

        private StubbedStateReducer() {
        }

        public State reduce(State state, Object action) {
            this.receivedAction = action;
            return state;
        }
    }

    private static class OneTimeProxySubscriber
    implements Store.Subscriber {
        private final Store.Subscriber subscriberB;
        private Store.Subscription subscriptionB;

        OneTimeProxySubscriber(Store.Subscriber subscriberB) {
            this.subscriberB = subscriberB;
        }

        void setCurrentSubscription(Store.Subscription subscriptionB) {
            this.subscriptionB = subscriptionB;
        }

        public void onStateChanged() {
            this.subscriberB.onStateChanged();
            this.subscriptionB.unsubscribe();
        }
    }
}

