/*
 * Decompiled with CFR 0.152.
 */
package jupyter;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import jupyter.AsDisplayData;
import jupyter.Displayer;
import jupyter.ToStringDisplayer;

public class Registration {
    static final Registration INSTANCE = new Registration();
    private final Map<Class<?>, Displayer<?>> displayers = new HashMap();
    private Displayer<Object> defaultDisplayer = ToStringDisplayer.get();
    private String[] mimeTypes = null;
    private static Displayer<AsDisplayData> asDisplayDataDisplayer = new Displayer<AsDisplayData>(){

        @Override
        public Map<String, String> display(AsDisplayData obj) {
            return obj.display();
        }
    };

    private void init() {
        this.add(AsDisplayData.class, asDisplayDataDisplayer);
    }

    public Registration() {
        this.init();
    }

    public Map<Class<?>, Displayer<?>> getAll() {
        return Collections.unmodifiableMap(this.displayers);
    }

    public void setMimeTypes(String ... types) {
        this.mimeTypes = types;
        for (Displayer<?> displayer : this.displayers.values()) {
            displayer.setMimeTypes(types);
        }
        if (this.defaultDisplayer != null) {
            this.defaultDisplayer.setMimeTypes(types);
        }
    }

    public void setDefault(Displayer<Object> displayer) {
        this.defaultDisplayer = displayer;
    }

    public <T> void add(Class<T> objClass, Displayer<T> displayer) {
        if (this.mimeTypes != null) {
            displayer.setMimeTypes(this.mimeTypes);
        }
        this.displayers.put(objClass, displayer);
    }

    public <T> Displayer<? super T> find(Class<T> objClass) {
        HashSet<Class<Object>> visited = new HashSet<Class<Object>>();
        visited.add(Object.class);
        LinkedList classes = new LinkedList();
        classes.addLast(objClass);
        while (!classes.isEmpty()) {
            Class currentClass = (Class)classes.removeFirst();
            Displayer<?> displayer = this.displayers.get(currentClass);
            if (displayer != null) {
                return displayer;
            }
            for (Class<?> iface : currentClass.getInterfaces()) {
                if (visited.contains(iface)) continue;
                classes.add(iface);
            }
            Class superClass = currentClass.getSuperclass();
            if (superClass == null || visited.contains(superClass)) continue;
            classes.add(superClass);
        }
        return this.defaultDisplayer;
    }

    void clear() {
        this.displayers.clear();
        this.defaultDisplayer = ToStringDisplayer.get();
        this.init();
    }
}

