/*
 * Decompiled with CFR 0.152.
 */
package jupyter;

import java.util.Collections;
import java.util.Map;
import jupyter.Displayer;
import jupyter.Registration;

public abstract class Displayers {
    public static Registration registration() {
        return Registration.INSTANCE;
    }

    public static <T> void register(Class<T> objClass, Displayer<T> displayer) {
        Displayers.registration().add(objClass, displayer);
    }

    public static void setMimeTypes(String ... types) {
        Displayers.registration().setMimeTypes(types);
    }

    public static <T> Map<String, String> display(T obj) {
        Displayer<?> displayer = Displayers.registration().find(obj.getClass());
        if (displayer != null) {
            return displayer.display(obj);
        }
        return Collections.emptyMap();
    }
}

