/*
 * Decompiled with CFR 0.152.
 */
package com.github.juanlabrador.badgecounter;

import android.app.Activity;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.github.juanlabrador.badgecounter.R;

public class BadgeCounter {
    public static void update(Activity activity, MenuItem menu, int icon, int count) {
        if (count == Integer.MIN_VALUE) {
            BadgeCounter.update(activity, menu, activity.getResources().getDrawable(icon), BadgeColor.RED, null);
        } else {
            BadgeCounter.update(activity, menu, activity.getResources().getDrawable(icon), BadgeColor.RED, String.valueOf(count));
        }
    }

    public static void update(Activity activity, MenuItem menu, Drawable icon, int count) {
        if (count == Integer.MIN_VALUE) {
            BadgeCounter.update(activity, menu, icon, BadgeColor.RED, null);
        } else {
            BadgeCounter.update(activity, menu, icon, BadgeColor.RED, String.valueOf(count));
        }
    }

    public static void update(Activity activity, MenuItem menu, int icon, String count) {
        BadgeCounter.update(activity, menu, activity.getResources().getDrawable(icon), BadgeColor.RED, count);
    }

    public static void update(Activity activity, MenuItem menu, int icon, BadgeColor color, int counter) {
        BadgeCounter.update(activity, menu, activity.getResources().getDrawable(icon), color, String.valueOf(counter));
    }

    public static void update(Activity activity, MenuItem menu, int icon, BadgeColor color, String counter) {
        BadgeCounter.update(activity, menu, activity.getResources().getDrawable(icon), color, counter);
    }

    public static void update(Activity act, MenuItem menu, Drawable icon, BadgeColor color, int counter) {
        if (counter == Integer.MIN_VALUE) {
            BadgeCounter.update(act, menu, icon, color, null);
        } else {
            BadgeCounter.update(act, menu, icon, color, String.valueOf(counter));
        }
    }

    public static void update(MenuItem menu, int counter) {
        BadgeCounter.update(menu, null, counter);
    }

    public static void update(MenuItem menu, String counter) {
        BadgeCounter.update(menu, null, counter);
    }

    public static void update(MenuItem menu, Drawable icon, int counter) {
        if (counter == Integer.MIN_VALUE) {
            BadgeCounter.update(null, menu, icon, null, null);
        } else {
            BadgeCounter.update(null, menu, icon, null, String.valueOf(counter));
        }
    }

    public static void update(MenuItem menu, Drawable icon, String counter) {
        if (counter == null) {
            BadgeCounter.update(null, menu, icon, null, null);
        } else {
            BadgeCounter.update(null, menu, icon, null, String.valueOf(counter));
        }
    }

    public static void update(final Activity activity, final MenuItem menu, Drawable icon, BadgeColor color, String counter) {
        if (menu == null) {
            return;
        }
        GradientDrawable mDrawable = new GradientDrawable();
        RelativeLayout mContainer = color == null ? (RelativeLayout)menu.getActionView() : (RelativeLayout)menu.setActionView(R.layout.badge_counter).getActionView();
        TextView mBadgeCount = (TextView)mContainer.findViewById(R.id.count_badge);
        ImageView mIconBadge = (ImageView)mContainer.findViewById(R.id.icon_badge);
        if (icon != null) {
            mIconBadge.setImageDrawable(icon);
        }
        if (color != null) {
            mDrawable.setCornerRadius(5.0f);
            mDrawable.setColor(color.getColor());
            mBadgeCount.setPadding(2, 0, 2, 1);
            mBadgeCount.setBackground((Drawable)mDrawable);
        }
        if (activity != null) {
            mContainer.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    activity.onOptionsItemSelected(menu);
                }
            });
        }
        if (counter == null) {
            mBadgeCount.setVisibility(8);
        } else {
            mBadgeCount.setVisibility(0);
            mBadgeCount.setText((CharSequence)counter);
        }
        menu.setVisible(true);
    }

    public static void hide(MenuItem menu) {
        menu.setVisible(false);
    }

    public static enum BadgeColor {
        GREY(Color.parseColor((String)"#9E9E9E")),
        BLUE_GREY(Color.parseColor((String)"#607D8B")),
        RED(Color.parseColor((String)"#f44336")),
        BLUE(Color.parseColor((String)"#2196F3")),
        CYAN(Color.parseColor((String)"#00BCD4")),
        TEAL(Color.parseColor((String)"#009688")),
        GREEN(Color.parseColor((String)"#4CAF50")),
        YELLOW(Color.parseColor((String)"#FFEB3B")),
        ORANGE(Color.parseColor((String)"#FF9800")),
        DEEP_ORANGE(Color.parseColor((String)"#FF5722")),
        PURPLE(Color.parseColor((String)"#9C27B0")),
        LIGHT_BLUE(Color.parseColor((String)"#03A9F4")),
        LIGHT_GREEN(Color.parseColor((String)"#8BC34A")),
        BLACK(Color.parseColor((String)"#000000"));

        private int color;

        private BadgeColor(int color) {
            this.color = color;
        }

        public int getColor() {
            return this.color;
        }
    }
}

