/*
 * Decompiled with CFR 0.152.
 */
package org.jsfr.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.jsfr.json.JsonProvider;
import org.jsfr.json.exception.JsonSurfingException;

public class JacksonProvider
implements JsonProvider<ObjectNode, ArrayNode, JsonNode> {
    private static ObjectMapper OM = new ObjectMapper();
    private static JsonNodeFactory FACTORY = OM.getNodeFactory();

    public ObjectNode createObject() {
        return FACTORY.objectNode();
    }

    public ArrayNode createArray() {
        return FACTORY.arrayNode();
    }

    public boolean isObject(Object object) {
        return object instanceof ObjectNode;
    }

    public boolean isArray(Object array) {
        return array instanceof ArrayNode;
    }

    public void consumeObjectEntry(ObjectNode object, String key, JsonNode value) {
        object.set(key, value);
    }

    public void consumeArrayElement(ArrayNode array, JsonNode value) {
        array.add(value);
    }

    public JsonNode primitive(boolean value) {
        return FACTORY.booleanNode(value);
    }

    public JsonNode primitive(int value) {
        return FACTORY.numberNode(value);
    }

    public JsonNode primitive(double value) {
        return FACTORY.numberNode(value);
    }

    public JsonNode primitive(String value) {
        return FACTORY.textNode(value);
    }

    public JsonNode primitiveNull() {
        return FACTORY.nullNode();
    }

    public <T> T cast(JsonNode value, Class<T> tClass) {
        try {
            if (OM.canDeserialize(OM.getTypeFactory().constructType(tClass))) {
                return (T)OM.treeToValue((TreeNode)value, tClass);
            }
            return (T)value;
        }
        catch (JsonProcessingException e) {
            throw new JsonSurfingException((Throwable)e);
        }
    }
}

