/*
 * Decompiled with CFR 0.152.
 */
package org.jsfr.json;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import org.jsfr.json.AbstractPrimitiveHolder;
import org.jsfr.json.JsonParserAdapter;
import org.jsfr.json.NonBlockingParser;
import org.jsfr.json.PrimitiveHolder;
import org.jsfr.json.ResumableParser;
import org.jsfr.json.SurfingContext;
import org.jsfr.json.provider.JsonProvider;

public class GsonParser
implements JsonParserAdapter {
    public static final GsonParser INSTANCE = new GsonParser();

    private GsonParser() {
    }

    public void parse(Reader reader, SurfingContext context) {
        this.createResumableParser(reader, context).parse();
    }

    public void parse(String json, SurfingContext context) {
        this.createResumableParser(json, context).parse();
    }

    public void parse(InputStream inputStream, SurfingContext context) {
        this.createResumableParser(inputStream, context).parse();
    }

    public ResumableParser createResumableParser(Reader reader, SurfingContext context) {
        return this.createResumableParserImpl(reader, context);
    }

    private ResumableParser createResumableParserImpl(Reader reader, SurfingContext context) {
        final JsonReader jsonReader = new JsonReader(reader);
        final JsonProvider jsonProvider = context.getConfig().getJsonProvider();
        AbstractPrimitiveHolder stringHolder = new AbstractPrimitiveHolder(context.getConfig()){

            public Object doGetValue() throws IOException {
                return jsonProvider.primitive(jsonReader.nextString());
            }

            public void doSkipValue() throws IOException {
                jsonReader.skipValue();
            }
        };
        AbstractPrimitiveHolder numberHolder = new AbstractPrimitiveHolder(context.getConfig()){

            public Object doGetValue() throws IOException {
                return jsonProvider.primitive(jsonReader.nextDouble());
            }

            public void doSkipValue() throws IOException {
                jsonReader.skipValue();
            }
        };
        AbstractPrimitiveHolder booleanHolder = new AbstractPrimitiveHolder(context.getConfig()){

            public Object doGetValue() throws IOException {
                return jsonProvider.primitive(jsonReader.nextBoolean());
            }

            public void doSkipValue() throws IOException {
                jsonReader.skipValue();
            }
        };
        AbstractPrimitiveHolder nullHolder = new AbstractPrimitiveHolder(context.getConfig()){

            public Object doGetValue() throws IOException {
                jsonReader.nextNull();
                return jsonProvider.primitiveNull();
            }

            public void doSkipValue() throws IOException {
                jsonReader.skipValue();
            }
        };
        return new GsonResumableParser(jsonReader, context, stringHolder, numberHolder, booleanHolder, nullHolder);
    }

    public ResumableParser createResumableParser(String json, SurfingContext context) {
        return this.createResumableParser(new StringReader(json), context);
    }

    public ResumableParser createResumableParser(InputStream json, SurfingContext context) {
        return this.createResumableParserImpl(new InputStreamReader(json, context.getConfig().getParserCharset()), context);
    }

    public NonBlockingParser createNonBlockingParser(SurfingContext context) {
        throw new UnsupportedOperationException("Unsupported");
    }

    private static class GsonResumableParser
    implements ResumableParser {
        private JsonReader jsonReader;
        private SurfingContext context;
        private AbstractPrimitiveHolder stringHolder;
        private AbstractPrimitiveHolder numberHolder;
        private AbstractPrimitiveHolder booleanHolder;
        private AbstractPrimitiveHolder nullHolder;

        public GsonResumableParser(JsonReader jsonReader, SurfingContext context, AbstractPrimitiveHolder stringHolder, AbstractPrimitiveHolder numberHolder, AbstractPrimitiveHolder booleanHolder, AbstractPrimitiveHolder nullHolder) {
            this.jsonReader = jsonReader;
            this.context = context;
            this.stringHolder = stringHolder;
            this.numberHolder = numberHolder;
            this.booleanHolder = booleanHolder;
            this.nullHolder = nullHolder;
        }

        public void parse() {
            this.context.startJSON();
            this.doParse();
        }

        public boolean resume() {
            try {
                if (!this.context.isPaused()) {
                    return false;
                }
                this.context.resume();
                this.doParse();
                return true;
            }
            catch (Exception e) {
                this.context.getConfig().getErrorHandlingStrategy().handleParsingException(e);
                return false;
            }
        }

        private void doParse() {
            try {
                while (!this.context.shouldBreak()) {
                    JsonToken token = this.jsonReader.peek();
                    switch (token) {
                        case BEGIN_ARRAY: {
                            this.jsonReader.beginArray();
                            this.context.startArray();
                            break;
                        }
                        case END_ARRAY: {
                            this.jsonReader.endArray();
                            this.context.endArray();
                            break;
                        }
                        case BEGIN_OBJECT: {
                            this.jsonReader.beginObject();
                            this.context.startObject();
                            break;
                        }
                        case END_OBJECT: {
                            this.jsonReader.endObject();
                            this.context.endObject();
                            break;
                        }
                        case NAME: {
                            String name = this.jsonReader.nextName();
                            this.context.startObjectEntry(name);
                            break;
                        }
                        case STRING: {
                            this.stringHolder.init();
                            this.context.primitive((PrimitiveHolder)this.stringHolder);
                            this.stringHolder.skipValue();
                            break;
                        }
                        case NUMBER: {
                            this.numberHolder.init();
                            this.context.primitive((PrimitiveHolder)this.numberHolder);
                            this.numberHolder.skipValue();
                            break;
                        }
                        case BOOLEAN: {
                            this.booleanHolder.init();
                            this.context.primitive((PrimitiveHolder)this.booleanHolder);
                            this.booleanHolder.skipValue();
                            break;
                        }
                        case NULL: {
                            this.nullHolder.init();
                            this.context.primitive((PrimitiveHolder)this.nullHolder);
                            this.nullHolder.skipValue();
                            break;
                        }
                        case END_DOCUMENT: {
                            this.context.endJSON();
                        }
                    }
                }
            }
            catch (Exception e) {
                this.context.getConfig().getErrorHandlingStrategy().handleParsingException(e);
            }
        }
    }
}

