/*
 * Decompiled with CFR 0.152.
 */
package org.jsfr.json;

import java.util.ArrayList;
import java.util.Collection;
import org.jsfr.json.BufferedListener;
import org.jsfr.json.JsonPathListener;
import org.jsfr.json.JsonPosition;
import org.jsfr.json.JsonSaxHandler;
import org.jsfr.json.PrimitiveHolder;
import org.jsfr.json.SurfingConfiguration;
import org.jsfr.json.filter.CloneableJsonPathFilter;
import org.jsfr.json.filter.JsonPathFilter;

public class JsonFilterVerifier
implements JsonSaxHandler {
    private final int startDepth;
    private SurfingConfiguration config;
    private SurfingConfiguration.Binding binding;
    private JsonPathFilter jsonPathFilter;
    private Collection<BufferedListener> bufferedListeners;
    private Collection<JsonFilterVerifier> dependencies;
    private JsonPosition currentPosition;
    private boolean verified = false;
    private int stackDepth = 0;

    public JsonFilterVerifier(JsonPosition currentPosition, SurfingConfiguration config, SurfingConfiguration.Binding binding) {
        this.currentPosition = currentPosition;
        this.startDepth = currentPosition.pathDepth();
        this.config = config;
        this.binding = binding;
        this.jsonPathFilter = (JsonPathFilter)((CloneableJsonPathFilter)binding.filter).cloneMe();
        this.bufferedListeners = new ArrayList<BufferedListener>();
    }

    public int getStartDepth() {
        return this.startDepth;
    }

    public void setDependencies(Collection<JsonFilterVerifier> dependencies) {
        this.dependencies = dependencies;
    }

    public JsonPathListener addListener(JsonPathListener listener) {
        BufferedListener newListener = new BufferedListener(this.config, listener);
        this.bufferedListeners.add(newListener);
        return newListener;
    }

    private void invokeBuffer() {
        if (this.dependencies != null) {
            for (JsonFilterVerifier dependency : this.dependencies) {
                dependency.bufferedListeners.addAll(this.bufferedListeners);
            }
        } else {
            for (BufferedListener buffer : this.bufferedListeners) {
                buffer.invokeBufferedValue();
            }
        }
    }

    @Override
    public boolean startJSON() {
        return true;
    }

    @Override
    public boolean endJSON() {
        return false;
    }

    @Override
    public boolean startObject() {
        ++this.stackDepth;
        return true;
    }

    @Override
    public boolean startObjectEntry(String key) {
        if (!this.verified && this.jsonPathFilter.apply(this.currentPosition, this.startDepth, null, this.config.getJsonProvider())) {
            this.verified = true;
        }
        return true;
    }

    @Override
    public boolean endObject() {
        return this.endObjectOrArray();
    }

    @Override
    public boolean startArray() {
        ++this.stackDepth;
        return true;
    }

    @Override
    public boolean endArray() {
        return this.endObjectOrArray();
    }

    private boolean endObjectOrArray() {
        --this.stackDepth;
        if (this.stackDepth == 0) {
            if (this.verified) {
                this.invokeBuffer();
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean primitive(PrimitiveHolder primitiveHolder) {
        if (!this.verified && this.jsonPathFilter.apply(this.currentPosition, this.startDepth, primitiveHolder, this.config.getJsonProvider())) {
            this.verified = true;
        }
        return true;
    }
}

