/*
 * Decompiled with CFR 0.152.
 */
package org.jsfr.json;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jsfr.json.ContentDispatcher;
import org.jsfr.json.JsonFilterVerifier;
import org.jsfr.json.JsonPathListener;
import org.jsfr.json.JsonPosition;
import org.jsfr.json.JsonSaxHandler;
import org.jsfr.json.SurfingConfiguration;

public class FilterVerifierDispatcher
extends ContentDispatcher {
    private final Map<SurfingConfiguration.Binding, List<JsonFilterVerifier>> verifiers = new HashMap<SurfingConfiguration.Binding, List<JsonFilterVerifier>>();

    public void addVerifier(SurfingConfiguration.Binding binding, JsonFilterVerifier verifier) {
        List<JsonFilterVerifier> dependencies;
        this.addReceiver(verifier);
        if (binding.dependency != null && (dependencies = this.verifiers.get(binding.dependency)) != null) {
            List<JsonFilterVerifier> filtered = dependencies.stream().filter(d -> d.getStartDepth() < verifier.getStartDepth()).collect(Collectors.toList());
            verifier.setDependencies(filtered);
        }
        this.verifiers.compute(binding, (binding1, prev) -> {
            ArrayList<JsonFilterVerifier> verifiers = prev == null ? new ArrayList<JsonFilterVerifier>() : prev;
            verifiers.add(verifier);
            return verifiers;
        });
    }

    public List<JsonPathListener> dispatch(JsonPosition jsonPosition, SurfingConfiguration.Binding binding) {
        int pathDepth = jsonPosition.pathDepth();
        SurfingConfiguration.Binding dependency = binding.dependency;
        JsonPathListener[] listeners = binding.getListeners();
        ArrayList<JsonPathListener> rst = new ArrayList<JsonPathListener>();
        List<JsonFilterVerifier> dependencies = this.verifiers.get(dependency);
        if (dependencies != null) {
            for (JsonFilterVerifier verifier : dependencies) {
                if (!binding.jsonPath.matchFilterPathUntilDepth(jsonPosition, verifier.getStartDepth()) || verifier.getStartDepth() > pathDepth) continue;
                for (JsonPathListener listener : listeners) {
                    rst.add(verifier.addListener(listener));
                }
            }
        }
        return rst;
    }

    @Override
    protected void onRemove(JsonSaxHandler item) {
        for (Map.Entry<SurfingConfiguration.Binding, List<JsonFilterVerifier>> entry : this.verifiers.entrySet()) {
            entry.getValue().remove(item);
        }
    }
}

