/*
 * Decompiled with CFR 0.152.
 */
package org.jsfr.json.filter;

import java.math.BigDecimal;
import org.jsfr.json.PrimitiveHolder;
import org.jsfr.json.filter.BasicJsonPathFilter;
import org.jsfr.json.path.JsonPath;
import org.jsfr.json.provider.JsonProvider;

public class LessThanNumPredicate
extends BasicJsonPathFilter {
    private BigDecimal value;

    public LessThanNumPredicate(JsonPath relativePath, BigDecimal value) {
        super(relativePath);
        this.value = value;
    }

    @Override
    public boolean apply(JsonPath jsonPosition, int startDepth, PrimitiveHolder primitiveHolder, JsonProvider jsonProvider) {
        if (primitiveHolder != null && this.getRelativePath().matchFilterPath(jsonPosition, startDepth)) {
            Object candidate = primitiveHolder.getValue();
            return candidate != null && new BigDecimal(candidate.toString()).compareTo(this.value) < 0;
        }
        return false;
    }
}

