/*
 * Decompiled with CFR 0.152.
 */
package org.jsfr.json.filter;

import java.util.Objects;
import org.jsfr.json.PrimitiveHolder;
import org.jsfr.json.filter.BasicJsonPathFilter;
import org.jsfr.json.path.JsonPath;
import org.jsfr.json.provider.JsonProvider;

public class EqualityStrPredicate
extends BasicJsonPathFilter {
    private String value;

    public EqualityStrPredicate(JsonPath relativePath, String value) {
        super(relativePath);
        this.value = value;
    }

    @Override
    public boolean apply(JsonPath jsonPosition, int startDepth, PrimitiveHolder primitiveHolder, JsonProvider jsonProvider) {
        if (primitiveHolder != null && this.getRelativePath().matchFilterPath(jsonPosition, startDepth)) {
            Object candidate = primitiveHolder.getValue();
            return candidate != null && Objects.equals(candidate, jsonProvider.primitive(this.value));
        }
        return false;
    }
}

