/*
 * Decompiled with CFR 0.152.
 */
package org.jsfr.json.path;

import org.jsfr.json.path.PathOperator;
import org.jsfr.json.resolver.DocumentResolver;

public class ArrayIndex
extends PathOperator {
    private int arrayIndex = -1;

    public ArrayIndex() {
    }

    public ArrayIndex(int arrayIndex) {
        this();
        this.arrayIndex = arrayIndex;
    }

    public int getArrayIndex() {
        return this.arrayIndex;
    }

    public void reset() {
        this.arrayIndex = -1;
    }

    public void setArrayIndex(int arrayIndex) {
        this.arrayIndex = arrayIndex;
    }

    public void increaseArrayIndex() {
        ++this.arrayIndex;
    }

    @Override
    public boolean match(PathOperator pathOperator) {
        return super.match(pathOperator) && this.arrayIndex == ((ArrayIndex)pathOperator).arrayIndex;
    }

    @Override
    public Object resolve(Object document, DocumentResolver resolver) {
        return resolver.resolve(document, this.arrayIndex);
    }

    @Override
    public PathOperator.Type getType() {
        return PathOperator.Type.ARRAY;
    }

    public String toString() {
        return "[" + this.arrayIndex + "]";
    }
}

