/*
 * Decompiled with CFR 0.152.
 */
package org.jsfr.json;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.jsfr.json.ContentDispatcher;
import org.jsfr.json.FilteredJsonPathListener;
import org.jsfr.json.JsonCollector;
import org.jsfr.json.JsonPathListener;
import org.jsfr.json.JsonPosition;
import org.jsfr.json.JsonSaxHandler;
import org.jsfr.json.ParsingContext;
import org.jsfr.json.PrimitiveHolder;
import org.jsfr.json.SurfingConfiguration;
import org.jsfr.json.path.ArrayIndex;
import org.jsfr.json.path.ChildNode;
import org.jsfr.json.path.PathOperator;

class SurfingContext
implements ParsingContext,
JsonSaxHandler {
    private boolean stopped = false;
    private boolean paused = false;
    private JsonPosition currentPosition;
    private ContentDispatcher dispatcher = new ContentDispatcher();
    private SurfingConfiguration config;
    private Map<String, Object> transientMap;

    SurfingContext(SurfingConfiguration config) {
        this.config = config;
    }

    private void doMatching(PrimitiveHolder primitiveHolder) {
        SurfingConfiguration.Binding[] bindings;
        if (this.config.isSkipOverlappedPath() && !this.dispatcher.isEmpty()) {
            return;
        }
        LinkedList<JsonPathListener> listeners = null;
        int currentDepth = this.currentPosition.pathDepth();
        for (SurfingConfiguration.IndefinitePathBinding binding : this.config.getIndefinitePathLookup()) {
            if (binding.minimumPathDepth > currentDepth) break;
            listeners = this.doMatching(binding, primitiveHolder, listeners);
        }
        if ((bindings = this.config.getDefinitePathBind(currentDepth)) != null) {
            for (SurfingConfiguration.Binding binding : bindings) {
                listeners = this.doMatching(binding, primitiveHolder, listeners);
            }
        }
        if (listeners != null) {
            JsonCollector collector = new JsonCollector(listeners.size() == 1 ? Collections.singleton(listeners.getFirst()) : listeners, this, this.config.getErrorHandlingStrategy());
            collector.setProvider(this.config.getJsonProvider());
            this.dispatcher.addReceiver(collector);
        }
    }

    private LinkedList<JsonPathListener> doMatching(SurfingConfiguration.Binding binding, PrimitiveHolder primitiveHolder, LinkedList<JsonPathListener> listeners) {
        if (binding.jsonPath.match(this.currentPosition)) {
            if (primitiveHolder != null) {
                this.dispatchPrimitive(binding, primitiveHolder.getValue());
            } else {
                LinkedList<JsonPathListener> listenersToAdd;
                LinkedList<JsonPathListener> linkedList = listenersToAdd = listeners == null ? new LinkedList<JsonPathListener>() : listeners;
                if (binding.jsonPath.getJsonPathFilter() != null) {
                    for (JsonPathListener jsonPathListener : binding.listeners) {
                        listenersToAdd.add(new FilteredJsonPathListener(binding.jsonPath.getJsonPathFilter(), jsonPathListener, this.config));
                    }
                } else {
                    Collections.addAll(listenersToAdd, binding.listeners);
                }
                return listenersToAdd;
            }
        }
        return listeners;
    }

    private void dispatchPrimitive(SurfingConfiguration.Binding binding, Object primitive) {
        for (JsonPathListener listener : binding.listeners) {
            if (this.isStopped()) break;
            try {
                listener.onValue(primitive, this);
            }
            catch (Exception e) {
                this.config.getErrorHandlingStrategy().handleExceptionFromListener(e, this);
            }
        }
    }

    @Override
    public boolean startJSON() {
        this.currentPosition = JsonPosition.start();
        this.doMatching(null);
        this.dispatcher.startJSON();
        return true;
    }

    @Override
    public boolean endJSON() {
        this.dispatcher.endJSON();
        this.currentPosition.clear();
        this.currentPosition = null;
        this.stop();
        return true;
    }

    @Override
    public boolean startObject() {
        if (this.shouldBreak()) {
            return false;
        }
        PathOperator currentNode = this.currentPosition.peek();
        switch (currentNode.getType()) {
            case OBJECT: {
                this.doMatching(null);
                break;
            }
            case ARRAY: {
                this.accumulateArrayIndex((ArrayIndex)currentNode);
                this.doMatching(null);
                break;
            }
            case ROOT: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.currentPosition.stepIntoObject();
        this.dispatcher.startObject();
        return true;
    }

    @Override
    public boolean endObject() {
        if (this.shouldBreak()) {
            return false;
        }
        this.currentPosition.stepOutObject();
        this.dispatcher.endObject();
        return true;
    }

    @Override
    public boolean startObjectEntry(String key) {
        if (this.shouldBreak()) {
            return false;
        }
        this.currentPosition.updateObjectEntry(key);
        this.dispatcher.startObjectEntry(key);
        return true;
    }

    @Override
    public boolean startArray() {
        if (this.shouldBreak()) {
            return false;
        }
        PathOperator currentNode = this.currentPosition.peek();
        switch (currentNode.getType()) {
            case OBJECT: {
                this.doMatching(null);
                break;
            }
            case ARRAY: {
                this.accumulateArrayIndex((ArrayIndex)currentNode);
                this.doMatching(null);
                break;
            }
            case ROOT: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.currentPosition.stepIntoArray();
        this.dispatcher.startArray();
        return true;
    }

    private void accumulateArrayIndex(ArrayIndex arrayIndex) {
        arrayIndex.increaseArrayIndex();
    }

    @Override
    public boolean endArray() {
        if (this.shouldBreak()) {
            return false;
        }
        this.currentPosition.stepOutArray();
        this.dispatcher.endArray();
        return true;
    }

    @Override
    public boolean primitive(PrimitiveHolder primitiveHolder) {
        if (this.shouldBreak()) {
            return false;
        }
        PathOperator currentNode = this.currentPosition.peek();
        switch (currentNode.getType()) {
            case OBJECT: {
                this.doMatching(primitiveHolder);
                break;
            }
            case ARRAY: {
                this.accumulateArrayIndex((ArrayIndex)currentNode);
                this.doMatching(primitiveHolder);
                break;
            }
            case ROOT: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.dispatcher.primitive(primitiveHolder);
        return true;
    }

    @Override
    public String getJsonPath() {
        return this.currentPosition.toString();
    }

    @Override
    public String getCurrentFieldName() {
        PathOperator top = this.currentPosition.peek();
        if (top instanceof ChildNode) {
            return ((ChildNode)top).getKey();
        }
        return null;
    }

    @Override
    public int getCurrentArrayIndex() {
        PathOperator top = this.currentPosition.peek();
        if (top.getType() == PathOperator.Type.ARRAY) {
            return ((ArrayIndex)top).getArrayIndex();
        }
        return -1;
    }

    @Override
    public void save(String key, Object value) {
        if (this.transientMap == null) {
            this.transientMap = new HashMap<String, Object>();
        }
        this.transientMap.put(key, value);
    }

    @Override
    public <T> T load(String key, Class<T> tClass) {
        return this.transientMap != null ? (T)tClass.cast(this.transientMap.get(key)) : null;
    }

    @Override
    public <T> T cast(Object object, Class<T> tClass) {
        return this.config.getJsonProvider().cast(object, tClass);
    }

    public boolean shouldBreak() {
        return this.stopped || this.paused;
    }

    @Override
    public void stop() {
        this.stopped = true;
        this.paused = false;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public void pause() {
        this.paused = true;
    }

    @Override
    public void resume() {
        this.paused = false;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    public SurfingConfiguration getConfig() {
        return this.config;
    }
}

