/*
 * Decompiled with CFR 0.152.
 */
package org.jsfr.json;

import java.util.Collection;
import org.jsfr.json.ErrorHandlingStrategy;
import org.jsfr.json.JsonDomBuilder;
import org.jsfr.json.JsonPathListener;
import org.jsfr.json.ParsingContext;

class JsonCollector
extends JsonDomBuilder {
    private ErrorHandlingStrategy errorHandlingStrategy;
    private Collection<JsonPathListener> jsonPathListeners;
    private ParsingContext context;

    public JsonCollector(Collection<JsonPathListener> jsonPathListeners, ParsingContext context, ErrorHandlingStrategy errorHandlingStrategy) {
        this.jsonPathListeners = jsonPathListeners;
        this.context = context;
        this.errorHandlingStrategy = errorHandlingStrategy;
    }

    @Override
    public boolean endObject() {
        super.endObject();
        if (this.isInRoot()) {
            Object result = this.peekValue();
            for (JsonPathListener jsonPathListener : this.jsonPathListeners) {
                if (this.context.isStopped()) continue;
                try {
                    jsonPathListener.onValue(result, this.context);
                }
                catch (Exception e) {
                    this.errorHandlingStrategy.handleExceptionFromListener(e, this.context);
                }
            }
            this.clear();
            return false;
        }
        return true;
    }

    @Override
    public boolean endArray() {
        super.endArray();
        if (this.isInRoot()) {
            Object result = this.peekValue();
            for (JsonPathListener jsonPathListener : this.jsonPathListeners) {
                if (this.context.isStopped()) continue;
                try {
                    jsonPathListener.onValue(result, this.context);
                }
                catch (Exception e) {
                    this.errorHandlingStrategy.handleExceptionFromListener(e, this.context);
                }
            }
            this.clear();
            return false;
        }
        return true;
    }

    @Override
    public void clear() {
        super.clear();
        this.context = null;
        this.jsonPathListeners = null;
        this.errorHandlingStrategy = null;
    }
}

