/*
 * Decompiled with CFR 0.152.
 */
package org.jsfr.json.compiler;

import java.math.BigDecimal;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.jsfr.json.compiler.JsonPathBaseVisitor;
import org.jsfr.json.compiler.JsonPathLexer;
import org.jsfr.json.compiler.JsonPathParser;
import org.jsfr.json.filter.EqualityNumPredicate;
import org.jsfr.json.filter.EqualityStrPredicate;
import org.jsfr.json.filter.ExistencePredicate;
import org.jsfr.json.filter.FilterBuilder;
import org.jsfr.json.filter.GreaterThanNumPredicate;
import org.jsfr.json.filter.LessThanNumPredicate;
import org.jsfr.json.path.JsonPath;

public class JsonPathCompiler
extends JsonPathBaseVisitor<Void> {
    private JsonPath.Builder pathBuilder;
    private FilterBuilder filterBuilder;
    private JsonPath.Builder filterPathBuilder;

    @Override
    public Void visitPath(JsonPathParser.PathContext ctx) {
        this.pathBuilder = JsonPath.Builder.start();
        return (Void)super.visitPath(ctx);
    }

    private JsonPath.Builder currentPathBuilder() {
        return this.filterPathBuilder != null ? this.filterPathBuilder : this.pathBuilder;
    }

    @Override
    public Void visitSearchChild(JsonPathParser.SearchChildContext ctx) {
        this.currentPathBuilder().scan().child(ctx.KEY().getText());
        return (Void)super.visitSearchChild(ctx);
    }

    @Override
    public Void visitSearch(JsonPathParser.SearchContext ctx) {
        this.currentPathBuilder().scan();
        return (Void)super.visitSearch(ctx);
    }

    @Override
    public Void visitChildNode(JsonPathParser.ChildNodeContext ctx) {
        this.currentPathBuilder().child(ctx.KEY().getText());
        return (Void)super.visitChildNode(ctx);
    }

    @Override
    public Void visitChildrenNode(JsonPathParser.ChildrenNodeContext ctx) {
        int i = 0;
        String[] strings = new String[ctx.QUOTED_STRING().size()];
        for (TerminalNode node : ctx.QUOTED_STRING()) {
            String quotedString = node.getText();
            strings[i++] = this.removeQuote(quotedString);
        }
        this.currentPathBuilder().children(strings);
        return (Void)super.visitChildren((RuleNode)ctx);
    }

    private String removeQuote(String quotedString) {
        return quotedString.substring(1, quotedString.length() - 1);
    }

    @Override
    public Void visitIndex(JsonPathParser.IndexContext ctx) {
        this.currentPathBuilder().index(Integer.parseInt(ctx.NUM().getText()));
        return (Void)super.visitIndex(ctx);
    }

    @Override
    public Void visitIndexes(JsonPathParser.IndexesContext ctx) {
        int i = 0;
        Integer[] keys = new Integer[ctx.NUM().size()];
        for (TerminalNode key : ctx.NUM()) {
            keys[i++] = Integer.parseInt(key.getText());
        }
        this.currentPathBuilder().indexes(keys);
        return (Void)super.visitIndexes(ctx);
    }

    @Override
    public Void visitSlicing(JsonPathParser.SlicingContext ctx) {
        Integer left = null;
        Integer temp = null;
        for (ParseTree node : ctx.children) {
            if (!(node instanceof TerminalNode)) continue;
            TerminalNode tNode = (TerminalNode)node;
            if (((TerminalNode)node).getSymbol().getType() == 16) {
                left = temp;
                temp = null;
                continue;
            }
            if (tNode.getSymbol().getType() != 19) continue;
            temp = Integer.parseInt(tNode.getText());
        }
        Integer right = temp;
        this.pathBuilder.slicing(left, right);
        return (Void)super.visitSlicing(ctx);
    }

    @Override
    public Void visitAnyChild(JsonPathParser.AnyChildContext ctx) {
        this.currentPathBuilder().anyChild();
        return (Void)super.visitAnyChild(ctx);
    }

    @Override
    public Void visitAnyIndex(JsonPathParser.AnyIndexContext ctx) {
        this.currentPathBuilder().anyIndex();
        return (Void)super.visitAnyIndex(ctx);
    }

    @Override
    public Void visitAny(JsonPathParser.AnyContext ctx) {
        this.currentPathBuilder().any();
        return (Void)super.visitAny(ctx);
    }

    @Override
    public Void visitFilter(JsonPathParser.FilterContext ctx) {
        this.pathBuilder.any();
        this.filterBuilder = new FilterBuilder();
        Void rst = (Void)super.visitFilter(ctx);
        this.pathBuilder.withFilter(this.filterBuilder.build());
        return rst;
    }

    @Override
    public Void visitFilterExpr(JsonPathParser.FilterExprContext ctx) {
        Void rst;
        if (ctx.AndOperator() != null) {
            this.filterBuilder.startAndPredicate();
            rst = (Void)super.visitFilterExpr(ctx);
            this.filterBuilder.endAndPredicate();
        } else if (ctx.OrOperator() != null) {
            this.filterBuilder.startOrPredicate();
            rst = (Void)super.visitFilterExpr(ctx);
            this.filterBuilder.endOrPredicate();
        } else {
            rst = (Void)super.visitFilterExpr(ctx);
        }
        return rst;
    }

    @Override
    public Void visitFilterEqualNum(JsonPathParser.FilterEqualNumContext ctx) {
        this.filterPathBuilder = JsonPath.Builder.start();
        Void rst = (Void)super.visitFilterEqualNum(ctx);
        this.filterBuilder.append(new EqualityNumPredicate(this.filterPathBuilder.build(), new BigDecimal(ctx.NUM().getText())));
        this.filterPathBuilder = null;
        return rst;
    }

    @Override
    public Void visitFilterExist(JsonPathParser.FilterExistContext ctx) {
        this.filterPathBuilder = JsonPath.Builder.start();
        Void rst = (Void)super.visitFilterExist(ctx);
        this.filterBuilder.append(new ExistencePredicate(this.filterPathBuilder.build()));
        this.filterPathBuilder = null;
        return rst;
    }

    @Override
    public Void visitFilterGtNum(JsonPathParser.FilterGtNumContext ctx) {
        this.filterPathBuilder = JsonPath.Builder.start();
        Void rst = (Void)super.visitFilterGtNum(ctx);
        this.filterBuilder.append(new GreaterThanNumPredicate(this.filterPathBuilder.build(), new BigDecimal(ctx.NUM().getText())));
        this.filterPathBuilder = null;
        return rst;
    }

    @Override
    public Void visitFilterLtNum(JsonPathParser.FilterLtNumContext ctx) {
        this.filterPathBuilder = JsonPath.Builder.start();
        Void rst = (Void)super.visitFilterLtNum(ctx);
        this.filterBuilder.append(new LessThanNumPredicate(this.filterPathBuilder.build(), new BigDecimal(ctx.NUM().getText())));
        this.filterPathBuilder = null;
        return rst;
    }

    @Override
    public Void visitFilterEqualStr(JsonPathParser.FilterEqualStrContext ctx) {
        this.filterPathBuilder = JsonPath.Builder.start();
        Void rst = (Void)super.visitFilterEqualStr(ctx);
        this.filterBuilder.append(new EqualityStrPredicate(this.filterPathBuilder.build(), this.removeQuote(ctx.QUOTED_STRING().getText())));
        this.filterPathBuilder = null;
        return rst;
    }

    public static JsonPath[] compile(String ... paths) {
        JsonPath[] jsonPaths = new JsonPath[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            jsonPaths[i] = JsonPathCompiler.compile(paths[i]);
        }
        return jsonPaths;
    }

    public static JsonPath compile(String path) {
        JsonPathLexer lexer = new JsonPathLexer((CharStream)CharStreams.fromString((String)path));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        JsonPathParser parser = new JsonPathParser((TokenStream)tokens);
        parser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
        JsonPathParser.PathContext tree = parser.path();
        JsonPathCompiler compiler = new JsonPathCompiler();
        compiler.visit((ParseTree)tree);
        return compiler.pathBuilder.build();
    }
}

