/*
 * Decompiled with CFR 0.152.
 */
package org.jsfr.json.path;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import org.jsfr.json.path.AnyChild;
import org.jsfr.json.path.AnyIndex;
import org.jsfr.json.path.ArrayIndex;
import org.jsfr.json.path.ArrayIndexes;
import org.jsfr.json.path.ArraySlicing;
import org.jsfr.json.path.ChildNode;
import org.jsfr.json.path.ChildrenNode;
import org.jsfr.json.path.DeepScan;
import org.jsfr.json.path.PathOperator;
import org.jsfr.json.path.Root;
import org.jsfr.json.path.Wildcard;
import org.jsfr.json.resolver.DocumentResolver;

public class JsonPath
implements Iterable<PathOperator> {
    private boolean definite = true;
    private int minimumDepth = 0;
    protected Stack<PathOperator> operators = new Stack();

    @Override
    public Iterator<PathOperator> iterator() {
        return this.getOperators().iterator();
    }

    public Object resolve(Object document, DocumentResolver resolver) {
        if (!this.isDefinite()) {
            throw new IllegalArgumentException("Indefinite JsonPath is not supported.");
        }
        Object current = document;
        for (PathOperator pathOperator : this) {
            current = pathOperator.resolve(current, resolver);
        }
        return current;
    }

    public boolean match(JsonPath jsonPath) {
        PathOperator peek2;
        PathOperator peek1 = this.operators.peek();
        if (!peek1.match(peek2 = jsonPath.operators.peek())) {
            return false;
        }
        ListIterator iterator1 = this.operators.listIterator(this.operators.size() - 1);
        ListIterator iterator2 = jsonPath.operators.listIterator(jsonPath.operators.size() - 1);
        while (iterator1.hasPrevious()) {
            if (!iterator2.hasPrevious()) {
                return false;
            }
            PathOperator o1 = (PathOperator)iterator1.previous();
            PathOperator o2 = (PathOperator)iterator2.previous();
            if (o1.getType() == PathOperator.Type.DEEP_SCAN) {
                PathOperator prevScan = (PathOperator)iterator1.previous();
                while (!prevScan.match(o2) && iterator2.hasPrevious()) {
                    o2 = (PathOperator)iterator2.previous();
                }
                continue;
            }
            if (o1.match(o2)) continue;
            return false;
        }
        return !iterator2.hasPrevious();
    }

    public PathOperator peek() {
        return this.operators.peek();
    }

    public List<PathOperator> getOperators() {
        return Collections.unmodifiableList(this.operators);
    }

    public int pathDepth() {
        return this.operators.size();
    }

    public int minimumPathDepth() {
        if (this.definite) {
            return this.pathDepth();
        }
        return this.minimumDepth;
    }

    public boolean isDefinite() {
        return this.definite;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (PathOperator operator : this.operators) {
            sb.append(operator);
        }
        return sb.toString();
    }

    public static class Builder {
        private JsonPath jsonPath;

        public static Builder start() {
            Builder builder = new Builder();
            JsonPath newPath = new JsonPath();
            newPath.operators.push(Root.instance());
            builder.jsonPath = newPath;
            return builder;
        }

        public Builder child(String key) {
            this.jsonPath.operators.push(new ChildNode(key));
            return this;
        }

        public Builder children(String ... children) {
            this.jsonPath.operators.push(new ChildrenNode(new HashSet<String>(Arrays.asList(children))));
            return this;
        }

        public Builder anyChild() {
            this.jsonPath.operators.push(AnyChild.instance());
            return this;
        }

        public Builder index(int index) {
            this.jsonPath.operators.push(new ArrayIndex(index));
            return this;
        }

        public Builder indexes(Integer ... indexes) {
            this.jsonPath.operators.push(new ArrayIndexes(new HashSet<Integer>(Arrays.asList(indexes))));
            return this;
        }

        public Builder anyIndex() {
            this.jsonPath.operators.push(AnyIndex.instance());
            return this;
        }

        public Builder scan() {
            this.jsonPath.definite = false;
            if (this.jsonPath.operators.peek().getType() != PathOperator.Type.DEEP_SCAN) {
                this.jsonPath.operators.push(DeepScan.SINGLETON);
            }
            return this;
        }

        public Builder any() {
            this.jsonPath.operators.push(Wildcard.SINGLETON);
            return this;
        }

        public Builder slicing(Integer lower, Integer upper) {
            this.jsonPath.operators.push(new ArraySlicing(lower, upper));
            return this;
        }

        public JsonPath build() {
            if (this.jsonPath.operators.peek().getType() == PathOperator.Type.DEEP_SCAN) {
                throw new IllegalStateException("deep-scan shouldn't be the last operator.");
            }
            if (!this.jsonPath.definite) {
                for (PathOperator operator : this.jsonPath.operators) {
                    if (operator.getType() == PathOperator.Type.DEEP_SCAN) continue;
                    this.jsonPath.minimumDepth++;
                }
            }
            return this.jsonPath;
        }
    }
}

