/*
 * Decompiled with CFR 0.152.
 */
package org.jsfr.json;

import java.lang.ref.SoftReference;
import java.util.Stack;
import org.jsfr.json.path.ArrayIndex;
import org.jsfr.json.path.ChildNode;
import org.jsfr.json.path.JsonPath;
import org.jsfr.json.path.PathOperator;
import org.jsfr.json.path.Root;

class JsonPosition
extends JsonPath {
    private SoftReference<Stack<ChildNode>> childNodeCache = new SoftReference(new Stack());
    private SoftReference<Stack<ArrayIndex>> arrayNodeCache = new SoftReference(new Stack());

    JsonPosition() {
    }

    static JsonPosition start() {
        JsonPosition newPath = new JsonPosition();
        newPath.operators.push(Root.instance());
        return newPath;
    }

    void stepIntoObject() {
        Stack<ChildNode> stack = this.childNodeCache.get();
        ChildNode node = null;
        if (stack != null && !stack.isEmpty()) {
            node = stack.pop();
            node.setKey(null);
        }
        if (node == null) {
            node = new ChildNode(null);
        }
        this.operators.push(node);
    }

    void updateObjectEntry(String key) {
        ((ChildNode)this.operators.peek()).setKey(key);
    }

    void stepOutObject() {
        PathOperator node = (PathOperator)this.operators.pop();
        Stack<ChildNode> stack = this.childNodeCache.get();
        if (stack != null) {
            stack.push((ChildNode)node);
        } else {
            this.createChildNodeCache();
        }
    }

    void stepIntoArray() {
        Stack<ArrayIndex> stack = this.arrayNodeCache.get();
        ArrayIndex node = null;
        if (stack != null && !stack.isEmpty()) {
            node = stack.pop();
            node.reset();
        }
        if (node == null) {
            node = new ArrayIndex();
        }
        this.operators.push(node);
    }

    boolean accumulateArrayIndex() {
        PathOperator top = this.peek();
        if (top.getType() == PathOperator.Type.ARRAY) {
            ((ArrayIndex)top).increaseArrayIndex();
            return true;
        }
        return false;
    }

    void stepOutArray() {
        PathOperator node = (PathOperator)this.operators.pop();
        Stack<ArrayIndex> stack = this.arrayNodeCache.get();
        if (stack != null) {
            stack.push((ArrayIndex)node);
        } else {
            this.createArrayNodeCache();
        }
    }

    void clear() {
        this.operators.clear();
        this.operators = null;
        this.childNodeCache = null;
        this.arrayNodeCache = null;
    }

    private void createChildNodeCache() {
        this.childNodeCache = new SoftReference(new Stack());
    }

    private void createArrayNodeCache() {
        this.arrayNodeCache = new SoftReference(new Stack());
    }
}

