/*
 * Decompiled with CFR 0.152.
 */
package org.jsfr.json;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.Reader;
import org.jsfr.json.AbstractPrimitiveHolder;
import org.jsfr.json.JsonParserAdapter;
import org.jsfr.json.SurfingContext;
import org.jsfr.json.provider.JsonProvider;

public class GsonParser
implements JsonParserAdapter {
    public static final GsonParser INSTANCE = new GsonParser();

    private GsonParser() {
    }

    @Override
    public void parse(Reader reader, SurfingContext context) {
        try {
            final JsonReader jsonReader = new JsonReader(reader);
            final JsonProvider jsonProvider = context.getConfig().getJsonProvider();
            AbstractPrimitiveHolder stringHolder = new AbstractPrimitiveHolder(context.getConfig()){

                @Override
                public Object doGetValue() throws Exception {
                    return jsonProvider.primitive(jsonReader.nextString());
                }

                @Override
                public void doSkipValue() throws Exception {
                    jsonReader.skipValue();
                }
            };
            AbstractPrimitiveHolder numberHolder = new AbstractPrimitiveHolder(context.getConfig()){

                @Override
                public Object doGetValue() throws Exception {
                    return jsonProvider.primitive(jsonReader.nextDouble());
                }

                @Override
                public void doSkipValue() throws Exception {
                    jsonReader.skipValue();
                }
            };
            AbstractPrimitiveHolder booleanHolder = new AbstractPrimitiveHolder(context.getConfig()){

                @Override
                public Object doGetValue() throws Exception {
                    return jsonProvider.primitive(jsonReader.nextBoolean());
                }

                @Override
                public void doSkipValue() throws Exception {
                    jsonReader.skipValue();
                }
            };
            AbstractPrimitiveHolder nullHolder = new AbstractPrimitiveHolder(context.getConfig()){

                @Override
                public Object doGetValue() throws Exception {
                    jsonReader.nextNull();
                    return jsonProvider.primitiveNull();
                }

                @Override
                public void doSkipValue() throws Exception {
                    jsonReader.skipValue();
                }
            };
            context.startJSON();
            while (true) {
                JsonToken token = jsonReader.peek();
                switch (token) {
                    case BEGIN_ARRAY: {
                        jsonReader.beginArray();
                        if (context.startArray()) break;
                        return;
                    }
                    case END_ARRAY: {
                        jsonReader.endArray();
                        if (context.endArray()) break;
                        return;
                    }
                    case BEGIN_OBJECT: {
                        jsonReader.beginObject();
                        if (context.startObject()) break;
                        return;
                    }
                    case END_OBJECT: {
                        jsonReader.endObject();
                        if (context.endObject()) break;
                        return;
                    }
                    case NAME: {
                        String name = jsonReader.nextName();
                        if (context.startObjectEntry(name)) break;
                        return;
                    }
                    case STRING: {
                        stringHolder.init();
                        if (!context.primitive(stringHolder)) {
                            return;
                        }
                        stringHolder.skipValue();
                        break;
                    }
                    case NUMBER: {
                        numberHolder.init();
                        if (!context.primitive(numberHolder)) {
                            return;
                        }
                        numberHolder.skipValue();
                        break;
                    }
                    case BOOLEAN: {
                        booleanHolder.init();
                        if (!context.primitive(booleanHolder)) {
                            return;
                        }
                        booleanHolder.skipValue();
                        break;
                    }
                    case NULL: {
                        nullHolder.init();
                        if (!context.primitive(nullHolder)) {
                            return;
                        }
                        nullHolder.skipValue();
                        break;
                    }
                    case END_DOCUMENT: {
                        context.endJSON();
                        return;
                    }
                }
            }
        }
        catch (Exception e) {
            context.getConfig().getErrorHandlingStrategy().handleParsingException(e);
            return;
        }
    }
}

