/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsontemplate.modelbuild;

import com.github.jsontemplate.jsonbuild.JsonArrayNode;
import com.github.jsontemplate.jsonbuild.JsonBuilder;
import com.github.jsontemplate.jsonbuild.JsonNode;
import com.github.jsontemplate.jsonbuild.JsonNullNode;
import com.github.jsontemplate.jsonbuild.JsonWrapperNode;
import com.github.jsontemplate.modelbuild.ArrayPropertyDeclaration;
import com.github.jsontemplate.modelbuild.ObjectPropertyDeclaration;
import com.github.jsontemplate.modelbuild.Token;
import com.github.jsontemplate.modelbuild.TypeSpec;
import com.github.jsontemplate.modelbuild.handler.DefaultBuildHandler;
import com.github.jsontemplate.valueproducer.IValueProducer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BasePropertyDeclaration {
    protected String propertyName;
    protected TypeSpec typeSpec = new TypeSpec();
    protected List<BasePropertyDeclaration> properties = new ArrayList<BasePropertyDeclaration>();
    protected BasePropertyDeclaration parent;
    protected TypeSpec arrayTypeSpec = new TypeSpec();
    protected boolean isTypeDefinition = false;

    public TypeSpec getTypeSpec() {
        return this.typeSpec;
    }

    public TypeSpec getArrayTypeSpec() {
        return this.arrayTypeSpec;
    }

    public List<BasePropertyDeclaration> getProperties() {
        return this.properties;
    }

    public void markAsTypeDefinition() {
        this.isTypeDefinition = true;
    }

    public boolean isTypeDefinition() {
        return this.isTypeDefinition;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public void addProperty(BasePropertyDeclaration propertyDeclaration) {
        this.properties.add(propertyDeclaration);
        propertyDeclaration.setParent(this);
    }

    public void removeProperty(BasePropertyDeclaration propertyDeclaration) {
        this.properties.remove(propertyDeclaration);
        propertyDeclaration.setParent(null);
    }

    public BasePropertyDeclaration getParent() {
        return this.parent;
    }

    public void setParent(BasePropertyDeclaration parent) {
        this.parent = parent;
    }

    ArrayPropertyDeclaration asArrayProperty() {
        return new ArrayPropertyDeclaration(this.propertyName);
    }

    ObjectPropertyDeclaration asObjectProperty() {
        return new ObjectPropertyDeclaration(this.propertyName);
    }

    public void buildJsonTemplate(JsonBuilder builder, Map<String, IValueProducer> producerMap, Map<String, JsonNode> typeMap, Map<String, JsonNode> variableMap, String defaultTypeName, DefaultBuildHandler defaultHandler) {
        JsonNode jsonNode = null;
        if (this.isNullValue()) {
            jsonNode = new JsonNullNode();
        } else {
            jsonNode = this.findJsonNodeFromVariable(variableMap, this.typeSpec.getTypeName());
            if (jsonNode == null) {
                if (this.typeSpec.getTypeName() == null) {
                    TypeSpec ancestorTypeSpec = this.findAncestorTypeSpec(defaultTypeName);
                    this.typeSpec.setTypeName(ancestorTypeSpec.getTypeName());
                    if (this.typeSpec.getSingleParam() == null) {
                        this.typeSpec = ancestorTypeSpec;
                    }
                }
                jsonNode = this.buildNodeFromProducer(producerMap);
            }
            if (jsonNode == null) {
                jsonNode = typeMap.get(this.typeSpec.getTypeName());
            }
            if (jsonNode == null) {
                defaultHandler.handle(this.typeSpec.getTypeName());
            }
        }
        this.joinNode(builder, jsonNode);
    }

    private void joinNode(JsonBuilder builder, JsonNode jsonNode) {
        if (builder.inObject()) {
            builder.putNode(this.propertyName, jsonNode);
        } else if (builder.inArray()) {
            builder.addNode(jsonNode);
        } else {
            builder.pushNode(jsonNode);
        }
    }

    protected TypeSpec findAncestorTypeSpec(String defaultTypeName) {
        TypeSpec curTypeSpec = this.typeSpec;
        for (BasePropertyDeclaration declParent = this.getParent(); curTypeSpec.getTypeName() == null && declParent != null; declParent = declParent.getParent()) {
            curTypeSpec = declParent.getTypeSpec();
        }
        if (curTypeSpec.getTypeName() == null) {
            curTypeSpec = this.getDefaultTypeSpec(defaultTypeName);
        }
        return curTypeSpec;
    }

    protected TypeSpec getDefaultTypeSpec(String defaultTypeName) {
        TypeSpec defaultTypeSpec = new TypeSpec();
        defaultTypeSpec.setTypeName(defaultTypeName);
        return defaultTypeSpec;
    }

    protected JsonNode buildNodeFromProducer(Map<String, IValueProducer> producerMap) {
        JsonNode jsonNode = null;
        IValueProducer producer = producerMap.get(this.typeSpec.getTypeName());
        if (producer != null) {
            jsonNode = this.typeSpec.getSingleParam() != null ? (JsonNode)producer.produce(this.typeSpec.getSingleParam()) : (!this.typeSpec.getListParam().isEmpty() ? (JsonNode)producer.produce(this.typeSpec.getListParam()) : (!this.typeSpec.getMapParam().isEmpty() ? (JsonNode)producer.produce(this.typeSpec.getMapParam()) : (JsonNode)producer.produce()));
        }
        return jsonNode;
    }

    protected void handleComposite(JsonBuilder builder, Map<String, IValueProducer> producerMap, Map<String, JsonNode> typeMap, Map<String, List<JsonWrapperNode>> missTypeMap, Map<String, JsonNode> variableMap) {
        throw new UnsupportedOperationException("Unexpected operation in simple property.");
    }

    protected void setArrayInfo(JsonArrayNode jsonArrayNode, JsonNode defaultNode) {
        jsonArrayNode.setDefaultNode(defaultNode);
        if (this.arrayTypeSpec.getSingleParam() != null) {
            jsonArrayNode.setParameters(this.arrayTypeSpec.getSingleParam());
        }
        if (!this.arrayTypeSpec.getListParam().isEmpty()) {
            jsonArrayNode.setParameters(this.arrayTypeSpec.getListParam());
        }
        if (!this.arrayTypeSpec.getMapParam().isEmpty()) {
            jsonArrayNode.setParameters(this.arrayTypeSpec.getMapParam());
        }
    }

    protected void buildChildrenJsonTemplate(JsonBuilder builder, Map<String, IValueProducer> producerMap, Map<String, JsonNode> typeMap, Map<String, JsonNode> variableMap, String defaultTypeName, DefaultBuildHandler defaultHandler) {
        for (BasePropertyDeclaration declaration : this.properties) {
            declaration.buildJsonTemplate(builder, producerMap, typeMap, variableMap, defaultTypeName, defaultHandler);
        }
    }

    boolean isTypeDeclaration() {
        return this.propertyName != null && this.propertyName.startsWith(Token.TYPE.getTag());
    }

    private JsonNode findJsonNodeFromVariable(Map<String, JsonNode> variableMap, String name) {
        if (name != null && name.startsWith(Token.VARIABLE.getTag())) {
            return variableMap.get(name.substring(1));
        }
        return null;
    }

    public void applyVariablesToParameters(Map<String, Object> variableMap) {
        if (this.typeSpec.getSingleParam() != null) {
            this.applyVariablesToSingleParameter(variableMap);
        } else if (!this.typeSpec.getListParam().isEmpty()) {
            this.applyVariablesToListParameter(variableMap);
        } else if (!this.typeSpec.getMapParam().isEmpty()) {
            this.applyVariablesToMapParameter(variableMap);
        }
    }

    private void applyVariablesToSingleParameter(Map<String, Object> variableMap) {
        if (this.typeSpec.getSingleParam().startsWith(Token.VARIABLE.getTag())) {
            Object variable = variableMap.get(this.typeSpec.getSingleParam().substring(1));
            if (variable instanceof Collection) {
                Collection collectionVariable = (Collection)variable;
                this.typeSpec.setSingleParam(null);
                List<String> elements = collectionVariable.stream().map(Object::toString).collect(Collectors.toList());
                this.typeSpec.setListParam(elements);
            } else if (variable.getClass().isArray()) {
                Object[] arrayVariable = (Object[])variable;
                this.typeSpec.setSingleParam(null);
                List<String> elements = Arrays.stream(arrayVariable).map(Object::toString).collect(Collectors.toList());
                this.typeSpec.setListParam(elements);
            } else if (variable instanceof Map) {
                this.typeSpec.setSingleParam(null);
                this.typeSpec.getListParam().clear();
                Map mapVariable = (Map)variable;
                Map<String, String> config = mapVariable.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue().toString()));
                this.typeSpec.setMapParam(config);
            } else {
                this.typeSpec.setSingleParam(variable.toString());
            }
        }
    }

    private void applyVariablesToListParameter(Map<String, Object> variableMap) {
        for (int i = 0; i < this.typeSpec.getListParam().size(); ++i) {
            if (!this.typeSpec.getListParam().get(i).startsWith(Token.VARIABLE.getTag())) continue;
            Object variable = variableMap.get(this.typeSpec.getListParam().get(i).substring(1));
            this.typeSpec.getListParam().set(i, variable.toString());
        }
    }

    private void applyVariablesToMapParameter(Map<String, Object> variableMap) {
        for (Map.Entry<String, String> entry : this.typeSpec.getMapParam().entrySet()) {
            if (!entry.getValue().startsWith(Token.VARIABLE.getTag())) continue;
            Object variable = variableMap.get(entry.getValue().substring(1));
            if (variable != null) {
                this.typeSpec.getMapParam().put(entry.getKey(), variable.toString());
                continue;
            }
            throw new IllegalArgumentException("Unknown variable name: " + entry.getValue());
        }
    }

    public boolean isNullValue() {
        return "null".equals(this.typeSpec.getSingleParam());
    }

    protected boolean isRoot() {
        return this.parent == null;
    }
}

