/*
 * Decompiled with CFR 0.152.
 */
package com.jsmeli.permissioncheck.sjml.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.v4.app.Fragment;
import com.jsmeli.permissioncheck.sjml.util.SPUtils;
import java.util.ArrayList;
import java.util.List;

public class PermissionUtils {
    public static boolean isOverMarshmallow() {
        return Build.VERSION.SDK_INT >= 23;
    }

    @TargetApi(value=23)
    public static List<String> checkPermission(Activity activity, String ... permissions) {
        ArrayList<String> applyPermissions = new ArrayList<String>();
        for (String value : permissions) {
            if (activity.checkSelfPermission(value) == 0) continue;
            applyPermissions.add(value);
        }
        return applyPermissions;
    }

    @TargetApi(value=23)
    public static int checkSinglePermission(Activity activity, String permissions) {
        int ret = 2;
        String[] string = permissions.split("\\.");
        if (activity.checkSelfPermission(permissions) != 0) {
            boolean isFirst = (Boolean)SPUtils.get((Context)activity, string[string.length - 1], true);
            if (isFirst) {
                ret = 2;
                SPUtils.put((Context)activity, string[string.length - 1], false);
            } else {
                ret = activity.shouldShowRequestPermissionRationale(permissions) ? 2 : 0;
            }
        } else {
            ret = 1;
        }
        return ret;
    }

    public static Activity getActivity(Object object) {
        if (object instanceof Fragment) {
            return ((Fragment)object).getActivity();
        }
        if (object instanceof Activity) {
            return (Activity)object;
        }
        return null;
    }
}

