/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsdevel.testng.selenium;

import com.github.jsdevel.testng.selenium.AbsractSuiteHelpers;
import com.github.jsdevel.testng.selenium.MethodContextImpl;
import com.github.jsdevel.testng.selenium.PageFactory;
import com.github.jsdevel.testng.selenium.TestNGSeleniumLogger;
import com.github.jsdevel.testng.selenium.environment.EnvironmentConfig;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public class AbstractSuite<PF extends PageFactory> {
    private final ThreadLocal<MethodContextImpl<PF>> methodContext = new ThreadLocal();

    protected PF getPageFactory() {
        return this.methodContext.get().getPageFactory();
    }

    @BeforeMethod(alwaysRun=true)
    public void beforeMethod(Method method) {
        MethodContextImpl context = new MethodContextImpl(method);
        context.setEndpoint(EnvironmentConfig.ENDPOINT);
        AbsractSuiteHelpers.addWebDriver(context);
        AbsractSuiteHelpers.addScreensize(context);
        AbsractSuiteHelpers.addPageFactory(context);
        this.methodContext.set(context);
    }

    @AfterMethod(alwaysRun=true)
    public void afterMethod(ITestResult testResult) throws IOException {
        MethodContextImpl<PF> context = this.methodContext.get();
        if (context == null) {
            return;
        }
        if (testResult.getStatus() == 2) {
            File screenshotTarget = new File(EnvironmentConfig.SCREENSHOT_DIR, context.method.getDeclaringClass().getName() + ":" + context.method.getName() + ".png");
            context.log("Saving a screenshot to " + screenshotTarget.getAbsolutePath());
            File screenshot = (File)((TakesScreenshot)context.getWebDriver()).getScreenshotAs(OutputType.FILE);
            FileUtils.copyFile((File)screenshot, (File)screenshotTarget);
            if (context.getOutput() != null) {
                for (String line : context.getOutput()) {
                    TestNGSeleniumLogger.log(line);
                }
            }
        }
        context.getWebDriver().quit();
        this.methodContext.remove();
    }
}

