/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsdevel.testng.selenium;

import com.github.jsdevel.testng.selenium.MethodContextImpl;
import com.github.jsdevel.testng.selenium.PageFactory;
import com.github.jsdevel.testng.selenium.PageFactoryProxy;
import com.github.jsdevel.testng.selenium.annotations.driverconfig.UserAgent;
import com.github.jsdevel.testng.selenium.annotations.drivers.Chrome;
import com.github.jsdevel.testng.selenium.annotations.drivers.Firefox;
import com.github.jsdevel.testng.selenium.annotations.drivers.InternetExplorer;
import com.github.jsdevel.testng.selenium.exceptions.MissingPageFactoryException;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import net.anthavio.phanbedder.Phanbedder;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

class AbsractSuiteHelpers {
    private static final File phantomBinary = Phanbedder.unpack();

    AbsractSuiteHelpers() {
    }

    static <PF extends PageFactory> void addPageFactory(MethodContextImpl context) {
        ParameterizedType abstractSuite;
        Class<?> suite = context.method.getDeclaringClass();
        try {
            abstractSuite = (ParameterizedType)suite.getGenericSuperclass();
        }
        catch (ClassCastException e) {
            throw new MissingPageFactoryException("AbstractSuite must receive Type parameters I.E. class MySuite extends AbstractSuite<MyPageFactory>.  None were given in " + suite.getName());
        }
        Class pageFactoryClass = (Class)abstractSuite.getActualTypeArguments()[0];
        context.setPageFactory((PageFactory)PageFactoryProxy.newInstance(pageFactoryClass, context));
    }

    static synchronized void addWebDriver(MethodContextImpl context) {
        Method method = context.method;
        if (method.isAnnotationPresent(Chrome.class)) {
            AbsractSuiteHelpers.addChromeDriver(context);
        } else if (method.isAnnotationPresent(Firefox.class)) {
            AbsractSuiteHelpers.addFirefoxDriver(context);
        } else if (method.isAnnotationPresent(InternetExplorer.class)) {
            AbsractSuiteHelpers.addInternetExplorerDriver(context);
        } else {
            AbsractSuiteHelpers.addPhantomJSDriver(context);
        }
    }

    static void addUserAgent(MethodContextImpl context) {
        Method method = context.method;
        if (method.isAnnotationPresent(UserAgent.class)) {
            context.setUserAgent(method.getAnnotation(UserAgent.class).value());
        }
    }

    private static void addChromeDriver(MethodContextImpl context) {
        ChromeDriver driver = new ChromeDriver();
        context.setWebDriver((WebDriver)driver);
    }

    private static void addFirefoxDriver(MethodContextImpl context) {
    }

    private static void addInternetExplorerDriver(MethodContextImpl context) {
    }

    private static void addPhantomJSDriver(MethodContextImpl context) {
        DesiredCapabilities dcaps = new DesiredCapabilities();
        dcaps.setCapability("phantomjs.binary.path", phantomBinary.getAbsolutePath());
        if (context.getUserAgent() != null) {
            dcaps.setCapability("phantomjs.page.settings.userAgent", context.getUserAgent());
        }
        PhantomJSDriver driver = new PhantomJSDriver((Capabilities)dcaps);
        context.setWebDriver((WebDriver)driver);
    }
}

