/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsdevel.testng.selenium;

import com.github.jsdevel.testng.selenium.AbsractSuiteHelpers;
import com.github.jsdevel.testng.selenium.AbstractPageFactory;
import com.github.jsdevel.testng.selenium.MethodContext;
import com.github.jsdevel.testng.selenium.TestNGSeleniumLogger;
import java.lang.reflect.Method;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public class AbstractSuite<PF extends AbstractPageFactory> {
    private final ThreadLocal<MethodContext<PF>> methodContext = new ThreadLocal();

    protected PF getPageFactory() {
        return (PF)((AbstractPageFactory)this.methodContext.get().getPageFactory());
    }

    @BeforeMethod(alwaysRun=true)
    public void beforeMethod(Method method) {
        MethodContext context = new MethodContext(method);
        AbsractSuiteHelpers.addWebDriver(context);
        AbsractSuiteHelpers.addPageFactory(context);
        this.methodContext.set(context);
    }

    @AfterMethod(alwaysRun=true)
    public void afterMethod() {
        MethodContext<PF> context = this.methodContext.get();
        if (context == null) {
            return;
        }
        if (context.getOutput() != null) {
            for (String line : context.getOutput()) {
                TestNGSeleniumLogger.log(line);
            }
        }
        this.methodContext.remove();
    }
}

