/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsdevel.testng.selenium;

import com.github.jsdevel.testng.selenium.AbstractPageFactory;
import com.github.jsdevel.testng.selenium.EnvironmentConfig;
import com.github.jsdevel.testng.selenium.MethodContext;
import com.github.jsdevel.testng.selenium.annotations.drivers.Chrome;
import com.github.jsdevel.testng.selenium.annotations.drivers.Firefox;
import com.github.jsdevel.testng.selenium.annotations.drivers.InternetExplorer;
import com.github.jsdevel.testng.selenium.exceptions.MissingPageFactoryException;
import com.github.jsdevel.testng.selenium.exceptions.PageFactoryInstantiationException;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import net.anthavio.phanbedder.Phanbedder;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

class AbsractSuiteHelpers {
    private static final File phantomBinary = Phanbedder.unpack();

    AbsractSuiteHelpers() {
    }

    static <PF extends AbstractPageFactory> void addPageFactory(MethodContext context) {
        ParameterizedType abstractSuite;
        Class<?> suite = context.method.getDeclaringClass();
        try {
            abstractSuite = (ParameterizedType)suite.getGenericSuperclass();
        }
        catch (ClassCastException e) {
            throw new MissingPageFactoryException("AbstractSuite must receive Type parameters I.E. class MySuite extends AbstractSuite<MyPageFactory>.  None were given in " + suite.getName());
        }
        try {
            Class pageFactoryClass = (Class)abstractSuite.getActualTypeArguments()[0];
            AbstractPageFactory pageFactory = (AbstractPageFactory)pageFactoryClass.newInstance();
            pageFactory.setMethodContext(context);
            pageFactory.setEndoint(EnvironmentConfig.ENDPOINT);
            pageFactory.setWebDriver(context.getWebDriver());
            context.setPageFactory(pageFactory);
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException e) {
            throw new PageFactoryInstantiationException(e);
        }
    }

    static synchronized void addWebDriver(MethodContext context) {
        Method method = context.method;
        if (method.isAnnotationPresent(Chrome.class)) {
            AbsractSuiteHelpers.addChromeDriver(context);
        } else if (method.isAnnotationPresent(Firefox.class)) {
            AbsractSuiteHelpers.addFirefoxDriver(context);
        } else if (method.isAnnotationPresent(InternetExplorer.class)) {
            AbsractSuiteHelpers.addInternetExplorerDriver(context);
        } else {
            AbsractSuiteHelpers.addPhantomJSDriver(context);
        }
    }

    private static void addChromeDriver(MethodContext context) {
        ChromeDriver driver = new ChromeDriver();
        context.setWebDriver((WebDriver)driver);
    }

    private static void addFirefoxDriver(MethodContext context) {
    }

    private static void addInternetExplorerDriver(MethodContext context) {
    }

    private static void addPhantomJSDriver(MethodContext context) {
        DesiredCapabilities dcaps = new DesiredCapabilities();
        dcaps.setCapability("phantomjs.binary.path", phantomBinary.getAbsolutePath());
        PhantomJSDriver driver = new PhantomJSDriver((Capabilities)dcaps);
        context.setWebDriver((WebDriver)driver);
    }
}

