/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsdevel.testng.selenium.config;

import com.github.jsdevel.testng.selenium.TestNGSeleniumLogger;
import com.github.jsdevel.testng.selenium.config.PropertiesConfig;
import java.io.File;

public class Config {
    public static final boolean DEBUG = System.getProperty("testng.selenium.debug", PropertiesConfig.DEBUG).equalsIgnoreCase("enabled");
    public static final String DRIVER = System.getProperty("testng.selenium.driver", PropertiesConfig.DRIVER);
    public static final String ENDPOINT = System.getProperty("testng.selenium.endpoint", PropertiesConfig.ENDPOINT);
    public static final String LOGGING_PREFIX = System.getProperty("testng.selenium.logging_prefix", PropertiesConfig.LOGGING_PREFIX);
    public static final String SCREENSIZE = System.getProperty("testng.selenium.screensize", PropertiesConfig.SCREENSIZE);
    public static final String TMPDIR = System.getProperty("testng.selenium.tmpdir", PropertiesConfig.TMPDIR);
    public static final String USER_AGENT = System.getProperty("testng.selenium.driverconfig.useragent", PropertiesConfig.USER_AGENT);
    private static final String DRIVER_OPTIONS = "Chrome,Firefox,InternetExplorer,PhantomJS";
    private static final String SCREENSIZE_OPTIONS = "LargeDesktop,Desktop,Tablet,Phone";

    static {
        if (!",Chrome,Firefox,InternetExplorer,PhantomJS,".toLowerCase().contains(DRIVER.toLowerCase())) {
            TestNGSeleniumLogger.log("testng.selenium.driver must be one of Chrome,Firefox,InternetExplorer,PhantomJS");
            System.exit(1);
        }
        if (ENDPOINT == null) {
            TestNGSeleniumLogger.log("testng.selenium.endpoint must be a configured System property!");
            System.exit(1);
        }
        if (!",LargeDesktop,Desktop,Tablet,Phone,".contains("," + SCREENSIZE + ",")) {
            TestNGSeleniumLogger.log("testng.selenium.screensize must be one of LargeDesktop,Desktop,Tablet,Phone");
            TestNGSeleniumLogger.log("Saw " + SCREENSIZE);
            System.exit(1);
        }
        if (TMPDIR == null) {
            TestNGSeleniumLogger.log("testng.selenium.tmpdir must be a configured System property!");
            System.exit(1);
        } else {
            File tmpdir = new File(TMPDIR);
            if (tmpdir.exists()) {
                if (!tmpdir.isDirectory()) {
                    TestNGSeleniumLogger.log("testng.selenium.tmpdir cannot use non directories for tmp dir.");
                    System.exit(1);
                }
            } else {
                tmpdir.mkdirs();
            }
        }
        TestNGSeleniumLogger.debug("testng.selenium.debug set to " + DEBUG);
        TestNGSeleniumLogger.debug("testng.selenium.driver set to " + DRIVER);
        TestNGSeleniumLogger.debug("testng.selenium.endpoint set to " + ENDPOINT);
        TestNGSeleniumLogger.debug("testng.selenium.logging_prefix set to " + LOGGING_PREFIX);
        TestNGSeleniumLogger.debug("testng.selenium.screensize set to " + SCREENSIZE);
        TestNGSeleniumLogger.debug("testng.selenium.tmpdir set to " + TMPDIR);
        TestNGSeleniumLogger.debug("testng.selenium.driverconfig.useragent set to " + USER_AGENT);
    }
}

