/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsdevel.testng.selenium;

import com.github.jsdevel.testng.selenium.AbsractSuiteHelpers;
import com.github.jsdevel.testng.selenium.MethodContextImpl;
import com.github.jsdevel.testng.selenium.PageFactory;
import com.github.jsdevel.testng.selenium.TestNGSeleniumLogger;
import com.github.jsdevel.testng.selenium.config.Config;
import java.io.IOException;
import java.lang.reflect.Method;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public class AbstractSuite<PF extends PageFactory> {
    private final ThreadLocal<MethodContextImpl<PF>> methodContext = new ThreadLocal();

    protected PF getPageFactory() {
        return this.methodContext.get().getPageFactory();
    }

    @BeforeMethod(alwaysRun=true)
    public void beforeMethod(Method method) {
        MethodContextImpl context = new MethodContextImpl(method);
        context.setEndpoint(Config.ENDPOINT);
        AbsractSuiteHelpers.addUserAgent(context);
        AbsractSuiteHelpers.addWebDriver(context);
        AbsractSuiteHelpers.addScreensize(context);
        AbsractSuiteHelpers.addPageFactory(context);
        context.log("Starting test method " + AbsractSuiteHelpers.getTestName(method));
        this.methodContext.set(context);
    }

    @AfterMethod(alwaysRun=true)
    public void afterMethod(ITestResult testResult) throws IOException {
        MethodContextImpl<PF> context = this.methodContext.get();
        if (context == null) {
            return;
        }
        if (testResult.getStatus() == 2) {
            AbsractSuiteHelpers.takeScreenshot(context);
            TestNGSeleniumLogger.log(context.getOutput());
        }
        context.getWebDriver().quit();
        this.methodContext.remove();
    }
}

