/*
 * Decompiled with CFR 0.152.
 */
package com.vansuita.pickimage;

import android.annotation.TargetApi;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Parcelable;
import android.support.v4.app.DialogFragment;
import android.view.View;
import android.view.WindowManager;
import com.vansuita.pickimage.IPickResult;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class Util {
    @TargetApi(value=16)
    public static void background(View v, Drawable d) {
        int sdk = Build.VERSION.SDK_INT;
        if (sdk < 16) {
            v.setBackgroundDrawable(d);
        } else {
            v.setBackground(d);
        }
    }

    @TargetApi(value=16)
    public static void background(View v, Bitmap b) {
        Util.background(v, (Drawable)new BitmapDrawable(v.getResources(), b));
    }

    public static void launchGalery(DialogFragment frag, int code) {
        Intent intent = new Intent("android.intent.action.PICK");
        intent.setType("image/*");
        frag.startActivityForResult(intent, code);
    }

    public static void launchCamera(DialogFragment frag, int code) {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (intent.resolveActivity(frag.getActivity().getPackageManager()) != null) {
            intent.putExtra("output", (Parcelable)Util.tempUri());
            frag.startActivityForResult(intent, code);
        }
    }

    public static File tempFile() {
        File dir = new File(Environment.getExternalStorageDirectory(), IPickResult.class.getSimpleName());
        dir.mkdirs();
        return new File(dir, "temp.jpg");
    }

    public static Uri tempUri() {
        return Uri.fromFile((File)Util.tempFile());
    }

    public static Bitmap flip(Bitmap bitmap) {
        Matrix m = new Matrix();
        m.preScale(-1.0f, 1.0f);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)m, (boolean)false);
    }

    public static Bitmap decodeUri(Uri selectedImage, Context context, int requiredSize) throws FileNotFoundException {
        BitmapFactory.Options o = new BitmapFactory.Options();
        o.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)context.getContentResolver().openInputStream(selectedImage), null, (BitmapFactory.Options)o);
        int width_tmp = o.outWidth;
        int height_tmp = o.outHeight;
        int scale = 1;
        while (width_tmp / 2 >= requiredSize && height_tmp / 2 >= requiredSize) {
            width_tmp /= 2;
            height_tmp /= 2;
            scale *= 2;
        }
        BitmapFactory.Options o2 = new BitmapFactory.Options();
        o2.inSampleSize = scale;
        return BitmapFactory.decodeStream((InputStream)context.getContentResolver().openInputStream(selectedImage), null, (BitmapFactory.Options)o2);
    }

    public static void setDimAmount(float dim, Dialog dialog) {
        if (Build.VERSION.SDK_INT >= 14) {
            dialog.getWindow().setDimAmount(dim);
        } else {
            WindowManager.LayoutParams lp = dialog.getWindow().getAttributes();
            lp.dimAmount = dim;
            dialog.getWindow().setAttributes(lp);
        }
    }

    public static void gone(View v, boolean gone) {
        if (gone) {
            v.setVisibility(8);
        } else {
            v.setVisibility(0);
        }
    }
}

