/*
 * Decompiled with CFR 0.152.
 */
package com.vansuita.library;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.view.View;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class Util {
    @TargetApi(value=16)
    public static void background(View v, Drawable d) {
        int sdk = Build.VERSION.SDK_INT;
        if (sdk < 16) {
            v.setBackgroundDrawable(d);
        } else {
            v.setBackground(d);
        }
    }

    @TargetApi(value=16)
    public static void background(View v, Bitmap b) {
        Util.background(v, (Drawable)new BitmapDrawable(v.getResources(), b));
    }

    public static Bitmap flip(Bitmap bitmap) {
        Matrix m = new Matrix();
        m.preScale(-1.0f, 1.0f);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)m, (boolean)false);
    }

    public static Bitmap decodeUri(Uri selectedImage, Context context) throws FileNotFoundException {
        BitmapFactory.Options o = new BitmapFactory.Options();
        o.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)context.getContentResolver().openInputStream(selectedImage), null, (BitmapFactory.Options)o);
        int REQUIRED_SIZE = 140;
        int width_tmp = o.outWidth;
        int height_tmp = o.outHeight;
        int scale = 1;
        while (width_tmp / 2 >= 140 && height_tmp / 2 >= 140) {
            width_tmp /= 2;
            height_tmp /= 2;
            scale *= 2;
        }
        BitmapFactory.Options o2 = new BitmapFactory.Options();
        o2.inSampleSize = scale;
        return BitmapFactory.decodeStream((InputStream)context.getContentResolver().openInputStream(selectedImage), null, (BitmapFactory.Options)o2);
    }
}

