/*
 * Decompiled with CFR 0.152.
 */
package com.vansuita.gaussianblur;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import android.support.v8.renderscript.Allocation;
import android.support.v8.renderscript.Element;
import android.support.v8.renderscript.RenderScript;
import android.support.v8.renderscript.ScriptIntrinsicBlur;
import android.widget.ImageView;
import java.lang.ref.WeakReference;

public class GaussianBlur {
    public static final int MIN_RADIUS = 0;
    public static final int MAX_RADIUS = 25;
    public static final int MIN_SIZE = 0;
    public static final int MAX_SIZE = 800;
    private Context context;
    private int radius;
    private float size;

    private GaussianBlur(Context context) {
        this.context = context;
        this.radius(25);
        this.size(800.0f);
    }

    public static GaussianBlur with(Context context) {
        return new GaussianBlur(context);
    }

    @WorkerThread
    public Bitmap render(int res) {
        return this.render(BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)res));
    }

    @WorkerThread
    public Bitmap render(Drawable drawable) {
        return this.render(((BitmapDrawable)drawable).getBitmap());
    }

    @WorkerThread
    public Bitmap render(Bitmap source) {
        Bitmap bitmap = source;
        RenderScript rs = RenderScript.create((Context)this.context);
        if (this.getSize() > 0.0f) {
            bitmap = this.scaleDown(bitmap);
        }
        Bitmap output = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Allocation inAlloc = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)bitmap, (Allocation.MipmapControl)Allocation.MipmapControl.MIPMAP_NONE, (int)2);
        Allocation outAlloc = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)output);
        ScriptIntrinsicBlur script = ScriptIntrinsicBlur.create((RenderScript)rs, (Element)inAlloc.getElement());
        script.setRadius((float)this.getRadius());
        script.setInput(inAlloc);
        script.forEach(outAlloc);
        outAlloc.copyTo(output);
        rs.destroy();
        return output;
    }

    @UiThread
    public void put(Drawable drawable, ImageView imageView) {
        new BitmapGaussianAsync(imageView).execute(new Bitmap[]{((BitmapDrawable)drawable).getBitmap()});
    }

    @UiThread
    public void put(Bitmap bitmap, ImageView imageView) {
        new BitmapGaussianAsync(imageView).execute(new Bitmap[]{bitmap});
    }

    @UiThread
    public void put(int res, ImageView imageView) {
        new ResourceGaussianAsync(imageView).execute(new Integer[]{res});
    }

    @WorkerThread
    public Bitmap scaleDown(int res) {
        return this.scaleDown(BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)res));
    }

    @WorkerThread
    public Bitmap scaleDown(Bitmap input) {
        float ratio = Math.min(this.getSize() / (float)input.getWidth(), this.getSize() / (float)input.getHeight());
        int width = Math.round(ratio * (float)input.getWidth());
        int height = Math.round(ratio * (float)input.getHeight());
        return Bitmap.createScaledBitmap((Bitmap)input, (int)width, (int)height, (boolean)true);
    }

    public int getRadius() {
        return this.radius;
    }

    public GaussianBlur radius(@IntRange(from=0L, to=25L) int radius) {
        this.radius = radius;
        return this;
    }

    public float getSize() {
        return this.size;
    }

    public GaussianBlur size(@FloatRange(from=0.0, to=800.0) float maxSize) {
        this.size = maxSize;
        return this;
    }

    abstract class GaussianAsync<T>
    extends AsyncTask<T, Void, Bitmap> {
        private final WeakReference<ImageView> imageViewReference;

        public GaussianAsync(ImageView imageView) {
            this.imageViewReference = new WeakReference<ImageView>(imageView);
        }

        protected void onPostExecute(Bitmap bitmap) {
            ImageView imageView;
            if (this.imageViewReference != null && bitmap != null && (imageView = (ImageView)this.imageViewReference.get()) != null) {
                imageView.setImageBitmap(bitmap);
            }
        }
    }

    class BitmapGaussianAsync
    extends GaussianAsync<Bitmap> {
        public BitmapGaussianAsync(ImageView imageView) {
            super(imageView);
        }

        protected Bitmap doInBackground(Bitmap ... params) {
            return GaussianBlur.this.render(params[0]);
        }
    }

    class ResourceGaussianAsync
    extends GaussianAsync<Integer> {
        public ResourceGaussianAsync(ImageView imageView) {
            super(imageView);
        }

        protected Bitmap doInBackground(Integer ... params) {
            return GaussianBlur.this.render(params[0]);
        }
    }
}

