/*
 * Decompiled with CFR 0.152.
 */
package com.github.jrubygradle.internal.core;

import com.github.jrubygradle.api.core.GemRepositoryConfiguration;
import com.github.jrubygradle.internal.core.AbstractIvyXmlProxyServer;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import ratpack.server.RatpackServer;
import ratpack.server.ServerConfig;

public class IvyXmlRatpackProxyServer
extends AbstractIvyXmlProxyServer {
    private RatpackServer server;

    public IvyXmlRatpackProxyServer(File cache, URI serverUri, String group, GemRepositoryConfiguration grc) {
        super(cache, serverUri, group, grc);
    }

    @Override
    public void run() {
        try {
            this.server = RatpackServer.start(server -> server.serverConfig(ServerConfig.embedded().publicAddress(new URI("http://localhost")).port(0).baseDir(this.getLocalCachePath())).handlers(chain -> chain.get(":group/:module/:revision/ivy.xml", ctx -> {
                try {
                    Path ivyXml = this.getIvyXml((String)ctx.getAllPathTokens().get((Object)"group"), (String)ctx.getAllPathTokens().get((Object)"module"), (String)ctx.getAllPathTokens().get((Object)"revision"));
                    ctx.getResponse().contentType((CharSequence)"text/xml").sendFile(ivyXml);
                }
                catch (AbstractIvyXmlProxyServer.NotFound e) {
                    ctx.clientError(404);
                }
            }).get(":group/:module/:revision/ivy.xml.sha1", ctx -> {
                try {
                    Path ivyXmlSha1 = this.getIvyXmlSha1((String)ctx.getAllPathTokens().get((Object)"group"), (String)ctx.getAllPathTokens().get((Object)"module"), (String)ctx.getAllPathTokens().get((Object)"revision"));
                    ctx.getResponse().contentType((CharSequence)"text/plain").sendFile(ivyXmlSha1);
                }
                catch (AbstractIvyXmlProxyServer.NotFound e) {
                    ctx.clientError(404);
                }
            }).get(":group/:module", ctx -> {
                try {
                    String listing = this.getDirectoryListing((String)ctx.getAllPathTokens().get((Object)"group"), (String)ctx.getAllPathTokens().get((Object)"module"));
                    ctx.getResponse().contentType((CharSequence)"text/html").send(listing);
                }
                catch (AbstractIvyXmlProxyServer.NotFound e) {
                    ctx.clientError(404);
                }
            }).get(ctx -> ctx.clientError(403))));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not start Ratpack", e);
        }
    }

    @Override
    protected int getBindPort() {
        return this.server.getBindPort();
    }
}

