/*
 * Decompiled with CFR 0.152.
 */
package snow.player.appwidget;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.common.base.Preconditions;
import com.tencent.mmkv.MMKV;
import snow.player.PlayMode;
import snow.player.PlaybackState;
import snow.player.PlayerService;
import snow.player.audio.MusicItem;

public class AppWidgetPlayerState
implements Parcelable {
    public static final String ACTION_PLAYER_STATE_CHANGED = "snow.player.appwidget.action.PLAYER_STATE_CHANGED";
    private static final String KEY_PLAYER_STATE = "PLAYER_STATE";
    private static boolean sMMKVInitialized;
    private final PlaybackState mPlaybackState;
    @Nullable
    private final MusicItem mPlayingMusicItem;
    private final PlayMode mPlayMode;
    private final long mPlayProgress;
    private final float mSpeed;
    private final long mPlayProgressUpdateTime;
    private final boolean mPreparing;
    private final boolean mPrepared;
    private final boolean mStalled;
    private final String mErrorMessage;
    public static final Parcelable.Creator<AppWidgetPlayerState> CREATOR;

    public AppWidgetPlayerState(@NonNull PlaybackState playbackState, @Nullable MusicItem playingMusicItem, @NonNull PlayMode playMode, float speed, long playProgress, long playProgressUpdateTime, boolean preparing, boolean prepared, boolean stalled, @NonNull String errorMessage) {
        Preconditions.checkNotNull((Object)((Object)playbackState));
        Preconditions.checkNotNull((Object)((Object)playMode));
        Preconditions.checkNotNull((Object)errorMessage);
        this.mPlaybackState = playbackState;
        this.mPlayingMusicItem = playingMusicItem;
        this.mPlayMode = playMode;
        this.mSpeed = speed;
        this.mPlayProgress = playProgress;
        this.mPlayProgressUpdateTime = playProgressUpdateTime;
        this.mPreparing = preparing;
        this.mPrepared = prepared;
        this.mStalled = stalled;
        this.mErrorMessage = errorMessage;
    }

    public static AppWidgetPlayerState emptyState() {
        return new AppWidgetPlayerState(PlaybackState.NONE, new MusicItem(), PlayMode.PLAYLIST_LOOP, 1.0f, 0L, 0L, false, false, false, "");
    }

    public static AppWidgetPlayerState getPlayerState(@NonNull Context context, @NonNull Class<? extends PlayerService> playerService) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull(playerService);
        MMKV mmkv = AppWidgetPlayerState.getMMKV(context, playerService);
        return (AppWidgetPlayerState)mmkv.decodeParcelable(KEY_PLAYER_STATE, AppWidgetPlayerState.class, (Parcelable)AppWidgetPlayerState.emptyState());
    }

    public static void updatePlayerState(@NonNull Context context, @NonNull Class<? extends PlayerService> playerService, @NonNull AppWidgetPlayerState playerState) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull(playerService);
        Preconditions.checkNotNull((Object)playerState);
        MMKV mmkv = AppWidgetPlayerState.getMMKV(context, playerService);
        mmkv.encode(KEY_PLAYER_STATE, (Parcelable)playerState);
        Intent intent = new Intent(ACTION_PLAYER_STATE_CHANGED);
        intent.addCategory(playerService.getName());
        context.sendBroadcast(intent);
    }

    private static MMKV getMMKV(@NonNull Context context, @NonNull Class<? extends PlayerService> playerService) {
        if (!sMMKVInitialized) {
            sMMKVInitialized = true;
            MMKV.initialize((Context)context);
        }
        String persistenceId = PlayerService.getPersistenceId(playerService);
        return MMKV.mmkvWithID((String)("AppWidgetPlayerState:" + persistenceId), (int)2);
    }

    @NonNull
    public PlaybackState getPlaybackState() {
        return this.mPlaybackState;
    }

    @Nullable
    public MusicItem getPlayingMusicItem() {
        return this.mPlayingMusicItem;
    }

    @NonNull
    public PlayMode getPlayMode() {
        return this.mPlayMode;
    }

    public float getSpeed() {
        return this.mSpeed;
    }

    public long getPlayProgress() {
        return this.mPlayProgress;
    }

    public long getPlayProgressUpdateTime() {
        return this.mPlayProgressUpdateTime;
    }

    public boolean isPreparing() {
        return this.mPreparing;
    }

    public boolean isPrepared() {
        return this.mPrepared;
    }

    public boolean isStalled() {
        return this.mStalled;
    }

    @NonNull
    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public static boolean isServiceAlive(Context context, Class<? extends PlayerService> playerService) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        for (ActivityManager.RunningServiceInfo serviceInfo : am.getRunningServices(100)) {
            if (!serviceInfo.service.equals((Object)new ComponentName(context, playerService))) continue;
            return true;
        }
        return false;
    }

    protected AppWidgetPlayerState(Parcel in) {
        this.mPlaybackState = PlaybackState.values()[in.readInt()];
        this.mPlayingMusicItem = (MusicItem)in.readParcelable(MusicItem.class.getClassLoader());
        this.mPlayMode = PlayMode.values()[in.readInt()];
        this.mSpeed = in.readFloat();
        this.mPlayProgress = in.readLong();
        this.mPlayProgressUpdateTime = in.readLong();
        this.mPreparing = in.readByte() != 0;
        this.mPrepared = in.readByte() != 0;
        this.mStalled = in.readByte() != 0;
        this.mErrorMessage = in.readString();
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mPlaybackState.ordinal());
        dest.writeParcelable((Parcelable)this.mPlayingMusicItem, flags);
        dest.writeInt(this.mPlayMode.ordinal());
        dest.writeFloat(this.mSpeed);
        dest.writeLong(this.mPlayProgress);
        dest.writeLong(this.mPlayProgressUpdateTime);
        dest.writeByte((byte)(this.mPreparing ? 1 : 0));
        dest.writeByte((byte)(this.mPrepared ? 1 : 0));
        dest.writeByte((byte)(this.mStalled ? 1 : 0));
        dest.writeString(this.mErrorMessage);
    }

    public int describeContents() {
        return 0;
    }

    static {
        CREATOR = new Parcelable.Creator<AppWidgetPlayerState>(){

            public AppWidgetPlayerState createFromParcel(Parcel in) {
                return new AppWidgetPlayerState(in);
            }

            public AppWidgetPlayerState[] newArray(int size) {
                return new AppWidgetPlayerState[size];
            }
        };
    }
}

