/*
 * Decompiled with CFR 0.152.
 */
package snow.player;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import snow.player.PlayMode;
import snow.player.PlayerStateListener;
import snow.player.audio.MusicItem;
import snow.player.playlist.PlaylistManager;

public final class PlayerStateListener__ChannelHelper {
    private static final String KEY_CLASS_NAME = "__class_name";
    private static final String KEY_METHOD_ID = "__method_id";
    private static final String CLASS_NAME = "snow.player.PlayerStateListener";
    private static final int METHOD_ID_1 = 1;
    private static final int METHOD_ID_2 = 2;
    private static final int METHOD_ID_3 = 3;
    private static final int METHOD_ID_4 = 4;
    private static final int METHOD_ID_5 = 5;
    private static final int METHOD_ID_6 = 6;
    private static final int METHOD_ID_7 = 7;
    private static final int METHOD_ID_8 = 8;
    private static final int METHOD_ID_9 = 9;
    private static final int METHOD_ID_10 = 10;
    private static final int METHOD_ID_11 = 11;
    private static final int METHOD_ID_12 = 12;
    private static final int METHOD_ID_13 = 13;
    private static final int METHOD_ID_14 = 14;
    private static final int METHOD_ID_15 = 15;
    private static final int METHOD_ID_16 = 16;

    private PlayerStateListener__ChannelHelper() {
        throw new AssertionError();
    }

    public static final class Dispatcher
    implements channel.helper.Dispatcher {
        private final WeakReference<PlayerStateListener> callbackWeakReference;

        public Dispatcher(PlayerStateListener callback) {
            this.callbackWeakReference = new WeakReference<PlayerStateListener>(callback);
        }

        public boolean match(Map<String, Object> data) {
            return PlayerStateListener__ChannelHelper.CLASS_NAME.equals(data.get(PlayerStateListener__ChannelHelper.KEY_CLASS_NAME));
        }

        public boolean dispatch(Map<String, Object> data) {
            if (!this.match(data)) {
                return false;
            }
            int methodId = (Integer)data.get(PlayerStateListener__ChannelHelper.KEY_METHOD_ID);
            PlayerStateListener callback = (PlayerStateListener)this.callbackWeakReference.get();
            if (callback == null) {
                return false;
            }
            switch (methodId) {
                case 1: {
                    boolean METHOD_ID_1_stalled = (Boolean)data.get("stalled");
                    int METHOD_ID_1_playProgress = (Integer)data.get("playProgress");
                    long METHOD_ID_1_playProgressUpdateTime = (Long)data.get("playProgressUpdateTime");
                    callback.onPlay(METHOD_ID_1_stalled, METHOD_ID_1_playProgress, METHOD_ID_1_playProgressUpdateTime);
                    return true;
                }
                case 2: {
                    int METHOD_ID_2_playProgress = (Integer)data.get("playProgress");
                    long METHOD_ID_2_updateTime = (Long)data.get("updateTime");
                    callback.onPause(METHOD_ID_2_playProgress, METHOD_ID_2_updateTime);
                    return true;
                }
                case 3: {
                    callback.onStop();
                    return true;
                }
                case 4: {
                    int METHOD_ID_4_errorCode = (Integer)data.get("errorCode");
                    String METHOD_ID_4_errorMessage = (String)data.get("errorMessage");
                    callback.onError(METHOD_ID_4_errorCode, METHOD_ID_4_errorMessage);
                    return true;
                }
                case 5: {
                    callback.onPreparing();
                    return true;
                }
                case 6: {
                    int METHOD_ID_6_audioSessionId = (Integer)data.get("audioSessionId");
                    callback.onPrepared(METHOD_ID_6_audioSessionId);
                    return true;
                }
                case 7: {
                    int METHOD_ID_7_audioSessionId = (Integer)data.get("audioSessionId");
                    int METHOD_ID_7_duration = (Integer)data.get("duration");
                    callback.onPrepared(METHOD_ID_7_audioSessionId, METHOD_ID_7_duration);
                    return true;
                }
                case 8: {
                    boolean METHOD_ID_8_stalled = (Boolean)data.get("stalled");
                    int METHOD_ID_8_playProgress = (Integer)data.get("playProgress");
                    long METHOD_ID_8_updateTime = (Long)data.get("updateTime");
                    callback.onStalledChanged(METHOD_ID_8_stalled, METHOD_ID_8_playProgress, METHOD_ID_8_updateTime);
                    return true;
                }
                case 9: {
                    int METHOD_ID_9_bufferedProgress = (Integer)data.get("bufferedProgress");
                    callback.onBufferedProgressChanged(METHOD_ID_9_bufferedProgress);
                    return true;
                }
                case 10: {
                    MusicItem METHOD_ID_10_musicItem = (MusicItem)data.get("musicItem");
                    int METHOD_ID_10_position = (Integer)data.get("position");
                    int METHOD_ID_10_playProgress = (Integer)data.get("playProgress");
                    callback.onPlayingMusicItemChanged(METHOD_ID_10_musicItem, METHOD_ID_10_position, METHOD_ID_10_playProgress);
                    return true;
                }
                case 11: {
                    int METHOD_ID_11_progress = (Integer)data.get("progress");
                    long METHOD_ID_11_updateTime = (Long)data.get("updateTime");
                    boolean METHOD_ID_11_stalled = (Boolean)data.get("stalled");
                    callback.onSeekComplete(METHOD_ID_11_progress, METHOD_ID_11_updateTime, METHOD_ID_11_stalled);
                    return true;
                }
                case 12: {
                    PlaylistManager METHOD_ID_12_playlistManager = (PlaylistManager)data.get("playlistManager");
                    int METHOD_ID_12_position = (Integer)data.get("position");
                    callback.onPlaylistChanged(METHOD_ID_12_playlistManager, METHOD_ID_12_position);
                    return true;
                }
                case 13: {
                    PlayMode METHOD_ID_13_playMode = PlayMode.values()[(Integer)data.get("playMode")];
                    callback.onPlayModeChanged(METHOD_ID_13_playMode);
                    return true;
                }
                case 14: {
                    MusicItem METHOD_ID_14_musicItem = (MusicItem)data.get("musicItem");
                    long METHOD_ID_14_repeatTime = (Long)data.get("repeatTime");
                    callback.onRepeat(METHOD_ID_14_musicItem, METHOD_ID_14_repeatTime);
                    return true;
                }
                case 15: {
                    float METHOD_ID_15_speed = ((Float)data.get("speed")).floatValue();
                    int METHOD_ID_15_playProgress = (Integer)data.get("playProgress");
                    long METHOD_ID_15_playProgressUpdateTime = (Long)data.get("playProgressUpdateTime");
                    callback.onSpeedChanged(METHOD_ID_15_speed, METHOD_ID_15_playProgress, METHOD_ID_15_playProgressUpdateTime);
                    return true;
                }
                case 16: {
                    callback.onShutdown();
                    return true;
                }
            }
            return false;
        }
    }

    public static final class Emitter
    implements PlayerStateListener {
        private channel.helper.Emitter emitter;

        public Emitter(channel.helper.Emitter emitter) {
            this.emitter = emitter;
        }

        private void sendMessage(int id, Map<String, Object> args) {
            args.put(PlayerStateListener__ChannelHelper.KEY_CLASS_NAME, PlayerStateListener__ChannelHelper.CLASS_NAME);
            args.put(PlayerStateListener__ChannelHelper.KEY_METHOD_ID, id);
            this.emitter.emit(args);
        }

        @Override
        public void onPlay(boolean stalled, int playProgress, long playProgressUpdateTime) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("stalled", stalled);
            args.put("playProgress", playProgress);
            args.put("playProgressUpdateTime", playProgressUpdateTime);
            this.sendMessage(1, args);
        }

        @Override
        public void onPause(int playProgress, long updateTime) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("playProgress", playProgress);
            args.put("updateTime", updateTime);
            this.sendMessage(2, args);
        }

        @Override
        public void onStop() {
            HashMap<String, Object> args = new HashMap<String, Object>();
            this.sendMessage(3, args);
        }

        @Override
        public void onError(int errorCode, String errorMessage) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("errorCode", errorCode);
            args.put("errorMessage", errorMessage);
            this.sendMessage(4, args);
        }

        @Override
        public void onPreparing() {
            HashMap<String, Object> args = new HashMap<String, Object>();
            this.sendMessage(5, args);
        }

        @Override
        public void onPrepared(int audioSessionId) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("audioSessionId", audioSessionId);
            this.sendMessage(6, args);
        }

        @Override
        public void onPrepared(int audioSessionId, int duration) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("audioSessionId", audioSessionId);
            args.put("duration", duration);
            this.sendMessage(7, args);
        }

        @Override
        public void onStalledChanged(boolean stalled, int playProgress, long updateTime) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("stalled", stalled);
            args.put("playProgress", playProgress);
            args.put("updateTime", updateTime);
            this.sendMessage(8, args);
        }

        @Override
        public void onBufferedProgressChanged(int bufferedProgress) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("bufferedProgress", bufferedProgress);
            this.sendMessage(9, args);
        }

        @Override
        public void onPlayingMusicItemChanged(MusicItem musicItem, int position, int playProgress) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("musicItem", musicItem);
            args.put("position", position);
            args.put("playProgress", playProgress);
            this.sendMessage(10, args);
        }

        @Override
        public void onSeekComplete(int progress, long updateTime, boolean stalled) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("progress", progress);
            args.put("updateTime", updateTime);
            args.put("stalled", stalled);
            this.sendMessage(11, args);
        }

        @Override
        public void onPlaylistChanged(PlaylistManager playlistManager, int position) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("playlistManager", playlistManager);
            args.put("position", position);
            this.sendMessage(12, args);
        }

        @Override
        public void onPlayModeChanged(PlayMode playMode) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("playMode", playMode.ordinal());
            this.sendMessage(13, args);
        }

        @Override
        public void onRepeat(MusicItem musicItem, long repeatTime) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("musicItem", musicItem);
            args.put("repeatTime", repeatTime);
            this.sendMessage(14, args);
        }

        @Override
        public void onSpeedChanged(float speed, int playProgress, long playProgressUpdateTime) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("speed", Float.valueOf(speed));
            args.put("playProgress", playProgress);
            args.put("playProgressUpdateTime", playProgressUpdateTime);
            this.sendMessage(15, args);
        }

        @Override
        public void onShutdown() {
            HashMap<String, Object> args = new HashMap<String, Object>();
            this.sendMessage(16, args);
        }
    }
}

