/*
 * Decompiled with CFR 0.152.
 */
package snow.player;

import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.common.base.Preconditions;
import snow.player.PlayMode;
import snow.player.PlaybackState;
import snow.player.PlayerState;
import snow.player.SleepTimer;
import snow.player.audio.MusicItem;

class PlayerStateHelper {
    private final PlayerState mPlayerState;

    public PlayerStateHelper(@NonNull PlayerState playerState) {
        Preconditions.checkNotNull((Object)playerState);
        this.mPlayerState = playerState;
    }

    protected PlayerState getPlayerState() {
        return this.mPlayerState;
    }

    void updatePlayProgress(int progress, long updateTime) {
        this.mPlayerState.setPlayProgress(progress);
        this.mPlayerState.setPlayProgressUpdateTime(updateTime);
    }

    public void onPreparing() {
        this.mPlayerState.setPreparing(true);
        this.mPlayerState.setPrepared(false);
        if (this.mPlayerState.getPlaybackState() == PlaybackState.ERROR) {
            this.mPlayerState.setPlaybackState(PlaybackState.NONE);
            this.mPlayerState.setErrorCode(0);
            this.mPlayerState.setErrorMessage("");
        }
    }

    public void onPrepared(int audioSessionId, int duration) {
        this.mPlayerState.setPreparing(false);
        this.mPlayerState.setPrepared(true);
        this.mPlayerState.setAudioSessionId(audioSessionId);
        this.mPlayerState.setDuration(duration);
    }

    public void clearPrepareState() {
        this.mPlayerState.setPreparing(false);
        this.mPlayerState.setPrepared(false);
    }

    public void onPlay(boolean stalled, int progress, long updateTime) {
        this.mPlayerState.setStalled(stalled);
        this.mPlayerState.setPlaybackState(PlaybackState.PLAYING);
        this.updatePlayProgress(progress, updateTime);
    }

    public void onPaused(int playProgress, long updateTime) {
        this.mPlayerState.setPlaybackState(PlaybackState.PAUSED);
        this.mPlayerState.setPlayProgress(playProgress);
        this.mPlayerState.setPlayProgressUpdateTime(updateTime);
    }

    public void onStopped() {
        this.mPlayerState.setPlaybackState(PlaybackState.STOPPED);
        long updateTime = SystemClock.elapsedRealtime();
        this.updatePlayProgress(0, updateTime);
        this.clearPrepareState();
    }

    public void onStalled(boolean stalled, int playProgress, long updateTime) {
        this.mPlayerState.setStalled(stalled);
        this.updatePlayProgress(playProgress, updateTime);
    }

    public void onRepeat(long repeatTime) {
        this.updatePlayProgress(0, repeatTime);
    }

    public void onError(int errorCode, String errorMessage) {
        this.mPlayerState.setPlaybackState(PlaybackState.ERROR);
        this.mPlayerState.setErrorCode(errorCode);
        this.mPlayerState.setErrorMessage(errorMessage);
        this.clearPrepareState();
    }

    public void onBufferedChanged(int bufferedProgress) {
        this.mPlayerState.setBufferedProgress(bufferedProgress);
    }

    public void onPlayingMusicItemChanged(@Nullable MusicItem musicItem, int position, int playProgress) {
        this.mPlayerState.setMusicItem(musicItem);
        this.mPlayerState.setPlayPosition(position);
        this.mPlayerState.setBufferedProgress(0);
        long updateTime = SystemClock.elapsedRealtime();
        this.updatePlayProgress(playProgress, updateTime);
        if (this.mPlayerState.getPlaybackState() == PlaybackState.ERROR) {
            this.mPlayerState.setPlaybackState(PlaybackState.NONE);
            this.mPlayerState.setErrorCode(0);
            this.mPlayerState.setErrorMessage("");
        }
    }

    public void onSeekComplete(int playProgress, long updateTime, boolean stalled) {
        this.updatePlayProgress(playProgress, updateTime);
        this.mPlayerState.setStalled(stalled);
    }

    public void onPlaylistChanged(int position) {
        this.mPlayerState.setPlayPosition(position);
    }

    public void onPlayModeChanged(PlayMode playMode) {
        this.mPlayerState.setPlayMode(playMode);
    }

    public void onSpeedChanged(float speed, int progress, long updateTime) {
        this.mPlayerState.setSpeed(speed);
        this.updatePlayProgress(progress, updateTime);
    }

    public void onSleepTimerStart(long time, long startTime, SleepTimer.TimeoutAction action) {
        this.mPlayerState.setSleepTimerStarted(true);
        this.mPlayerState.setSleepTimerTime(time);
        this.mPlayerState.setSleepTimerStartTime(startTime);
        this.mPlayerState.setTimeoutAction(action);
        this.mPlayerState.setSleepTimerEnd(false);
        this.mPlayerState.setSleepTimerTimeout(false);
    }

    public void onSleepTimerTimeout(boolean actionComplete) {
        this.mPlayerState.setSleepTimerTimeout(true);
        this.mPlayerState.setSleepTimerEnd(actionComplete);
    }

    public void onSleepTimerEnd() {
        this.mPlayerState.setSleepTimerStarted(false);
        this.mPlayerState.setSleepTimerTime(0L);
        this.mPlayerState.setSleepTimerStartTime(0L);
        this.mPlayerState.setSleepTimerEnd(true);
    }

    public void onWaitPlayCompleteChanged(boolean waitPlayComplete) {
        this.mPlayerState.setWaitPlayComplete(waitPlayComplete);
    }
}

