/*
 * Decompiled with CFR 0.152.
 */
package snow.player;

import android.app.ActivityManager;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.media.AudioManager;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.support.v4.media.MediaBrowserCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.NotificationCompat;
import androidx.core.content.res.ResourcesCompat;
import androidx.media.MediaBrowserServiceCompat;
import androidx.media.app.NotificationCompat;
import androidx.media.session.MediaButtonReceiver;
import channel.helper.ChannelHelper;
import channel.helper.Dispatcher;
import channel.helper.DispatcherUtil;
import channel.helper.Emitter;
import channel.helper.pipe.CustomActionPipe;
import channel.helper.pipe.SessionEventPipe;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.FutureTarget;
import com.google.common.base.Preconditions;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import io.reactivex.SingleOnSubscribe;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Cancellable;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import media.helper.HeadsetHookHelper;
import snow.player.AbstractPlayer;
import snow.player.HistoryRecorder;
import snow.player.PersistentPlayerState;
import snow.player.PlayMode;
import snow.player.PlaybackState;
import snow.player.Player;
import snow.player.PlayerConfig;
import snow.player.PlayerManager;
import snow.player.PlayerState;
import snow.player.PlayerStateListener;
import snow.player.PlayerStateSynchronizer;
import snow.player.PlaylistManagerImp;
import snow.player.R;
import snow.player.SleepTimer;
import snow.player.SleepTimerImp;
import snow.player.SoundQuality;
import snow.player.annotation.PersistenceId;
import snow.player.audio.ErrorCode;
import snow.player.audio.MediaMusicPlayer;
import snow.player.audio.MusicItem;
import snow.player.audio.MusicPlayer;
import snow.player.effect.AudioEffectManager;
import snow.player.playlist.Playlist;
import snow.player.playlist.PlaylistEditor;
import snow.player.playlist.PlaylistManager;
import snow.player.util.AsyncResult;
import snow.player.util.MusicItemUtil;
import snow.player.util.Util;

public class PlayerService
extends MediaBrowserServiceCompat
implements PlayerManager,
PlaylistManager,
PlaylistEditor,
SleepTimer {
    public static final String DEFAULT_MEDIA_ROOT_ID = "root";
    public static final String CUSTOM_ACTION_SHUTDOWN = "snow.player.custom_action.SHUTDOWN";
    public static final String SESSION_EVENT_ON_SHUTDOWN = "snow.player.session_event.ON_SHUTDOWN";
    private static final String CUSTOM_ACTION_NAME = "snow.player.action.ACTION_NAME";
    private String mPersistentId;
    private PlayerConfig mPlayerConfig;
    private PlayerState mPlayerState;
    private PlaylistManagerImp mPlaylistManager;
    private PlayerImp mPlayer;
    private CustomActionPipe mCustomActionDispatcher;
    private PlayerStateListener mPlayerStateListener;
    private PlayerStateSynchronizer.OnSyncPlayerStateListener mSyncPlayerStateListener;
    private boolean mForeground;
    private NotificationManager mNotificationManager;
    private Map<String, CustomAction> mAllCustomAction;
    private MediaSessionCompat mMediaSession;
    private HeadsetHookHelper mHeadsetHookHelper;
    @Nullable
    private NotificationView mNotificationView;
    @Nullable
    private AudioEffectManager mAudioEffectManager;
    @Nullable
    private HistoryRecorder mHistoryRecorder;
    private SleepTimerImp mSleepTimer;
    private int mMaxIDLEMinutes = -1;
    private Disposable mIDLETimerDisposable;
    private Intent mKeepAliveIntent;
    private KeepAliveConnection mKeepAliveConnection;
    private boolean mKeepServiceAlive;
    private BroadcastReceiver mCustomActionReceiver;
    private PlayerStateSynchronizer mPlayerStateSynchronizer;
    private AbstractPlayer.OnStateChangeListener mOnStateChangeListener;
    private HandlerThread mSyncPlayerStateHandlerThread;
    private Handler mSyncPlayerStateHandler;
    private CountDownLatch mPlayerPrepareLatch;

    public void onCreate() {
        super.onCreate();
        this.mPersistentId = PlayerService.getPersistenceId(this.getClass());
        this.mAllCustomAction = new HashMap<String, CustomAction>();
        this.mKeepAliveIntent = new Intent((Context)this, this.getClass());
        this.mKeepAliveConnection = new KeepAliveConnection();
        this.mPlayerPrepareLatch = new CountDownLatch(1);
        this.mPlayerStateSynchronizer = new PlayerStateSynchronizer(){

            @Override
            public void syncPlayerState(String clientToken) {
                Message message = PlayerService.this.mSyncPlayerStateHandler.obtainMessage();
                message.obj = clientToken;
                PlayerService.this.mSyncPlayerStateHandler.sendMessage(message);
            }
        };
        this.initNotificationManager();
        this.initPlayerConfig();
        this.initPlayerState();
        this.initPlaylistManager();
        this.initNotificationView();
        this.initOnStateChangeListener();
        this.initPlayer();
        this.initAudioEffectManager();
        this.initCustomActionDispatcher();
        this.initHeadsetHookHelper();
        this.initMediaSession();
        this.initSessionEventEmitter();
        this.initHistoryRecorder();
        this.initCustomActionReceiver();
        this.initSyncPlayerStateHandler();
        this.preparePlayer();
        this.keepServiceAlive();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent != null) {
            MediaButtonReceiver.handleIntent((MediaSessionCompat)this.mMediaSession, (Intent)intent);
        }
        return 2;
    }

    private void handleCustomAction(String action, Bundle extras) {
        CustomAction customAction = this.mAllCustomAction.get(action);
        if (customAction != null) {
            customAction.doAction(this.getPlayer(), extras);
        }
    }

    @Nullable
    public MediaBrowserServiceCompat.BrowserRoot onGetRoot(@NonNull String clientPackageName, int clientUid, @Nullable Bundle rootHints) {
        return new MediaBrowserServiceCompat.BrowserRoot(DEFAULT_MEDIA_ROOT_ID, null);
    }

    public void onLoadChildren(@NonNull String parentId, @NonNull MediaBrowserServiceCompat.Result<List<MediaBrowserCompat.MediaItem>> result) {
        result.sendResult(Collections.emptyList());
    }

    public void onDestroy() {
        super.onDestroy();
        this.mSyncPlayerStateHandlerThread.quit();
        if (!this.noNotificationView()) {
            this.stopForegroundEx(true);
            this.mNotificationView.release();
            this.mNotificationManager.cancel(this.mNotificationView.getNotificationId());
        }
        this.cancelIDLETimer();
        this.unregisterReceiver(this.mCustomActionReceiver);
        this.mMediaSession.release();
        this.mPlayer.release();
        this.mPlayer = null;
        if (this.mAudioEffectManager != null) {
            this.mAudioEffectManager.release();
        }
    }

    boolean isPlaying() {
        return this.mPlayer.isMusicPlayerPlaying();
    }

    private void keepServiceAlive() {
        if (this.mKeepServiceAlive) {
            return;
        }
        this.mKeepServiceAlive = true;
        this.bindService(this.mKeepAliveIntent, this.mKeepAliveConnection, 1);
    }

    private void preparePlayer() {
        this.mPlayer.initialize(new AbstractPlayer.OnInitializedListener(){

            @Override
            public void onInitialized() {
                PlayerService.this.mPlayerPrepareLatch.countDown();
            }
        });
    }

    private void dismissKeepServiceAlive() {
        if (this.mKeepServiceAlive) {
            this.mKeepServiceAlive = false;
            this.unbindService(this.mKeepAliveConnection);
        }
    }

    private void initNotificationManager() {
        this.mNotificationManager = (NotificationManager)this.getSystemService("notification");
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel channel = new NotificationChannel("player", (CharSequence)this.getString(R.string.snow_notification_channel_name), 2);
            channel.setShowBadge(false);
            this.mNotificationManager.createNotificationChannel(channel);
        }
    }

    private void initPlayerConfig() {
        this.mPlayerConfig = new PlayerConfig((Context)this, this.mPersistentId);
    }

    private void initPlayerState() {
        this.mPlayerState = new PersistentPlayerState((Context)this, this.mPersistentId);
    }

    private void initPlaylistManager() {
        this.mPlaylistManager = new PlaylistManagerImp((Context)this, this.mPersistentId);
    }

    private void initOnStateChangeListener() {
        this.mOnStateChangeListener = new AbstractPlayer.OnStateChangeListener(){

            @Override
            public void onPreparing() {
                PlayerService.this.updateNotificationView();
                PlayerService.this.cancelIDLETimer();
            }

            @Override
            public void onPrepared(int audioSessionId) {
                PlayerService.this.updateNotificationView();
            }

            @Override
            public void onPlaying(int progress, long updateTime) {
                PlayerService.this.updateNotificationView();
                PlayerService.this.cancelIDLETimer();
            }

            @Override
            public void onPaused() {
                PlayerService.this.updateNotificationView();
                PlayerService.this.startIDLETimer();
            }

            @Override
            public void onStalledChanged(boolean stalled) {
                PlayerService.this.updateNotificationView();
            }

            @Override
            public void onStopped() {
                PlayerService.this.updateNotificationView();
                PlayerService.this.startIDLETimer();
            }

            @Override
            public void onError(int errorCode, String errorMessage) {
                PlayerService.this.updateNotificationView();
            }

            @Override
            public void onPlayingMusicItemChanged(@Nullable MusicItem musicItem) {
                PlayerService.this.onPlayingMusicItemChanged(musicItem);
            }

            @Override
            public void onPlayModeChanged(@NonNull PlayMode playMode) {
                PlayerService.this.notifyPlayModeChanged(playMode);
            }
        };
    }

    private void initPlayer() {
        this.mPlayer = new PlayerImp((Context)this, this.mPlayerConfig, this.mPlayerState, this.mPlaylistManager, this.getClass(), this.mOnStateChangeListener);
    }

    private void initCustomActionDispatcher() {
        Dispatcher playerStateSynchronizerDispatcher = ChannelHelper.newDispatcher(PlayerStateSynchronizer.class, (Object)this.mPlayerStateSynchronizer);
        Dispatcher playerManagerDispatcher = ChannelHelper.newDispatcher(PlayerManager.class, (Object)this);
        Dispatcher playerDispatcher = ChannelHelper.newDispatcher(Player.class, (Object)this.mPlayer);
        Dispatcher playlistEditorDispatcher = ChannelHelper.newDispatcher(PlaylistEditor.class, (Object)this.mPlayer);
        Dispatcher sleepTimerDispatcher = ChannelHelper.newDispatcher(SleepTimer.class, (Object)this);
        this.mCustomActionDispatcher = new CustomActionPipe(DispatcherUtil.merge((Dispatcher)playerStateSynchronizerDispatcher, (Dispatcher[])new Dispatcher[]{playerManagerDispatcher, playerDispatcher, playlistEditorDispatcher, sleepTimerDispatcher}));
    }

    private void initNotificationView() {
        NotificationView notificationView = this.onCreateNotificationView();
        if (notificationView == null) {
            return;
        }
        notificationView.init(this);
        MusicItem musicItem = this.getPlayingMusicItem();
        if (musicItem != null) {
            notificationView.setPlayingMusicItem(musicItem);
        }
        this.mNotificationView = notificationView;
    }

    private void initHeadsetHookHelper() {
        this.mHeadsetHookHelper = new HeadsetHookHelper(new HeadsetHookHelper.OnHeadsetHookClickListener(){

            public void onHeadsetHookClicked(int clickCount) {
                PlayerService.this.onHeadsetHookClicked(clickCount);
            }
        });
    }

    private void initMediaSession() {
        this.mMediaSession = new MediaSessionCompat((Context)this, this.getClass().getName());
        this.mPlayer.setMediaSession(this.mMediaSession);
        this.mMediaSession.setCallback((MediaSessionCompat.Callback)this.onCreateMediaSessionCallback(), new Handler(Looper.getMainLooper()));
        this.setSessionToken(this.mMediaSession.getSessionToken());
    }

    private void initSessionEventEmitter() {
        SessionEventPipe sessionEventEmitter = new SessionEventPipe(this.mMediaSession);
        this.mPlayerStateListener = (PlayerStateListener)ChannelHelper.newEmitter(PlayerStateListener.class, (Emitter)sessionEventEmitter);
        this.mSyncPlayerStateListener = (PlayerStateSynchronizer.OnSyncPlayerStateListener)ChannelHelper.newEmitter(PlayerStateSynchronizer.OnSyncPlayerStateListener.class, (Emitter)sessionEventEmitter);
        this.mSleepTimer = new SleepTimerImp(this, this.mPlayerState, (SleepTimer.OnStateChangeListener2)ChannelHelper.newEmitter(SleepTimer.OnStateChangeListener2.class, (Emitter)sessionEventEmitter), (SleepTimer.OnWaitPlayCompleteChangeListener)ChannelHelper.newEmitter(SleepTimer.OnWaitPlayCompleteChangeListener.class, (Emitter)sessionEventEmitter));
        this.mPlayer.setPlayerStateListener(this.mPlayerStateListener);
        this.mPlayer.setSleepTimer(this.mSleepTimer);
    }

    private void initAudioEffectManager() {
        this.mAudioEffectManager = this.onCreateAudioEffectManager();
        if (this.mAudioEffectManager == null) {
            return;
        }
        Bundle config = this.mPlayerConfig.getAudioEffectConfig();
        this.mAudioEffectManager.init(config);
        this.mPlayer.setAudioEffectManager(this.mAudioEffectManager);
    }

    private void initHistoryRecorder() {
        this.mHistoryRecorder = this.onCreateHistoryRecorder();
    }

    private void initCustomActionReceiver() {
        this.mCustomActionReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (intent != null) {
                    PlayerService.this.onCustomAction(intent.getStringExtra(PlayerService.CUSTOM_ACTION_NAME), intent.getExtras());
                }
            }
        };
        IntentFilter filter = new IntentFilter(this.getClass().getName());
        this.registerReceiver(this.mCustomActionReceiver, filter);
    }

    private void initSyncPlayerStateHandler() {
        this.mSyncPlayerStateHandlerThread = new HandlerThread("PlayerStateSyncThread");
        this.mSyncPlayerStateHandlerThread.start();
        this.mSyncPlayerStateHandler = new Handler(this.mSyncPlayerStateHandlerThread.getLooper()){

            public void handleMessage(@NonNull Message msg) {
                try {
                    PlayerService.this.mPlayerPrepareLatch.await();
                    PlayerService.this.mSyncPlayerStateListener.onSyncPlayerState((String)msg.obj, new PlayerState(PlayerService.this.mPlayerState));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    protected void setMediaSessionFlags(int flags) {
        this.mMediaSession.setFlags(flags);
    }

    @NonNull
    protected MediaSessionCallback onCreateMediaSessionCallback() {
        return new MediaSessionCallback(this);
    }

    @Nullable
    protected NotificationView onCreateNotificationView() {
        return new MediaNotificationView();
    }

    @Nullable
    protected AudioEffectManager onCreateAudioEffectManager() {
        return null;
    }

    @Nullable
    protected HistoryRecorder onCreateHistoryRecorder() {
        return null;
    }

    @Override
    public void setSoundQuality(SoundQuality soundQuality) {
        if (soundQuality == this.mPlayerConfig.getSoundQuality()) {
            return;
        }
        this.mPlayerConfig.setSoundQuality(soundQuality);
        this.mPlayer.notifySoundQualityChanged();
    }

    @Override
    public void setAudioEffectEnabled(boolean enabled) {
        if (this.mPlayerConfig.isAudioEffectEnabled() == enabled) {
            return;
        }
        this.mPlayerConfig.setAudioEffectEnabled(enabled);
        this.notifyAudioEffectEnableChanged();
    }

    @Override
    public void setAudioEffectConfig(Bundle config) {
        if (this.noAudioEffectManager() || !this.mPlayerConfig.isAudioEffectEnabled()) {
            return;
        }
        this.mAudioEffectManager.updateConfig(config);
        this.mPlayerConfig.setAudioEffectConfig(config);
    }

    protected void onHeadsetHookClicked(int clickCount) {
        switch (clickCount) {
            case 1: {
                this.getPlayer().playPause();
                break;
            }
            case 2: {
                this.getPlayer().skipToNext();
                break;
            }
            case 3: {
                this.getPlayer().skipToPrevious();
            }
        }
    }

    private boolean noAudioEffectManager() {
        return this.mAudioEffectManager == null;
    }

    @Deprecated
    protected void attachAudioEffect(int audioSessionId) {
        if (this.noAudioEffectManager()) {
            return;
        }
        this.mAudioEffectManager.attachAudioEffect(audioSessionId);
    }

    @Deprecated
    protected void detachAudioEffect() {
        if (this.noAudioEffectManager()) {
            return;
        }
        this.mAudioEffectManager.detachAudioEffect();
    }

    private void notifyAudioEffectEnableChanged() {
        this.mPlayer.notifyAudioEffectEnableChanged();
    }

    @Override
    public void setOnlyWifiNetwork(boolean onlyWifiNetwork) {
        if (this.mPlayerConfig.isOnlyWifiNetwork() == onlyWifiNetwork) {
            return;
        }
        this.mPlayerConfig.setOnlyWifiNetwork(onlyWifiNetwork);
        this.mPlayer.notifyOnlyWifiNetworkChanged();
    }

    @Override
    public void setIgnoreAudioFocus(boolean ignoreAudioFocus) {
        if (ignoreAudioFocus == this.mPlayerConfig.isIgnoreAudioFocus()) {
            return;
        }
        this.mPlayerConfig.setIgnoreAudioFocus(ignoreAudioFocus);
        this.mPlayer.notifyIgnoreAudioFocusChanged();
    }

    @Override
    public final void shutdown() {
        if (this.mPlayer.getPlaybackState() == PlaybackState.PLAYING) {
            this.getPlayer().pause();
        }
        this.stopSelf();
        this.notifyOnShutdown();
        this.dismissKeepServiceAlive();
    }

    public boolean isIgnoreAudioFocus() {
        return this.mPlayerConfig.isIgnoreAudioFocus();
    }

    public final void setMaxIDLETime(int minutes) {
        this.mMaxIDLEMinutes = minutes;
        if (minutes <= 0) {
            this.cancelIDLETimer();
            return;
        }
        this.startIDLETimer();
    }

    private void startIDLETimer() {
        this.cancelIDLETimer();
        if (this.mMaxIDLEMinutes <= 0 || this.notIDLE()) {
            return;
        }
        this.mIDLETimerDisposable = Observable.timer((long)this.mMaxIDLEMinutes, (TimeUnit)TimeUnit.MINUTES).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Long>(){

            public void accept(Long aLong) {
                PlayerService.this.shutdown();
            }
        });
    }

    private boolean notIDLE() {
        return this.isPreparing() || this.isStalled() || this.getPlaybackState() == PlaybackState.PLAYING;
    }

    private void cancelIDLETimer() {
        if (this.mIDLETimerDisposable != null && !this.mIDLETimerDisposable.isDisposed()) {
            this.mIDLETimerDisposable.dispose();
        }
    }

    protected final MediaSessionCompat getMediaSession() {
        return this.mMediaSession;
    }

    protected final void addCustomAction(@NonNull String action, @NonNull CustomAction customAction) {
        this.mAllCustomAction.put(action, customAction);
    }

    public Intent buildCustomActionIntent(@NonNull String actionName) {
        Preconditions.checkNotNull((Object)actionName);
        return PlayerService.buildCustomActionIntent(actionName, this.getClass());
    }

    public static Intent buildCustomActionIntent(@NonNull String actionName, @NonNull Class<? extends PlayerService> service) {
        Preconditions.checkNotNull((Object)actionName);
        Preconditions.checkNotNull(service);
        Intent intent = new Intent(service.getName());
        intent.putExtra(CUSTOM_ACTION_NAME, actionName);
        return intent;
    }

    @NonNull
    public static String getPersistenceId(@NonNull Class<? extends PlayerService> service) throws IllegalArgumentException {
        Preconditions.checkNotNull(service);
        PersistenceId annotation = service.getAnnotation(PersistenceId.class);
        if (annotation == null) {
            return service.getName();
        }
        String persistenceId = annotation.value();
        if (persistenceId.isEmpty()) {
            throw new IllegalArgumentException("Persistence ID is empty.");
        }
        return persistenceId;
    }

    protected final void removeCustomAction(@NonNull String action) {
        this.mAllCustomAction.remove(action);
    }

    private void notifyOnShutdown() {
        if (this.mPlayerState.isSleepTimerStarted()) {
            this.cancelSleepTimer();
        }
        this.mPlayerStateListener.onShutdown();
        this.mMediaSession.sendSessionEvent(SESSION_EVENT_ON_SHUTDOWN, null);
    }

    public final PlayMode getPlayMode() {
        return this.mPlayerState.getPlayMode();
    }

    @Nullable
    public final Bundle getPlaylistExtra() {
        return this.mPlayer.getPlaylistExtra();
    }

    @NonNull
    public final PlaybackState getPlaybackState() {
        return this.mPlayer.getPlaybackState();
    }

    public final boolean isStalled() {
        return this.mPlayer.isStalled();
    }

    public final MusicItem getPlayingMusicItem() {
        return this.mPlayerState.getMusicItem();
    }

    public final boolean isError() {
        return this.getErrorCode() != 0;
    }

    public final int getErrorCode() {
        return this.mPlayerState.getErrorCode();
    }

    public final String getErrorMessage() {
        return ErrorCode.getErrorMessage((Context)this, this.getErrorCode());
    }

    public final void updateNotificationView() {
        if (Build.VERSION.SDK_INT >= 31) {
            this.updateNotificationViewAPI31();
            return;
        }
        if (this.noNotificationView()) {
            return;
        }
        if (this.mNotificationView.interceptUpdateNotification()) {
            return;
        }
        MusicItem musicItem = this.getPlayingMusicItem();
        if (musicItem == null || this.shouldClearNotification()) {
            this.stopForegroundEx(true);
            return;
        }
        if (this.shouldBeForeground() && !this.isForeground()) {
            this.startForeground();
            return;
        }
        if (!this.shouldBeForeground() && this.isForeground()) {
            this.stopForegroundEx(false);
        }
        this.updateNotification();
    }

    private void updateNotificationViewAPI31() {
        if (this.noNotificationView()) {
            return;
        }
        if (this.mNotificationView.interceptUpdateNotification()) {
            return;
        }
        MusicItem musicItem = this.getPlayingMusicItem();
        if (musicItem == null) {
            this.stopForegroundEx(true);
            return;
        }
        if (!this.isForeground()) {
            this.startForeground();
            return;
        }
        this.updateNotification();
    }

    private boolean shouldClearNotification() {
        if (this.mNotificationView == null) {
            return true;
        }
        return this.mPlayerState.getPlaybackState() == PlaybackState.STOPPED;
    }

    private boolean noNotificationView() {
        return this.mNotificationView == null;
    }

    private boolean shouldBeForeground() {
        return this.mPlayer.getPlaybackState() == PlaybackState.PLAYING;
    }

    protected final boolean isForeground() {
        return this.mForeground;
    }

    protected final void startForeground() {
        if (this.noNotificationView()) {
            return;
        }
        if (this.getPlayingMusicItem() == null) {
            this.stopForegroundEx(true);
            return;
        }
        if (this.isBackgroundRestricted()) {
            this.mForeground = false;
            this.updateNotification();
            return;
        }
        this.mForeground = true;
        if (Build.VERSION.SDK_INT >= 29) {
            this.startForeground(this.mNotificationView.getNotificationId(), this.mNotificationView.createNotification(), 2);
        } else {
            this.startForeground(this.mNotificationView.getNotificationId(), this.mNotificationView.createNotification());
        }
    }

    private boolean isBackgroundRestricted() {
        if (Build.VERSION.SDK_INT >= 28) {
            ActivityManager activityManager = (ActivityManager)this.getSystemService("activity");
            return activityManager.isBackgroundRestricted();
        }
        return false;
    }

    protected final void stopForegroundEx(boolean removeNotification) {
        this.mForeground = false;
        this.stopForeground(removeNotification);
    }

    public final void setPlaylist(@NonNull Playlist playlist) {
        this.setPlaylist(playlist, 0, false);
    }

    public final void setPlaylist(@NonNull Playlist playlist, boolean play) {
        this.setPlaylist(playlist, 0, play);
    }

    @Override
    public void insertMusicItem(int position, @NonNull MusicItem musicItem) throws IllegalArgumentException {
        if (position < 0) {
            throw new IllegalArgumentException("position must >= 0.");
        }
        Preconditions.checkNotNull((Object)musicItem);
        this.mPlayer.insertMusicItem(position, musicItem);
    }

    @Override
    public void appendMusicItem(@NonNull MusicItem musicItem) {
        Preconditions.checkNotNull((Object)musicItem);
        this.mPlayer.appendMusicItem(musicItem);
    }

    @Override
    public void moveMusicItem(int fromPosition, int toPosition) throws IllegalArgumentException {
        if (fromPosition < 0) {
            throw new IllegalArgumentException("fromPosition must >= 0.");
        }
        if (toPosition < 0) {
            throw new IllegalArgumentException("toPosition must >= 0.");
        }
        this.mPlayer.moveMusicItem(fromPosition, toPosition);
    }

    @Override
    public void removeMusicItem(@NonNull MusicItem musicItem) {
        Preconditions.checkNotNull((Object)musicItem);
        this.mPlayer.removeMusicItem(musicItem);
    }

    @Override
    public void removeMusicItem(int position) {
        this.mPlayer.removeMusicItem(position);
    }

    @Override
    public void setNextPlay(@NonNull MusicItem musicItem) {
        Preconditions.checkNotNull((Object)musicItem);
        this.mPlayer.setNextPlay(musicItem);
    }

    @Override
    public final void setPlaylist(@NonNull Playlist playlist, int position, boolean play) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)playlist);
        if (position < 0) {
            throw new IllegalArgumentException("position must >= 0.");
        }
        this.mPlayer.setPlaylist(playlist, position, play);
    }

    private void updateNotification() {
        if (this.noNotificationView()) {
            return;
        }
        if (this.getPlayingMusicItem() == null) {
            this.stopForegroundEx(true);
            return;
        }
        this.mNotificationManager.notify(this.mNotificationView.getNotificationId(), this.mNotificationView.createNotification());
    }

    @Deprecated
    protected boolean isCached(MusicItem musicItem, SoundQuality soundQuality) {
        return false;
    }

    protected void isCached(@NonNull MusicItem musicItem, @NonNull SoundQuality soundQuality, @NonNull AsyncResult<Boolean> result) {
        result.onSuccess(this.isCached(musicItem, soundQuality));
    }

    @NonNull
    protected MusicPlayer onCreateMusicPlayer(@NonNull Context context, @NonNull MusicItem musicItem, @NonNull Uri uri) {
        return new MediaMusicPlayer(context, uri);
    }

    @Nullable
    protected AudioManager.OnAudioFocusChangeListener onCreateAudioFocusChangeListener() {
        return null;
    }

    @Deprecated
    protected Uri onRetrieveMusicItemUri(@NonNull MusicItem musicItem, @NonNull SoundQuality soundQuality) throws Exception {
        return Uri.parse((String)musicItem.getUri());
    }

    protected void onRetrieveMusicItemUri(@NonNull MusicItem musicItem, @NonNull SoundQuality soundQuality, @NonNull AsyncResult<Uri> result) {
        block2: {
            try {
                result.onSuccess(this.onRetrieveMusicItemUri(musicItem, soundQuality));
            }
            catch (Exception e) {
                if (result.isCancelled()) break block2;
                result.onError(e);
            }
        }
    }

    protected void onPrepareMusicItem(@NonNull MusicItem musicItem, @NonNull SoundQuality soundQuality, @NonNull AsyncResult<MusicItem> result) {
        result.onSuccess(musicItem);
    }

    @NonNull
    public final Player getPlayer() {
        return this.mPlayer;
    }

    private void onPlayingMusicItemChanged(@Nullable MusicItem musicItem) {
        if (this.mNotificationView != null && musicItem != null) {
            this.mNotificationView.setPlayingMusicItem(musicItem);
        }
        this.updateNotificationView();
        if (this.mHistoryRecorder != null && musicItem != null) {
            this.mHistoryRecorder.recordHistory(musicItem);
        }
    }

    protected boolean onMediaButtonEvent(Intent mediaButtonEvent) {
        return this.mHeadsetHookHelper.handleMediaButton(mediaButtonEvent);
    }

    protected void onCustomAction(String action, Bundle extras) {
        if (CUSTOM_ACTION_SHUTDOWN.equals(action)) {
            this.shutdown();
            return;
        }
        if (this.mCustomActionDispatcher.dispatch(action, extras)) {
            return;
        }
        this.handleCustomAction(action, extras);
    }

    @Override
    @NonNull
    public String getPlaylistName() {
        return this.mPlaylistManager.getPlaylistName();
    }

    @Override
    public int getPlaylistSize() {
        return this.mPlaylistManager.getPlaylistSize();
    }

    @Override
    @NonNull
    public String getPlaylistToken() {
        return this.mPlaylistManager.getPlaylistToken();
    }

    @Override
    public boolean isPlaylistEditable() {
        return this.mPlaylistManager.isPlaylistEditable();
    }

    @Override
    public void getPlaylist(@NonNull PlaylistManager.Callback callback) {
        Preconditions.checkNotNull((Object)callback);
        this.mPlaylistManager.getPlaylist(callback);
    }

    @Override
    public long getLastModified() {
        return this.mPlaylistManager.getLastModified();
    }

    @Override
    public void startSleepTimer(long time, @NonNull SleepTimer.TimeoutAction action) throws IllegalArgumentException {
        this.mSleepTimer.startSleepTimer(time, action);
    }

    @Override
    public void cancelSleepTimer() {
        this.mSleepTimer.cancelSleepTimer();
    }

    @Override
    public void setWaitPlayComplete(boolean waitPlayComplete) {
        this.mSleepTimer.setWaitPlayComplete(waitPlayComplete);
    }

    private void notifyPlayModeChanged(@NonNull PlayMode playMode) {
        if (this.mNotificationView != null) {
            this.mNotificationView.onPlayModeChanged(playMode);
        }
    }

    public final boolean isPreparing() {
        return this.mPlayer.isPreparing();
    }

    public final boolean isPrepared() {
        return this.mPlayer.isPrepared();
    }

    private static class KeepAliveConnection
    implements ServiceConnection {
        private KeepAliveConnection() {
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
        }

        public void onServiceDisconnected(ComponentName name) {
        }
    }

    public static interface CustomAction {
        public void doAction(@NonNull Player var1, @Nullable Bundle var2);
    }

    public static class MediaNotificationView
    extends NotificationView {
        private static final String ACTION_SKIP_TO_PREVIOUS = "__skip_to_previous";
        private static final String ACTION_PLAY_PAUSE = "__play_pause";
        private static final String ACTION_SKIP_TO_NEXT = "__skip_to_next";
        private PendingIntent mSkipToPrevious;
        private PendingIntent mPlayPause;
        private PendingIntent mSkipToNext;
        private boolean mMIUIInterceptUpdate = Util.isMIUI13();

        @Override
        protected void onInit(Context context) {
            this.initAllPendingIntent();
        }

        private void initAllPendingIntent() {
            this.mSkipToPrevious = this.buildCustomAction(ACTION_SKIP_TO_PREVIOUS, new CustomAction(){

                @Override
                public void doAction(@NonNull Player player, @Nullable Bundle extras) {
                    player.skipToPrevious();
                }
            });
            this.mPlayPause = this.buildCustomAction(ACTION_PLAY_PAUSE, new CustomAction(){

                @Override
                public void doAction(@NonNull Player player, @Nullable Bundle extras) {
                    player.playPause();
                }
            });
            this.mSkipToNext = this.buildCustomAction(ACTION_SKIP_TO_NEXT, new CustomAction(){

                @Override
                public void doAction(@NonNull Player player, @Nullable Bundle extras) {
                    player.skipToNext();
                }
            });
        }

        public final PendingIntent doSkipToPrevious() {
            return this.mSkipToPrevious;
        }

        public final PendingIntent doPlayPause() {
            return this.mPlayPause;
        }

        public final PendingIntent doSkipToNext() {
            return this.mSkipToNext;
        }

        @Override
        protected boolean interceptUpdateNotification() {
            if (Util.isMIUI13()) {
                if (this.isIconExpire()) {
                    this.reloadIcon();
                }
                return this.mMIUIInterceptUpdate;
            }
            return false;
        }

        @Override
        protected void onPlayingMusicItemChanged(@NonNull MusicItem musicItem) {
            super.onPlayingMusicItemChanged(musicItem);
            this.mMIUIInterceptUpdate = true;
        }

        @Override
        protected void onIconLoaded() {
            this.mMIUIInterceptUpdate = false;
        }

        @Override
        @NonNull
        public Notification onCreateNotification() {
            NotificationCompat.MediaStyle mediaStyle = new NotificationCompat.MediaStyle().setMediaSession(this.getMediaSession().getSessionToken());
            this.onBuildMediaStyle(mediaStyle);
            NotificationCompat.Builder builder = new NotificationCompat.Builder(this.getContext(), "player").setSmallIcon(this.getSmallIconId()).setLargeIcon(this.getIcon()).setContentTitle((CharSequence)MusicItemUtil.getTitle(this.getContext(), this.getPlayingMusicItem())).setContentText(this.getContentText(MusicItemUtil.getArtist(this.getContext(), this.getPlayingMusicItem()))).setVisibility(1).setPriority(-1).setShowWhen(false).setAutoCancel(false).setStyle((NotificationCompat.Style)mediaStyle);
            this.onBuildNotification(builder);
            return builder.build();
        }

        @Override
        public int getNotificationId() {
            return 1024;
        }

        @DrawableRes
        public int getSmallIconId() {
            return R.mipmap.snow_ic_notif_small_icon;
        }

        protected void onBuildMediaStyle(NotificationCompat.MediaStyle mediaStyle) {
            mediaStyle.setShowActionsInCompactView(new int[]{1, 2});
        }

        protected void onBuildNotification(NotificationCompat.Builder builder) {
            builder.addAction(R.mipmap.snow_ic_notif_skip_to_previous, (CharSequence)"skip_to_previous", this.doSkipToPrevious());
            if (this.isPlayingState()) {
                builder.addAction(R.mipmap.snow_ic_notif_pause, (CharSequence)"pause", this.doPlayPause());
            } else {
                builder.addAction(R.mipmap.snow_ic_notif_play, (CharSequence)"play", this.doPlayPause());
            }
            builder.addAction(R.mipmap.snow_ic_notif_skip_to_next, (CharSequence)"skip_to_next", this.doSkipToNext());
        }
    }

    public static abstract class NotificationView {
        public static final String CHANNEL_ID = "player";
        private PlayerService mPlayerService;
        private MusicItem mPlayingMusicItem;
        private boolean mExpire;
        private boolean mIconExpire;
        private Bitmap mDefaultIcon;
        private int mIconWidth;
        private int mIconHeight;
        private Bitmap mIcon;
        private BetterIconLoader mBetterIconLoader;
        private Disposable mIconLoaderDisposable;
        private boolean mReleased;
        private int mPendingIntentRequestCode;

        void init(PlayerService playerService) {
            this.mPlayerService = playerService;
            this.mPlayingMusicItem = new MusicItem();
            this.mIcon = this.mDefaultIcon = this.loadDefaultIcon();
            this.mBetterIconLoader = this.onCreateBetterIconLoader((Context)playerService);
            Preconditions.checkNotNull((Object)this.mBetterIconLoader);
            this.setIconSize(playerService.getResources().getDimensionPixelSize(R.dimen.snow_notif_icon_size_big));
            this.onInit((Context)this.mPlayerService);
        }

        @NonNull
        private Bitmap loadDefaultIcon() {
            Context context = this.getContext();
            BitmapDrawable drawable = (BitmapDrawable)ResourcesCompat.getDrawable((Resources)context.getResources(), (int)R.mipmap.snow_notif_default_icon, (Resources.Theme)context.getTheme());
            if (drawable == null) {
                throw new NullPointerException();
            }
            return drawable.getBitmap();
        }

        protected boolean isIconExpire() {
            return this.mIconExpire;
        }

        protected void reloadIcon() {
            this.disposeLastLoading();
            this.mIconLoaderDisposable = Single.create((SingleOnSubscribe)new SingleOnSubscribe<Bitmap>(){

                public void subscribe(final @NonNull SingleEmitter<Bitmap> emitter) {
                    mBetterIconLoader.loadIcon(this.getPlayingMusicItem(), mIconWidth, mIconHeight, new AsyncResult<Bitmap>(){

                        @Override
                        public void onSuccess(@NonNull Bitmap bitmap) {
                            emitter.onSuccess((Object)bitmap);
                        }

                        @Override
                        public void onError(@NonNull Throwable throwable) {
                            throwable.printStackTrace();
                            emitter.onSuccess((Object)this.getDefaultIcon());
                        }

                        @Override
                        public boolean isCancelled() {
                            return emitter.isDisposed();
                        }

                        @Override
                        public synchronized void setOnCancelListener(@Nullable AsyncResult.OnCancelListener listener) {
                            super.setOnCancelListener(listener);
                            emitter.setCancellable(new Cancellable(){

                                public void cancel() {
                                    this.notifyCancelled();
                                }
                            });
                        }
                    });
                }
            }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Bitmap>(){

                public void accept(Bitmap bitmap) {
                    this.setIcon(bitmap);
                }
            });
        }

        private void disposeLastLoading() {
            if (this.mIconLoaderDisposable != null && !this.mIconLoaderDisposable.isDisposed()) {
                this.mIconLoaderDisposable.dispose();
            }
        }

        protected void onInit(Context context) {
        }

        @Deprecated
        @NonNull
        protected IconLoader onCreateIconLoader(@NonNull Context context) {
            return new IconLoaderImp(context, this.getDefaultIcon());
        }

        @NonNull
        protected BetterIconLoader onCreateBetterIconLoader(@NonNull Context context) {
            return new IconLoaderCompat(this.onCreateIconLoader(context));
        }

        protected void onPlayModeChanged(@NonNull PlayMode playMode) {
        }

        protected void onRelease() {
        }

        protected boolean interceptUpdateNotification() {
            return false;
        }

        protected void onPlayingMusicItemChanged(@NonNull MusicItem musicItem) {
        }

        protected void onIconLoaded() {
        }

        public final PendingIntent buildCustomAction(String actionName, CustomAction customAction) {
            this.addCustomAction(actionName, customAction);
            ++this.mPendingIntentRequestCode;
            Intent intent = this.mPlayerService.buildCustomActionIntent(actionName);
            int flags = Build.VERSION.SDK_INT >= 23 ? 0xC000000 : 0x8000000;
            return PendingIntent.getBroadcast((Context)this.getContext(), (int)this.mPendingIntentRequestCode, (Intent)intent, (int)flags);
        }

        @NonNull
        public abstract Notification onCreateNotification();

        public abstract int getNotificationId();

        public final void shutdown() {
            this.mPlayerService.shutdown();
        }

        public final Bitmap getIcon() {
            return this.mIcon;
        }

        public final void setIcon(@NonNull Bitmap icon) {
            this.mIconExpire = false;
            this.mIcon = icon;
            this.onIconLoaded();
            this.invalidate();
        }

        public final void setIconSize(int size) {
            this.setIconSize(size, size);
        }

        public final void setIconSize(int width, int height) {
            this.mIconWidth = Math.max(0, width);
            this.mIconHeight = Math.max(0, height);
        }

        public final void setDefaultIcon(@NonNull Bitmap bitmap) {
            Preconditions.checkNotNull((Object)bitmap);
            this.mDefaultIcon = bitmap;
            if (this.mBetterIconLoader instanceof IconLoaderCompat) {
                IconLoaderCompat iconLoaderCompat = (IconLoaderCompat)this.mBetterIconLoader;
                iconLoaderCompat.setDefaultIcon(bitmap);
            }
        }

        @NonNull
        public final Bitmap getDefaultIcon() {
            return this.mDefaultIcon;
        }

        public final CharSequence getContentText(String contentText) {
            String text = contentText;
            if (this.isError()) {
                text = this.getErrorMessage();
                Resources res = this.getContext().getResources();
                SpannableString colorText = new SpannableString((CharSequence)text);
                colorText.setSpan((Object)new ForegroundColorSpan(res.getColor(17170455)), 0, text.length(), 17);
                return colorText;
            }
            return text;
        }

        public final Context getContext() {
            return this.mPlayerService;
        }

        public final String getPackageName() {
            return this.getContext().getPackageName();
        }

        public final PlayMode getPlayMode() {
            return this.mPlayerService.getPlayMode();
        }

        @Nullable
        public final Bundle getPlaylistExtra() {
            return this.mPlayerService.getPlaylistExtra();
        }

        public final void addCustomAction(@NonNull String action, @NonNull CustomAction customAction) {
            this.mPlayerService.addCustomAction(action, customAction);
        }

        public final boolean isPreparing() {
            return this.mPlayerService.isPreparing();
        }

        public final boolean isPrepared() {
            return this.mPlayerService.isPrepared();
        }

        public final boolean isStalled() {
            return this.mPlayerService.isStalled();
        }

        @NonNull
        public final PlaybackState getPlaybackState() {
            return this.mPlayerService.getPlaybackState();
        }

        public final boolean isPlayingState() {
            return this.getPlaybackState() == PlaybackState.PLAYING;
        }

        public final boolean isError() {
            return this.getPlaybackState() == PlaybackState.ERROR;
        }

        @NonNull
        public final String getErrorMessage() {
            return this.mPlayerService.getErrorMessage();
        }

        public final boolean isReleased() {
            return this.mReleased;
        }

        @NonNull
        public final MusicItem getPlayingMusicItem() {
            return this.mPlayingMusicItem;
        }

        public final MediaSessionCompat getMediaSession() {
            return this.mPlayerService.getMediaSession();
        }

        public final boolean isExpire() {
            return this.mExpire;
        }

        public final void invalidate() {
            if (this.mReleased) {
                return;
            }
            this.mPlayerService.updateNotificationView();
        }

        @NonNull
        Notification createNotification() {
            if (this.mExpire) {
                this.reloadIcon();
            }
            this.mExpire = false;
            return this.onCreateNotification();
        }

        void setPlayingMusicItem(@NonNull MusicItem musicItem) {
            Preconditions.checkNotNull((Object)musicItem);
            if (this.mPlayingMusicItem.equals(musicItem)) {
                return;
            }
            this.mPlayingMusicItem = musicItem;
            this.mExpire = true;
            this.mIconExpire = true;
            this.onPlayingMusicItemChanged(this.mPlayingMusicItem);
        }

        void release() {
            this.onRelease();
            this.mReleased = true;
            this.disposeLastLoading();
        }

        private static class IconLoaderCompat
        implements BetterIconLoader {
            private IconLoader mIconLoader;

            IconLoaderCompat(IconLoader iconLoader) {
                this.mIconLoader = iconLoader;
            }

            @Override
            public void loadIcon(@NonNull MusicItem musicItem, int width, int height, final @NonNull AsyncResult<Bitmap> result) {
                this.mIconLoader.setWidth(width);
                this.mIconLoader.setHeight(height);
                this.mIconLoader.loadIcon(musicItem, new IconLoader.Callback(){

                    @Override
                    public void onIconLoaded(Bitmap bitmap) {
                        result.onSuccess(bitmap);
                    }
                });
                result.setOnCancelListener(new AsyncResult.OnCancelListener(){

                    @Override
                    public void onCancelled() {
                        mIconLoader.cancel();
                    }
                });
            }

            void setDefaultIcon(Bitmap defaultIcon) {
                this.mIconLoader.setDefaultIcon(defaultIcon);
            }
        }

        private static class IconLoaderImp
        extends IconLoader {
            private Context mContext;
            private Disposable mLoadIconDisposable;
            private FutureTarget<Bitmap> mFutureTarget;

            IconLoaderImp(Context context, Bitmap defaultIcon) {
                super(defaultIcon);
                this.mContext = context;
            }

            @Override
            public void loadIcon(final @NonNull MusicItem musicItem, final @NonNull IconLoader.Callback callback) {
                this.cancelLastLoading();
                this.mLoadIconDisposable = Single.create((SingleOnSubscribe)new SingleOnSubscribe<Bitmap>(){

                    public void subscribe(@NonNull SingleEmitter<Bitmap> emitter) {
                        Bitmap bitmap = this.loadIconFromInternet(musicItem);
                        if (emitter.isDisposed()) {
                            return;
                        }
                        if (bitmap == null) {
                            bitmap = this.loadEmbeddedPicture(musicItem);
                        }
                        if (emitter.isDisposed()) {
                            return;
                        }
                        if (bitmap == null) {
                            bitmap = this.getDefaultIcon();
                        }
                        if (emitter.isDisposed()) {
                            return;
                        }
                        emitter.onSuccess((Object)bitmap);
                    }
                }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Bitmap>(){

                    public void accept(Bitmap bitmap) {
                        callback.onIconLoaded(bitmap);
                    }
                });
            }

            @Override
            public void cancel() {
                this.cancelLastLoading();
            }

            private Bitmap loadIconFromInternet(MusicItem musicItem) {
                this.mFutureTarget = Glide.with((Context)this.mContext).asBitmap().load(musicItem.getIconUri()).submit(this.getWidth(), this.getHeight());
                try {
                    return (Bitmap)this.mFutureTarget.get();
                }
                catch (InterruptedException | CancellationException | ExecutionException e) {
                    return null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Bitmap loadEmbeddedPicture(MusicItem musicItem) {
                if (this.notLocaleMusic(musicItem)) {
                    return null;
                }
                MediaMetadataRetriever retriever = new MediaMetadataRetriever();
                try {
                    retriever.setDataSource(this.mContext, Uri.parse((String)musicItem.getUri()));
                    byte[] pictureData = retriever.getEmbeddedPicture();
                    Bitmap bitmap = (Bitmap)Glide.with((Context)this.mContext).asBitmap().load(pictureData).submit(this.getWidth(), this.getHeight()).get();
                    return bitmap;
                }
                catch (IllegalArgumentException | InterruptedException | ExecutionException e) {
                    Bitmap bitmap = null;
                    return bitmap;
                }
                finally {
                    retriever.release();
                }
            }

            private boolean notLocaleMusic(MusicItem musicItem) {
                String stringUri = musicItem.getUri();
                String scheme = Uri.parse((String)stringUri).getScheme();
                return "http".equalsIgnoreCase(scheme) | "https".equalsIgnoreCase(scheme);
            }

            private void cancelLastLoading() {
                if (this.mLoadIconDisposable != null && !this.mLoadIconDisposable.isDisposed()) {
                    this.mLoadIconDisposable.dispose();
                }
                if (this.mFutureTarget != null && !this.mFutureTarget.isDone()) {
                    this.mFutureTarget.cancel(true);
                }
            }
        }

        public static interface BetterIconLoader {
            public void loadIcon(@NonNull MusicItem var1, int var2, int var3, @NonNull AsyncResult<Bitmap> var4);
        }

        @Deprecated
        public static abstract class IconLoader {
            private int mWidth;
            private int mHeight;
            private Bitmap mDefaultIcon;

            public IconLoader(@NonNull Bitmap defaultIcon) {
                Preconditions.checkNotNull((Object)defaultIcon);
                this.mDefaultIcon = defaultIcon;
            }

            public abstract void loadIcon(@NonNull MusicItem var1, @NonNull Callback var2);

            public abstract void cancel();

            public void setWidth(int width) {
                this.mWidth = width;
            }

            public int getWidth() {
                return this.mWidth;
            }

            public void setHeight(int height) {
                this.mHeight = height;
            }

            public int getHeight() {
                return this.mHeight;
            }

            public void setDefaultIcon(@NonNull Bitmap bitmap) {
                Preconditions.checkNotNull((Object)bitmap);
                this.mDefaultIcon = bitmap;
            }

            @NonNull
            public Bitmap getDefaultIcon() {
                return this.mDefaultIcon;
            }

            @Deprecated
            public static interface Callback {
                public void onIconLoaded(Bitmap var1);
            }
        }
    }

    public static class MediaSessionCallback
    extends MediaSessionCompat.Callback {
        private final PlayerService mPlayerService;
        private final Player mPlayer;

        public MediaSessionCallback(@NonNull PlayerService playerService) {
            Preconditions.checkNotNull((Object)playerService);
            this.mPlayerService = playerService;
            this.mPlayer = this.mPlayerService.getPlayer();
        }

        @NonNull
        public PlayerService getPlayerService() {
            return this.mPlayerService;
        }

        public MediaSessionCompat getMediaSession() {
            return this.mPlayerService.getMediaSession();
        }

        public Player getPlayer() {
            return this.mPlayer;
        }

        public boolean onMediaButtonEvent(Intent mediaButtonEvent) {
            if (this.mPlayerService.onMediaButtonEvent(mediaButtonEvent)) {
                return true;
            }
            return super.onMediaButtonEvent(mediaButtonEvent);
        }

        public void onCustomAction(String action, Bundle extras) {
            this.mPlayerService.onCustomAction(action, extras);
        }

        public void onPlay() {
            this.mPlayer.play();
        }

        public void onSkipToQueueItem(long id) {
            this.mPlayer.skipToPosition((int)id);
        }

        public void onPause() {
            this.mPlayer.pause();
        }

        public void onSkipToNext() {
            this.mPlayer.skipToNext();
        }

        public void onSkipToPrevious() {
            this.mPlayer.skipToPrevious();
        }

        public void onFastForward() {
            this.mPlayer.fastForward();
        }

        public void onRewind() {
            this.mPlayer.rewind();
        }

        public void onStop() {
            this.mPlayer.stop();
        }

        public void onSeekTo(long pos) {
            this.mPlayer.seekTo((int)pos);
        }

        public void onSetRepeatMode(int repeatMode) {
            if (repeatMode == 1) {
                this.mPlayer.setPlayMode(PlayMode.LOOP);
                return;
            }
            this.mPlayer.setPlayMode(PlayMode.PLAYLIST_LOOP);
        }

        public void onSetShuffleMode(int shuffleMode) {
            if (shuffleMode == 0 || shuffleMode == -1) {
                this.mPlayer.setPlayMode(PlayMode.PLAYLIST_LOOP);
                return;
            }
            this.mPlayer.setPlayMode(PlayMode.SHUFFLE);
        }
    }

    private class PlayerImp
    extends AbstractPlayer {
        public PlayerImp(@NonNull Context context, @NonNull PlayerConfig playerConfig, @NonNull PlayerState playlistState, @NonNull PlaylistManagerImp playlistManager, @NonNull Class<? extends PlayerService> playerService2, AbstractPlayer.OnStateChangeListener listener) {
            super(context, playerConfig, playlistState, playlistManager, playerService2, listener);
        }

        @Override
        protected void isCached(@NonNull MusicItem musicItem, @NonNull SoundQuality soundQuality, @NonNull AsyncResult<Boolean> result) {
            PlayerService.this.isCached(musicItem, soundQuality, result);
        }

        @Override
        @NonNull
        protected MusicPlayer onCreateMusicPlayer(@NonNull Context context, @NonNull MusicItem musicItem, @NonNull Uri uri) {
            return PlayerService.this.onCreateMusicPlayer(context, musicItem, uri);
        }

        @Override
        protected void prepareMusicItem(@NonNull MusicItem musicItem, @NonNull SoundQuality soundQuality, @NonNull AsyncResult<MusicItem> result) {
            PlayerService.this.onPrepareMusicItem(musicItem, soundQuality, result);
        }

        @Override
        @Nullable
        protected AudioManager.OnAudioFocusChangeListener onCreateAudioFocusChangeListener() {
            return PlayerService.this.onCreateAudioFocusChangeListener();
        }

        @Override
        protected void retrieveMusicItemUri(@NonNull MusicItem musicItem, @NonNull SoundQuality soundQuality, @NonNull AsyncResult<Uri> result) throws Exception {
            PlayerService.this.onRetrieveMusicItemUri(musicItem, soundQuality, result);
        }
    }
}

