/*
 * Decompiled with CFR 0.152.
 */
package snow.player;

import android.content.Context;
import android.media.AudioManager;
import android.net.Uri;
import android.net.wifi.WifiManager;
import android.os.Bundle;
import android.os.PowerManager;
import android.os.SystemClock;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.google.common.base.Preconditions;
import io.reactivex.Observable;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import io.reactivex.SingleObserver;
import io.reactivex.SingleOnSubscribe;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Cancellable;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import media.helper.AudioFocusHelper;
import media.helper.BecomeNoiseHelper;
import snow.player.PlayMode;
import snow.player.PlaybackState;
import snow.player.Player;
import snow.player.PlayerConfig;
import snow.player.PlayerService;
import snow.player.PlayerState;
import snow.player.PlayerStateHelper;
import snow.player.PlayerStateListener;
import snow.player.PlaylistManagerImp;
import snow.player.ServicePlayerStateHelper;
import snow.player.SleepTimerImp;
import snow.player.SoundQuality;
import snow.player.audio.ErrorCode;
import snow.player.audio.MusicItem;
import snow.player.audio.MusicPlayer;
import snow.player.effect.AudioEffectManager;
import snow.player.helper.NetworkHelper;
import snow.player.helper.PhoneCallStateHelper;
import snow.player.playlist.Playlist;
import snow.player.playlist.PlaylistEditor;
import snow.player.playlist.PlaylistManager;
import snow.player.util.AsyncResult;

abstract class AbstractPlayer
implements Player,
PlaylistEditor {
    private static final String TAG = "AbstractPlayer";
    private static final int FORWARD_STEP = 15000;
    private final Context mApplicationContext;
    private final PlayerConfig mPlayerConfig;
    private final PlayerState mPlayerState;
    private final PlayerStateHelper mPlayerStateHelper;
    @Nullable
    private PlayerStateListener mPlayerStateListener;
    private MusicPlayer.OnPreparedListener mPreparedListener;
    private MusicPlayer.OnCompletionListener mCompletionListener;
    private MusicPlayer.OnRepeatListener mRepeatListener;
    private MusicPlayer.OnSeekCompleteListener mSeekCompleteListener;
    private MusicPlayer.OnStalledListener mStalledListener;
    private MusicPlayer.OnBufferingUpdateListener mBufferingUpdateListener;
    private MusicPlayer.OnErrorListener mErrorListener;
    private AudioFocusHelper mAudioFocusHelper;
    private PhoneCallStateHelper mPhoneCallStateHelper;
    private BecomeNoiseHelper mBecomeNoiseHelper;
    private NetworkHelper mNetworkHelper;
    @Nullable
    private MusicPlayer mMusicPlayer;
    private boolean mLoadingPlaylist;
    private boolean mPlayOnPrepared;
    private boolean mPlayOnSeekComplete;
    private Runnable mPreparedAction;
    private Runnable mSeekCompleteAction;
    private Runnable mPlaylistLoadedAction;
    private final PlaylistManagerImp mPlaylistManager;
    private Playlist mPlaylist;
    private Random mRandom;
    private Disposable mPrepareMusicItemDisposable;
    private Disposable mRetrieveUriDisposable;
    private boolean mReleased;
    private Disposable mRecordProgressDisposable;
    private Disposable mCheckCachedDisposable;
    private MediaSessionCompat mMediaSession;
    private PlaybackStateCompat.Builder mPlaybackStateBuilder;
    private PlaybackStateCompat.Builder mForbidSeekPlaybackStateBuilder;
    private MediaMetadataCompat.Builder mMediaMetadataBuilder;
    private PowerManager.WakeLock mWakeLock;
    private WifiManager.WifiLock mWifiLock;
    private boolean mConfirmNextPlay;
    private boolean mResumePlay;
    private boolean mInitialized;
    private OnInitializedListener mOnInitializedListener;
    private final OnStateChangeListener mOnStateChangeListener;
    private SleepTimerImp mSleepTimer;
    @Nullable
    private AudioEffectManager mAudioEffectManager;

    public AbstractPlayer(@NonNull Context context, @NonNull PlayerConfig playerConfig, @NonNull PlayerState playerState, @NonNull PlaylistManagerImp playlistManager, @NonNull Class<? extends PlayerService> playerService, @NonNull OnStateChangeListener listener) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)playerConfig);
        Preconditions.checkNotNull((Object)playerState);
        Preconditions.checkNotNull((Object)playlistManager);
        Preconditions.checkNotNull(playerService);
        Preconditions.checkNotNull((Object)listener);
        this.mApplicationContext = context.getApplicationContext();
        this.mPlayerConfig = playerConfig;
        this.mPlayerState = playerState;
        this.mPlayerStateHelper = new ServicePlayerStateHelper(this.mPlayerState, this.mApplicationContext, playerService);
        this.mPlaylistManager = playlistManager;
        this.mOnStateChangeListener = listener;
        this.initAllListener();
        this.initAllHelper();
        this.initWakeLock();
        this.mNetworkHelper.subscribeNetworkState();
    }

    void setAudioEffectManager(@Nullable AudioEffectManager audioEffectManager) {
        this.mAudioEffectManager = audioEffectManager;
    }

    public void initialize(@NonNull OnInitializedListener listener) {
        this.mOnInitializedListener = listener;
        this.reloadPlaylist();
    }

    protected abstract void isCached(@NonNull MusicItem var1, @NonNull SoundQuality var2, @NonNull AsyncResult<Boolean> var3);

    @NonNull
    protected abstract MusicPlayer onCreateMusicPlayer(@NonNull Context var1, @NonNull MusicItem var2, @NonNull Uri var3);

    protected abstract void prepareMusicItem(@NonNull MusicItem var1, @NonNull SoundQuality var2, @NonNull AsyncResult<MusicItem> var3);

    protected abstract void retrieveMusicItemUri(@NonNull MusicItem var1, @NonNull SoundQuality var2, @NonNull AsyncResult<Uri> var3) throws Exception;

    @Nullable
    protected abstract AudioManager.OnAudioFocusChangeListener onCreateAudioFocusChangeListener();

    public void release() {
        this.mReleased = true;
        this.disposePrepareMusicItem();
        this.disposeRetrieveUri();
        this.releaseMusicPlayer();
        this.releaseWakeLock();
        this.mAudioFocusHelper.abandonAudioFocus();
        this.mPhoneCallStateHelper.unregisterCallStateListener();
        this.mBecomeNoiseHelper.unregisterBecomeNoiseReceiver();
        this.mNetworkHelper.unsubscribeNetworkState();
        this.mAudioFocusHelper = null;
        this.mBecomeNoiseHelper = null;
        this.mNetworkHelper = null;
        this.mPreparedAction = null;
        this.mSeekCompleteAction = null;
        this.mPlaylistLoadedAction = null;
    }

    @Nullable
    protected final MusicItem getMusicItem() {
        return this.mPlayerState.getMusicItem();
    }

    private void prepareMusicPlayer(boolean playOnPrepared, @Nullable Runnable preparedAction) {
        this.releaseMusicPlayer();
        this.disposeRetrieveUri();
        MusicItem musicItem = this.mPlayerState.getMusicItem();
        if (musicItem == null) {
            return;
        }
        if (this.mPlayerConfig.isOnlyWifiNetwork() && !this.isWiFiNetwork()) {
            this.notifyError(1, ErrorCode.getErrorMessage(this.mApplicationContext, 1));
            return;
        }
        this.mPlayOnPrepared = playOnPrepared;
        this.mRetrieveUriDisposable = this.getMusicItemUri(musicItem, this.mPlayerConfig.getSoundQuality()).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(this.prepareMusicPlayer(musicItem, preparedAction), this.notifyGetUrlFailed());
    }

    private void disposeRetrieveUri() {
        if (this.mRetrieveUriDisposable != null && !this.mRetrieveUriDisposable.isDisposed()) {
            this.mRetrieveUriDisposable.dispose();
        }
    }

    private Single<Uri> getMusicItemUri(final @NonNull MusicItem musicItem, final @NonNull SoundQuality soundQuality) {
        return Single.create((SingleOnSubscribe)new SingleOnSubscribe<Uri>(){

            public void subscribe(final @NonNull SingleEmitter<Uri> emitter) throws Exception {
                AbstractPlayer.this.retrieveMusicItemUri(musicItem, soundQuality, new AsyncResult<Uri>(){

                    @Override
                    public void onSuccess(@NonNull Uri uri) {
                        emitter.onSuccess((Object)uri);
                    }

                    @Override
                    public void onError(@NonNull Throwable throwable) {
                        emitter.onError(throwable);
                    }

                    @Override
                    public boolean isCancelled() {
                        return emitter.isDisposed();
                    }

                    @Override
                    public synchronized void setOnCancelListener(@Nullable AsyncResult.OnCancelListener listener) {
                        super.setOnCancelListener(listener);
                        emitter.setCancellable(new Cancellable(){

                            public void cancel() {
                                this.notifyCancelled();
                            }
                        });
                    }
                });
            }
        });
    }

    private Consumer<Uri> prepareMusicPlayer(final @NonNull MusicItem musicItem, final @Nullable Runnable preparedAction) {
        return new Consumer<Uri>(){

            public void accept(Uri uri) {
                AbstractPlayer.this.mMusicPlayer = AbstractPlayer.this.onCreateMusicPlayer(AbstractPlayer.this.mApplicationContext, musicItem, uri);
                AbstractPlayer.this.attachListeners(AbstractPlayer.this.mMusicPlayer);
                AbstractPlayer.this.mPreparedAction = preparedAction;
                AbstractPlayer.this.notifyPreparing();
                try {
                    if (!AbstractPlayer.this.mMusicPlayer.isInvalid()) {
                        AbstractPlayer.this.mMusicPlayer.prepare();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    AbstractPlayer.this.notifyError(5, ErrorCode.getErrorMessage(AbstractPlayer.this.mApplicationContext, 5));
                }
            }
        };
    }

    private Consumer<Throwable> notifyGetUrlFailed() {
        return new Consumer<Throwable>(){

            public void accept(Throwable throwable) {
                throwable.printStackTrace();
                AbstractPlayer.this.notifyError(6, ErrorCode.getErrorMessage(AbstractPlayer.this.mApplicationContext, 6));
            }
        };
    }

    private boolean isWiFiNetwork() {
        return this.mNetworkHelper.isWifiNetwork();
    }

    private void initAllListener() {
        this.mPreparedListener = new MusicPlayer.OnPreparedListener(){

            @Override
            public void onPrepared(MusicPlayer mp) {
                if (AbstractPlayer.this.mReleased) {
                    return;
                }
                mp.setLooping(AbstractPlayer.this.isLooping());
                if (AbstractPlayer.this.mPlayerConfig.isAudioEffectEnabled() && AbstractPlayer.this.mAudioEffectManager != null) {
                    AbstractPlayer.this.mAudioEffectManager.attachAudioEffect(mp.getAudioSessionId());
                }
                AbstractPlayer.this.notifyPrepared(mp.getAudioSessionId(), mp.getDuration());
                MusicItem musicItem = AbstractPlayer.this.mPlayerState.getMusicItem();
                assert (musicItem != null);
                if (musicItem.isAutoDuration()) {
                    AbstractPlayer.this.mMediaSession.setMetadata(AbstractPlayer.this.buildMediaMetadata());
                }
                if (!AbstractPlayer.this.mPlayerState.isForbidSeek() && AbstractPlayer.this.mPlayerState.getPlayProgress() > 0) {
                    AbstractPlayer.this.mPlayOnSeekComplete = AbstractPlayer.this.mPlayOnPrepared;
                    AbstractPlayer.this.mPlayOnPrepared = false;
                    AbstractPlayer.this.seekTo(AbstractPlayer.this.mPlayerState.getPlayProgress(), AbstractPlayer.this.mPreparedAction);
                    AbstractPlayer.this.mPreparedAction = null;
                    return;
                }
                if (AbstractPlayer.this.mPlayOnPrepared) {
                    AbstractPlayer.this.mPlayOnPrepared = false;
                    AbstractPlayer.this.play();
                } else if (AbstractPlayer.this.mPreparedAction == null) {
                    AbstractPlayer.this.notifyPaused();
                }
                if (AbstractPlayer.this.mPreparedAction != null) {
                    AbstractPlayer.this.mPreparedAction.run();
                    AbstractPlayer.this.mPreparedAction = null;
                }
            }
        };
        this.mCompletionListener = new MusicPlayer.OnCompletionListener(){

            @Override
            public void onCompletion(MusicPlayer mp) {
                if (AbstractPlayer.this.mPlayerState.getPlayMode() == PlayMode.LOOP) {
                    return;
                }
                if (AbstractPlayer.this.mPlayerState.getPlayMode() == PlayMode.SINGLE_ONCE) {
                    AbstractPlayer.this.notifyPlayOnceComplete();
                    return;
                }
                if (AbstractPlayer.this.getPlaybackState() != PlaybackState.PLAYING) {
                    return;
                }
                if (AbstractPlayer.this.performSleepTimerAction()) {
                    return;
                }
                AbstractPlayer.this.skipToNext();
            }
        };
        this.mRepeatListener = new MusicPlayer.OnRepeatListener(){

            @Override
            public void onRepeat(MusicPlayer mp) {
                if (AbstractPlayer.this.performSleepTimerAction()) {
                    return;
                }
                AbstractPlayer.this.notifyRepeat(SystemClock.elapsedRealtime());
            }
        };
        this.mSeekCompleteListener = new MusicPlayer.OnSeekCompleteListener(){

            @Override
            public void onSeekComplete(MusicPlayer mp) {
                if (AbstractPlayer.this.mReleased) {
                    return;
                }
                AbstractPlayer.this.notifySeekComplete(mp.getProgress(), SystemClock.elapsedRealtime(), mp.isStalled());
                if (AbstractPlayer.this.mPlayOnSeekComplete) {
                    AbstractPlayer.this.mPlayOnSeekComplete = false;
                    AbstractPlayer.this.play();
                }
                if (AbstractPlayer.this.mSeekCompleteAction != null) {
                    AbstractPlayer.this.mSeekCompleteAction.run();
                    AbstractPlayer.this.mSeekCompleteAction = null;
                }
            }
        };
        this.mStalledListener = new MusicPlayer.OnStalledListener(){

            @Override
            public void onStalled(boolean stalled) {
                AbstractPlayer.this.notifyStalled(stalled);
            }
        };
        this.mBufferingUpdateListener = new MusicPlayer.OnBufferingUpdateListener(){

            @Override
            public void onBufferingUpdate(MusicPlayer mp, int buffered, boolean isPercent) {
                AbstractPlayer.this.notifyBufferedChanged(buffered, isPercent);
            }
        };
        this.mErrorListener = new MusicPlayer.OnErrorListener(){

            @Override
            public void onError(MusicPlayer mp, int errorCode) {
                Log.e((String)"MusicPlayer", (String)("errorCode:" + errorCode));
                AbstractPlayer.this.notifyError(errorCode, ErrorCode.getErrorMessage(AbstractPlayer.this.mApplicationContext, errorCode));
            }
        };
    }

    private boolean performSleepTimerAction() {
        if (this.mPlayerState.isWaitPlayComplete() && this.mPlayerState.isSleepTimerStarted() && this.mPlayerState.isSleepTimerTimeout() && !this.mPlayerState.isSleepTimerEnd()) {
            this.releaseMusicPlayer();
            this.mPlayerState.setPlayProgress(0);
            this.mPlayerState.setPlayProgressUpdateTime(SystemClock.elapsedRealtime());
            this.mSleepTimer.performAction();
            return true;
        }
        return false;
    }

    private void initAllHelper() {
        this.initAudioFocusHelper();
        this.mPhoneCallStateHelper = new PhoneCallStateHelper(this.mApplicationContext, new PhoneCallStateHelper.OnStateChangeListener(){
            private boolean mResumePlay;

            @Override
            public void onIDLE() {
                if (this.mResumePlay) {
                    this.mResumePlay = false;
                    AbstractPlayer.this.play();
                }
            }

            @Override
            public void onRinging() {
                if (this.mResumePlay) {
                    return;
                }
                this.mResumePlay = AbstractPlayer.this.isPlayingState();
                AbstractPlayer.this.pause();
            }

            @Override
            public void onOffHook() {
                if (this.mResumePlay) {
                    return;
                }
                this.mResumePlay = AbstractPlayer.this.isPlayingState();
                AbstractPlayer.this.pause();
            }
        });
        this.mBecomeNoiseHelper = new BecomeNoiseHelper(this.mApplicationContext, new BecomeNoiseHelper.OnBecomeNoiseListener(){

            public void onBecomeNoise() {
                AbstractPlayer.this.pause();
            }
        });
        this.mNetworkHelper = NetworkHelper.newInstance(this.mApplicationContext, new NetworkHelper.OnNetworkStateChangeListener(){

            @Override
            public void onNetworkStateChanged(boolean connected, boolean wifiNetwork) {
                if (!AbstractPlayer.this.isPrepared() || !connected) {
                    return;
                }
                AbstractPlayer.this.checkNetworkType(AbstractPlayer.this.mPlayerConfig.isOnlyWifiNetwork(), wifiNetwork);
            }
        });
    }

    private void initAudioFocusHelper() {
        AudioManager.OnAudioFocusChangeListener listener = this.onCreateAudioFocusChangeListener();
        if (listener != null) {
            this.mAudioFocusHelper = new AudioFocusHelper(this.mApplicationContext, listener);
            return;
        }
        this.mAudioFocusHelper = new AudioFocusHelper(this.mApplicationContext, new AudioFocusHelper.OnAudioFocusChangeListener(){

            public void onLoss() {
                AbstractPlayer.this.mResumePlay = false;
                AbstractPlayer.this.pause();
            }

            public void onLossTransient() {
                boolean playing = AbstractPlayer.this.isPlayingState();
                AbstractPlayer.this.pause();
                AbstractPlayer.this.mResumePlay = playing;
            }

            public void onLossTransientCanDuck() {
                AbstractPlayer.this.mResumePlay = AbstractPlayer.this.isMusicPlayerPlaying();
                if (AbstractPlayer.this.isMusicPlayerPlaying()) {
                    assert (AbstractPlayer.this.mMusicPlayer != null);
                    AbstractPlayer.this.mMusicPlayer.quiet();
                }
            }

            public void onGain(boolean lossTransient, boolean lossTransientCanDuck) {
                if (!AbstractPlayer.this.mResumePlay) {
                    return;
                }
                if (lossTransient) {
                    AbstractPlayer.this.play();
                    return;
                }
                if (AbstractPlayer.this.mMusicPlayer != null && lossTransientCanDuck && AbstractPlayer.this.isMusicPlayerPlaying()) {
                    AbstractPlayer.this.mMusicPlayer.dismissQuiet();
                }
            }
        });
    }

    private void notifyPlayOnceComplete() {
        this.cancelRecordProgress();
        this.releaseWakeLock();
        int playProgress = this.mPlayerState.getPlayProgress();
        long updateTime = this.mPlayerState.getPlayProgressUpdateTime();
        if (this.isPrepared()) {
            assert (this.mMusicPlayer != null);
            playProgress = this.mMusicPlayer.getProgress();
            updateTime = SystemClock.elapsedRealtime();
            this.releaseMusicPlayer();
        }
        this.mPlayerStateHelper.onPaused(playProgress, updateTime);
        this.mMediaSession.setPlaybackState(this.buildPlaybackState(2));
        this.mPlayerState.setPlayProgress(0);
        this.mPlayerState.setPlayProgressUpdateTime(updateTime);
        this.mBecomeNoiseHelper.unregisterBecomeNoiseReceiver();
        this.mOnStateChangeListener.onPaused();
        if (this.mPlayerStateListener != null) {
            this.mPlayerStateListener.onPause(playProgress, updateTime);
        }
    }

    public final void setMediaSession(@NonNull MediaSessionCompat mediaSession) {
        Preconditions.checkNotNull((Object)mediaSession);
        this.initMediaMetadataBuilder();
        this.initPlaybackStateBuilder();
        this.mMediaSession = mediaSession;
        if (this.getMusicItem() != null) {
            this.mPlayerState.setPlaybackState(PlaybackState.PAUSED);
            this.mMediaSession.setPlaybackState(this.buildPlaybackState(2));
        } else {
            this.mPlayerState.setPlaybackState(PlaybackState.NONE);
            this.mMediaSession.setPlaybackState(this.buildPlaybackState(0));
        }
        this.mMediaSession.setMetadata(this.buildMediaMetadata());
    }

    private void initPlaybackStateBuilder() {
        this.mPlaybackStateBuilder = new PlaybackStateCompat.Builder().setActions(2364287L);
        this.mForbidSeekPlaybackStateBuilder = new PlaybackStateCompat.Builder().setActions(2363959L);
    }

    private void initMediaMetadataBuilder() {
        this.mMediaMetadataBuilder = new MediaMetadataCompat.Builder();
    }

    private void initWakeLock() {
        PowerManager pm = (PowerManager)this.mApplicationContext.getSystemService("power");
        WifiManager wm = (WifiManager)this.mApplicationContext.getApplicationContext().getSystemService("wifi");
        String tag = "snow.player:AbstractPlayer";
        if (pm != null) {
            this.mWakeLock = pm.newWakeLock(1, tag);
            this.mWakeLock.setReferenceCounted(false);
        }
        if (wm != null) {
            this.mWifiLock = wm.createWifiLock(3, tag);
            this.mWifiLock.setReferenceCounted(false);
        }
    }

    public void setSleepTimer(SleepTimerImp sleepTimerImp) {
        this.mSleepTimer = sleepTimerImp;
    }

    private void requireWakeLock() {
        if (this.wakeLockPermissionDenied()) {
            Log.w((String)TAG, (String)"need permission: 'android.permission.WAKE_LOCK'");
            return;
        }
        if (this.mWakeLock != null && !this.mWakeLock.isHeld()) {
            this.mWakeLock.acquire((long)(this.getMusicItemDuration() + 5000));
        }
        if (this.mWifiLock != null && !this.mWifiLock.isHeld()) {
            this.mWifiLock.acquire();
        }
    }

    private boolean wakeLockPermissionDenied() {
        return -1 == ContextCompat.checkSelfPermission((Context)this.mApplicationContext, (String)"android.permission.WAKE_LOCK");
    }

    private void releaseWakeLock() {
        if (this.mWakeLock != null && this.mWakeLock.isHeld()) {
            this.mWakeLock.release();
        }
        if (this.mWifiLock != null && this.mWifiLock.isHeld()) {
            this.mWifiLock.release();
        }
    }

    private PlaybackStateCompat buildPlaybackState(int state) {
        if (this.mPlayerState.isForbidSeek()) {
            return this.mForbidSeekPlaybackStateBuilder.setState(state, (long)this.mPlayerState.getPlayProgress(), this.mPlayerState.getSpeed(), this.mPlayerState.getPlayProgressUpdateTime()).build();
        }
        return this.mPlaybackStateBuilder.setState(state, (long)this.mPlayerState.getPlayProgress(), this.mPlayerState.getSpeed(), this.mPlayerState.getPlayProgressUpdateTime()).build();
    }

    private PlaybackStateCompat buildErrorState(String errorMessage) {
        if (this.mPlayerState.isForbidSeek()) {
            return this.mForbidSeekPlaybackStateBuilder.setState(7, (long)this.mPlayerState.getPlayProgress(), this.mPlayerState.getSpeed(), this.mPlayerState.getPlayProgressUpdateTime()).setErrorMessage(1, (CharSequence)errorMessage).build();
        }
        return this.mPlaybackStateBuilder.setState(7, (long)this.mPlayerState.getPlayProgress(), this.mPlayerState.getSpeed(), this.mPlayerState.getPlayProgressUpdateTime()).setErrorMessage(1, (CharSequence)errorMessage).build();
    }

    private MediaMetadataCompat buildMediaMetadata() {
        MusicItem musicItem = this.getMusicItem();
        if (musicItem != null) {
            return this.mMediaMetadataBuilder.putString("android.media.metadata.TITLE", musicItem.getTitle()).putString("android.media.metadata.ARTIST", musicItem.getArtist()).putString("android.media.metadata.ALBUM", musicItem.getAlbum()).putString("android.media.metadata.DISPLAY_ICON_URI", musicItem.getIconUri()).putLong("android.media.metadata.DURATION", (long)this.mPlayerState.getDuration()).build();
        }
        return new MediaMetadataCompat.Builder().build();
    }

    private void attachListeners(MusicPlayer musicPlayer) {
        musicPlayer.setOnPreparedListener(this.mPreparedListener);
        musicPlayer.setOnCompletionListener(this.mCompletionListener);
        musicPlayer.setOnRepeatListener(this.mRepeatListener);
        musicPlayer.setOnSeekCompleteListener(this.mSeekCompleteListener);
        musicPlayer.setOnStalledListener(this.mStalledListener);
        musicPlayer.setOnBufferingUpdateListener(this.mBufferingUpdateListener);
        musicPlayer.setOnErrorListener(this.mErrorListener);
    }

    private void releaseMusicPlayer() {
        this.cancelRecordProgress();
        if (this.mMusicPlayer != null) {
            this.mMusicPlayer.release();
            this.mMusicPlayer = null;
        }
        this.mPlayerStateHelper.clearPrepareState();
        this.mPlayOnPrepared = false;
        this.mPlayOnSeekComplete = false;
        this.mPreparedAction = null;
        this.mSeekCompleteAction = null;
        if (this.mPlayerState.isStalled()) {
            this.notifyStalled(false);
        }
    }

    public final boolean isPrepared() {
        return this.mMusicPlayer != null && this.mPlayerState.isPrepared();
    }

    public final boolean isPreparing() {
        return this.mPlayerState.isPreparing();
    }

    public boolean isMusicPlayerPlaying() {
        if (this.isPrepared()) {
            assert (this.mMusicPlayer != null);
            return this.mMusicPlayer.isPlaying();
        }
        return false;
    }

    private boolean isPlayingState() {
        return this.getPlaybackState() == PlaybackState.PLAYING;
    }

    @NonNull
    public final PlaybackState getPlaybackState() {
        return this.mPlayerState.getPlaybackState();
    }

    @NonNull
    public final PlayMode getPlayMode() {
        return this.mPlayerState.getPlayMode();
    }

    public final boolean isStalled() {
        return this.mPlayerState.isStalled();
    }

    public final int getAudioSessionId() {
        if (this.mMusicPlayer != null && this.isPrepared()) {
            return this.mMusicPlayer.getAudioSessionId();
        }
        return 0;
    }

    public final void setPlayerStateListener(@Nullable PlayerStateListener listener) {
        this.mPlayerStateListener = listener;
    }

    private void notifyPreparing() {
        this.requireWakeLock();
        this.mPlayerStateHelper.onPreparing();
        this.mOnStateChangeListener.onPreparing();
        if (this.mPlayerStateListener != null) {
            this.mPlayerStateListener.onPreparing();
        }
    }

    private void notifyPrepared(int audioSessionId, int duration) {
        this.mPlayerStateHelper.onPrepared(audioSessionId, duration);
        this.mOnStateChangeListener.onPrepared(audioSessionId);
        if (this.mPlayerStateListener != null) {
            this.mPlayerStateListener.onPrepared(audioSessionId, duration);
        }
    }

    private void notifyPlaying(boolean stalled, int progress, long updateTime) {
        this.mPlayerStateHelper.onPlay(stalled, progress, updateTime);
        this.requireWakeLock();
        if (!stalled) {
            this.mMediaSession.setPlaybackState(this.buildPlaybackState(3));
        }
        this.startRecordProgress();
        this.mBecomeNoiseHelper.registerBecomeNoiseReceiver();
        this.mOnStateChangeListener.onPlaying(progress, updateTime);
        if (this.mPlayerStateListener != null) {
            this.mPlayerStateListener.onPlay(stalled, progress, updateTime);
        }
    }

    private void notifyPaused() {
        this.cancelRecordProgress();
        this.releaseWakeLock();
        int playProgress = this.mPlayerState.getPlayProgress();
        long updateTime = this.mPlayerState.getPlayProgressUpdateTime();
        if (this.isPrepared()) {
            assert (this.mMusicPlayer != null);
            playProgress = this.mMusicPlayer.getProgress();
            updateTime = SystemClock.elapsedRealtime();
        }
        this.mPlayerStateHelper.onPaused(playProgress, updateTime);
        this.mMediaSession.setPlaybackState(this.buildPlaybackState(2));
        this.mBecomeNoiseHelper.unregisterBecomeNoiseReceiver();
        this.mOnStateChangeListener.onPaused();
        if (this.mPlayerStateListener != null) {
            this.mPlayerStateListener.onPause(playProgress, updateTime);
        }
    }

    private void notifyStopped() {
        this.cancelRecordProgress();
        this.releaseWakeLock();
        this.mPlayerStateHelper.onStopped();
        this.mMediaSession.setActive(false);
        this.mMediaSession.setPlaybackState(this.buildPlaybackState(1));
        this.mAudioFocusHelper.abandonAudioFocus();
        this.mPhoneCallStateHelper.unregisterCallStateListener();
        this.mBecomeNoiseHelper.unregisterBecomeNoiseReceiver();
        this.mOnStateChangeListener.onStopped();
        if (this.mPlayerStateListener != null) {
            this.mPlayerStateListener.onStop();
        }
    }

    private void notifyStalled(boolean stalled) {
        int playProgress = this.mPlayerState.getPlayProgress();
        long updateTime = this.mPlayerState.getPlayProgressUpdateTime();
        if (this.isMusicPlayerPlaying()) {
            assert (this.mMusicPlayer != null);
            playProgress = this.mMusicPlayer.getProgress();
            updateTime = SystemClock.elapsedRealtime();
        }
        this.mPlayerStateHelper.onStalled(stalled, playProgress, updateTime);
        this.updateMediaSessionPlaybackState(stalled);
        this.mOnStateChangeListener.onStalledChanged(stalled);
        if (this.mPlayerStateListener != null) {
            this.mPlayerStateListener.onStalledChanged(stalled, playProgress, updateTime);
        }
    }

    private void notifyRepeat(long repeatTime) {
        this.mPlayerStateHelper.onRepeat(repeatTime);
        this.mMediaSession.setPlaybackState(this.buildPlaybackState(3));
        MusicItem musicItem = this.getMusicItem();
        if (this.mPlayerStateListener != null && musicItem != null) {
            this.mPlayerStateListener.onRepeat(musicItem, repeatTime);
        }
    }

    private void updateMediaSessionPlaybackState(boolean stalled) {
        if (stalled) {
            this.cancelRecordProgress();
            this.mMediaSession.setPlaybackState(this.buildPlaybackState(6));
            return;
        }
        if (this.mPlayOnPrepared || this.mPlayOnSeekComplete) {
            return;
        }
        switch (this.getPlaybackState()) {
            case PLAYING: {
                this.startRecordProgress();
                this.mMediaSession.setPlaybackState(this.buildPlaybackState(3));
                break;
            }
            case PAUSED: {
                this.mMediaSession.setPlaybackState(this.buildPlaybackState(2));
            }
        }
    }

    private void notifyError(int errorCode, String errorMessage) {
        this.releaseMusicPlayer();
        this.releaseWakeLock();
        this.mPlayerStateHelper.onError(errorCode, errorMessage);
        this.mMediaSession.setPlaybackState(this.buildErrorState(errorMessage));
        this.mAudioFocusHelper.abandonAudioFocus();
        this.mPhoneCallStateHelper.unregisterCallStateListener();
        this.mBecomeNoiseHelper.unregisterBecomeNoiseReceiver();
        this.mOnStateChangeListener.onError(errorCode, errorMessage);
        if (this.mPlayerStateListener != null) {
            this.mPlayerStateListener.onError(errorCode, errorMessage);
        }
    }

    private int getMusicItemDuration() {
        return this.mPlayerState.getDuration();
    }

    private void notifyBufferedChanged(int buffered, boolean isPercent) {
        int bufferedProgress = buffered;
        if (isPercent) {
            bufferedProgress = (int)((double)buffered / 100.0 * (double)this.getMusicItemDuration());
        }
        this.mPlayerStateHelper.onBufferedChanged(bufferedProgress);
        if (this.mPlayerStateListener != null) {
            this.mPlayerStateListener.onBufferedProgressChanged(bufferedProgress);
        }
    }

    private void notifyPlayingMusicItemChanged(@Nullable MusicItem musicItem, final int position, final boolean play) {
        this.disposePrepareMusicItem();
        this.releaseMusicPlayer();
        if (musicItem == null) {
            this.onPlayingMusicItemChanged(null, position, false);
            return;
        }
        this.prepareMusicItemAsync(musicItem).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((SingleObserver)new SingleObserver<MusicItem>(){

            public void onSubscribe(@NonNull Disposable d) {
                AbstractPlayer.this.mPrepareMusicItemDisposable = d;
            }

            public void onSuccess(@NonNull MusicItem musicItem) {
                AbstractPlayer.this.onPlayingMusicItemChanged(musicItem, position, play);
            }

            public void onError(@NonNull Throwable e) {
                AbstractPlayer.this.notifyError(9, ErrorCode.getErrorMessage(AbstractPlayer.this.mApplicationContext, 9));
            }
        });
    }

    private Single<MusicItem> prepareMusicItemAsync(final @NonNull MusicItem musicItem) {
        return Single.create((SingleOnSubscribe)new SingleOnSubscribe<MusicItem>(){

            public void subscribe(final @NonNull SingleEmitter<MusicItem> emitter) {
                AbstractPlayer.this.prepareMusicItem(musicItem, AbstractPlayer.this.mPlayerConfig.getSoundQuality(), new AsyncResult<MusicItem>(){

                    @Override
                    public void onSuccess(@NonNull MusicItem item) {
                        emitter.onSuccess((Object)item);
                    }

                    @Override
                    public void onError(@NonNull Throwable throwable) {
                        emitter.onError(throwable);
                    }

                    @Override
                    public boolean isCancelled() {
                        return emitter.isDisposed();
                    }

                    @Override
                    public synchronized void setOnCancelListener(@Nullable AsyncResult.OnCancelListener listener) {
                        super.setOnCancelListener(listener);
                        emitter.setCancellable(new Cancellable(){

                            public void cancel() {
                                this.notifyCancelled();
                            }
                        });
                    }
                });
            }
        });
    }

    private void disposePrepareMusicItem() {
        if (this.mPrepareMusicItemDisposable != null && !this.mPrepareMusicItemDisposable.isDisposed()) {
            this.mPrepareMusicItemDisposable.dispose();
        }
    }

    private void onPlayingMusicItemChanged(@Nullable MusicItem musicItem, int position, boolean play) {
        this.mPlayerStateHelper.onPlayingMusicItemChanged(musicItem, position, 0);
        if (musicItem == null) {
            this.mMediaSession.setPlaybackState(this.buildPlaybackState(0));
        }
        this.mMediaSession.setMetadata(this.buildMediaMetadata());
        this.mOnStateChangeListener.onPlayingMusicItemChanged(musicItem);
        if (this.mPlayerStateListener != null) {
            this.mPlayerStateListener.onPlayingMusicItemChanged(musicItem, position, this.mPlayerState.getPlayProgress());
        }
        this.notifyBufferedChanged(0, false);
        if (play) {
            this.play();
        } else {
            this.stop();
        }
    }

    private void notifySeekComplete(int playProgress, long updateTime, boolean stalled) {
        this.mPlayerStateHelper.onSeekComplete(playProgress, updateTime, stalled);
        if (this.mPlayerStateListener != null) {
            this.mPlayerStateListener.onSeekComplete(playProgress, updateTime, stalled);
        }
        if (stalled || this.mPlayOnSeekComplete) {
            return;
        }
        if (this.isMusicPlayerPlaying()) {
            this.mMediaSession.setPlaybackState(this.buildPlaybackState(3));
        } else {
            this.notifyPaused();
        }
    }

    @Override
    public void play() {
        if (this.getMusicItem() == null || this.isMusicPlayerPlaying()) {
            return;
        }
        if (this.isPreparing()) {
            this.mPreparedAction = new Runnable(){

                @Override
                public void run() {
                    AbstractPlayer.this.play();
                }
            };
            return;
        }
        if (this.requestAudioFocusFailed()) {
            return;
        }
        this.mMediaSession.setActive(true);
        if (this.isPrepared()) {
            assert (this.mMusicPlayer != null);
            this.mMusicPlayer.setSpeed(this.mPlayerState.getSpeed());
            this.mMusicPlayer.start();
            this.notifyPlaying(this.mMusicPlayer.isStalled(), this.mMusicPlayer.getProgress(), SystemClock.elapsedRealtime());
            return;
        }
        this.prepareMusicPlayer(true, null);
    }

    @Override
    public void pause() {
        this.mResumePlay = false;
        if (this.isPreparing()) {
            this.mPlayOnPrepared = false;
            this.mPlayOnSeekComplete = false;
            return;
        }
        if (!this.isPlayingState()) {
            return;
        }
        if (this.mMusicPlayer != null && this.mMusicPlayer.isPlaying()) {
            this.mMusicPlayer.pause();
        }
        this.notifyPaused();
    }

    @Override
    public void stop() {
        if (this.getPlaybackState() == PlaybackState.STOPPED) {
            return;
        }
        if (this.isPrepared()) {
            assert (this.mMusicPlayer != null);
            this.mMusicPlayer.stop();
        }
        this.releaseMusicPlayer();
        this.notifyStopped();
    }

    @Override
    public void playPause() {
        if (this.isPreparing() && this.mPlayOnPrepared) {
            this.pause();
            return;
        }
        if (this.isPlayingState()) {
            this.pause();
        } else {
            this.play();
        }
    }

    private void seekTo(final int progress, final Runnable seekCompleteAction) {
        if (this.mPlayerState.isForbidSeek()) {
            return;
        }
        if (this.isPreparing()) {
            this.mPlayOnSeekComplete = this.mPlayOnPrepared;
            this.mPlayOnPrepared = false;
            this.mPreparedAction = new Runnable(){

                @Override
                public void run() {
                    AbstractPlayer.this.seekTo(progress, seekCompleteAction);
                }
            };
            return;
        }
        if (this.isPrepared()) {
            assert (this.mMusicPlayer != null);
            this.mSeekCompleteAction = seekCompleteAction;
            this.mMusicPlayer.seekTo(progress);
            return;
        }
        if (this.getMusicItem() != null) {
            this.notifySeekComplete(Math.min(progress, this.getMusicItemDuration()), SystemClock.elapsedRealtime(), false);
        }
    }

    @Override
    public void seekTo(int progress) {
        this.seekTo(progress, null);
    }

    @Override
    public void fastForward() {
        if (this.mPlayerState.isForbidSeek()) {
            return;
        }
        if (this.isPreparing()) {
            this.mPreparedAction = new Runnable(){

                @Override
                public void run() {
                    AbstractPlayer.this.fastForward();
                }
            };
            return;
        }
        int progress = Math.min(this.mPlayerState.getDuration(), this.mPlayerState.getPlayProgress() + 15000);
        this.mMediaSession.setPlaybackState(this.buildPlaybackState(4));
        this.seekTo(progress);
    }

    @Override
    public void rewind() {
        if (this.mPlayerState.isForbidSeek()) {
            return;
        }
        if (this.isPreparing()) {
            this.mPreparedAction = new Runnable(){

                @Override
                public void run() {
                    AbstractPlayer.this.rewind();
                }
            };
            return;
        }
        int progress = Math.min(this.mPlayerState.getDuration(), this.mPlayerState.getPlayProgress() - 15000);
        this.mMediaSession.setPlaybackState(this.buildPlaybackState(5));
        this.seekTo(progress);
    }

    public final void notifySoundQualityChanged() {
        if (this.isPrepared()) {
            assert (this.mMusicPlayer != null);
            boolean playing = this.mMusicPlayer.isPlaying();
            final int position = this.mMusicPlayer.getProgress();
            this.releaseMusicPlayer();
            this.prepareMusicPlayer(playing, new Runnable(){

                @Override
                public void run() {
                    if (position > 0) {
                        AbstractPlayer.this.seekTo(position);
                    }
                }
            });
        }
    }

    public final void notifyAudioEffectEnableChanged() {
        if (!this.isPrepared() || this.mAudioEffectManager == null) {
            return;
        }
        if (this.mPlayerConfig.isAudioEffectEnabled()) {
            this.attachAudioEffect(this.mAudioEffectManager);
            return;
        }
        this.mAudioEffectManager.detachAudioEffect();
    }

    private void attachAudioEffect(AudioEffectManager audioEffectManager) {
        int audioSessionId = this.getAudioSessionId();
        if (audioSessionId < 1) {
            return;
        }
        audioEffectManager.attachAudioEffect(audioSessionId);
    }

    public final void notifyOnlyWifiNetworkChanged() {
        if (!this.isPrepared()) {
            return;
        }
        this.checkNetworkType(this.mPlayerConfig.isOnlyWifiNetwork(), this.mNetworkHelper.isWifiNetwork());
    }

    public void notifyIgnoreAudioFocusChanged() {
        if (this.requestAudioFocusFailed() && (this.isPlayingState() || this.mPlayOnPrepared)) {
            this.pause();
        }
    }

    private boolean requestAudioFocusFailed() {
        if (this.mPlayerConfig.isIgnoreAudioFocus()) {
            this.mAudioFocusHelper.abandonAudioFocus();
            this.mPhoneCallStateHelper.registerCallStateListener();
            return !this.mPhoneCallStateHelper.isCallIDLE();
        }
        return 0 == this.mAudioFocusHelper.requestAudioFocus(3, 1);
    }

    private void checkNetworkType(boolean onlyWifiNetwork, boolean isWifiNetwork) {
        this.disposeCheckCached();
        if (!this.mNetworkHelper.networkAvailable()) {
            return;
        }
        this.mCheckCachedDisposable = this.playingMusicIsCached().subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(this.checkNetworkTypeConsumer(onlyWifiNetwork, isWifiNetwork));
    }

    private void disposeCheckCached() {
        if (this.mCheckCachedDisposable != null) {
            this.mCheckCachedDisposable.dispose();
            this.mCheckCachedDisposable = null;
        }
    }

    private Single<Boolean> playingMusicIsCached() {
        return Single.create((SingleOnSubscribe)new SingleOnSubscribe<Boolean>(){

            public void subscribe(final @NonNull SingleEmitter<Boolean> emitter) {
                MusicItem musicItem = AbstractPlayer.this.getMusicItem();
                if (musicItem == null) {
                    emitter.onSuccess((Object)false);
                    return;
                }
                AbstractPlayer.this.isCached(musicItem, AbstractPlayer.this.mPlayerConfig.getSoundQuality(), new AsyncResult<Boolean>(){

                    @Override
                    public void onSuccess(@NonNull Boolean aBoolean) {
                        emitter.onSuccess((Object)aBoolean);
                    }

                    @Override
                    public void onError(@NonNull Throwable throwable) {
                        throwable.printStackTrace();
                        emitter.onSuccess((Object)false);
                    }

                    @Override
                    public boolean isCancelled() {
                        return emitter.isDisposed();
                    }

                    @Override
                    public synchronized void setOnCancelListener(@Nullable AsyncResult.OnCancelListener listener) {
                        super.setOnCancelListener(listener);
                        emitter.setCancellable(new Cancellable(){

                            public void cancel() {
                                this.notifyCancelled();
                            }
                        });
                    }
                });
            }
        });
    }

    private Consumer<Boolean> checkNetworkTypeConsumer(final boolean onlyWifiNetwork, final boolean isWifiNetwork) {
        return new Consumer<Boolean>(){

            public void accept(Boolean cached) {
                if (onlyWifiNetwork && !isWifiNetwork && !cached.booleanValue()) {
                    AbstractPlayer.this.pause();
                    AbstractPlayer.this.releaseMusicPlayer();
                    AbstractPlayer.this.notifyError(1, ErrorCode.getErrorMessage(AbstractPlayer.this.mApplicationContext, 1));
                }
            }
        };
    }

    private void reloadPlaylist() {
        this.mLoadingPlaylist = true;
        this.mPlaylistManager.getPlaylist(new PlaylistManager.Callback(){

            @Override
            public void onFinished(@NonNull Playlist playlist) {
                if (AbstractPlayer.this.mReleased) {
                    return;
                }
                AbstractPlayer.this.mPlaylist = playlist;
                AbstractPlayer.this.mLoadingPlaylist = false;
                if (!AbstractPlayer.this.mInitialized) {
                    AbstractPlayer.this.mInitialized = true;
                    AbstractPlayer.this.notifyInitialized();
                }
                if (AbstractPlayer.this.mPlaylistLoadedAction != null) {
                    AbstractPlayer.this.mPlaylistLoadedAction.run();
                    AbstractPlayer.this.mPlaylistLoadedAction = null;
                }
            }
        });
    }

    private void notifyInitialized() {
        if (this.mPlaylist.isEmpty()) {
            this.mOnInitializedListener.onInitialized();
            return;
        }
        this.prepareMusicItemAsync(this.mPlaylist.get(this.mPlayerState.getPlayPosition())).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((SingleObserver)new SingleObserver<MusicItem>(){

            public void onSubscribe(@NonNull Disposable d) {
                AbstractPlayer.this.mPrepareMusicItemDisposable = d;
            }

            public void onSuccess(@NonNull MusicItem musicItem) {
                AbstractPlayer.this.mPlayerState.setMusicItem(musicItem);
                AbstractPlayer.this.mOnInitializedListener.onInitialized();
            }

            public void onError(@NonNull Throwable e) {
                AbstractPlayer.this.notifyError(9, ErrorCode.getErrorMessage(AbstractPlayer.this.mApplicationContext, 9));
            }
        });
    }

    private int getRandomPosition(int exclude) {
        int position;
        if (this.mPlaylist == null || this.getPlaylistSize() < 2) {
            return 0;
        }
        if (this.mRandom == null) {
            this.mRandom = new Random();
        }
        if ((position = this.mRandom.nextInt(this.getPlaylistSize())) != exclude) {
            return position;
        }
        return this.getRandomPosition(exclude);
    }

    private void notifyPlayModeChanged(PlayMode playMode) {
        this.mPlayerStateHelper.onPlayModeChanged(playMode);
        if (this.mPlayerStateListener != null) {
            this.mPlayerStateListener.onPlayModeChanged(playMode);
        }
        this.mOnStateChangeListener.onPlayModeChanged(playMode);
    }

    private void notifySpeedChanged(float speed, int progress, long updateTime) {
        this.mPlayerStateHelper.onSpeedChanged(speed, progress, updateTime);
        this.mMediaSession.setPlaybackState(this.buildPlaybackState(this.mMediaSession.getController().getPlaybackState().getState()));
        if (this.mPlayerStateListener != null) {
            this.mPlayerStateListener.onSpeedChanged(speed, progress, updateTime);
        }
    }

    private void notifyPlaylistChanged(int position) {
        this.mPlayerStateHelper.onPlaylistChanged(position);
        if (this.mPlayerStateListener != null) {
            this.mPlayerStateListener.onPlaylistChanged(null, position);
        }
    }

    protected final int getPlaylistSize() {
        return this.mPlaylistManager.getPlaylistSize();
    }

    @Nullable
    public final Bundle getPlaylistExtra() {
        if (this.mPlaylist == null) {
            return null;
        }
        return this.mPlaylist.getExtra();
    }

    private boolean isLooping() {
        return this.mPlayerState.getPlayMode() == PlayMode.LOOP;
    }

    @Override
    public void skipToNext() {
        if (this.mLoadingPlaylist) {
            this.mPlaylistLoadedAction = new Runnable(){

                @Override
                public void run() {
                    AbstractPlayer.this.skipToNext();
                }
            };
            return;
        }
        if (this.getPlaylistSize() < 1) {
            return;
        }
        int position = this.getNextPosition(this.mPlayerState.getPlayPosition());
        this.notifyPlayingMusicItemChanged(this.mPlaylist.get(position), position, true);
        this.mMediaSession.setPlaybackState(this.buildPlaybackState(10));
    }

    @Override
    public void skipToPosition(int position) {
        if (position == this.mPlayerState.getPlayPosition()) {
            return;
        }
        this.playPause(position);
    }

    private int getNextPosition(int currentPosition) {
        PlayMode playMode = this.mPlayerState.getPlayMode();
        if (this.mConfirmNextPlay || playMode == PlayMode.PLAYLIST_LOOP || playMode == PlayMode.LOOP || playMode == PlayMode.SINGLE_ONCE) {
            this.mConfirmNextPlay = false;
            int position = currentPosition + 1;
            if (position >= this.getPlaylistSize()) {
                return 0;
            }
            return position;
        }
        return this.getRandomPosition(currentPosition);
    }

    @Override
    public void skipToPrevious() {
        if (this.mLoadingPlaylist) {
            this.mPlaylistLoadedAction = new Runnable(){

                @Override
                public void run() {
                    AbstractPlayer.this.skipToPrevious();
                }
            };
            return;
        }
        if (this.getPlaylistSize() < 1) {
            return;
        }
        int position = this.getPreviousPosition(this.mPlayerState.getPlayPosition());
        this.notifyPlayingMusicItemChanged(this.mPlaylist.get(position), position, true);
        this.mMediaSession.setPlaybackState(this.buildPlaybackState(9));
    }

    private int getPreviousPosition(int currentPosition) {
        int position = 0;
        switch (this.mPlayerState.getPlayMode()) {
            case PLAYLIST_LOOP: 
            case LOOP: {
                position = currentPosition - 1;
                if (position >= 0) break;
                return this.getPlaylistSize() - 1;
            }
            case SHUFFLE: {
                position = this.getRandomPosition(currentPosition);
            }
        }
        return position;
    }

    @Override
    public void playPause(final int position) {
        if (this.mLoadingPlaylist) {
            this.mPlaylistLoadedAction = new Runnable(){

                @Override
                public void run() {
                    AbstractPlayer.this.playPause(position);
                }
            };
            return;
        }
        if (position < 0 || position >= this.mPlaylist.size()) {
            this.notifyError(10, ErrorCode.getErrorMessage(this.mApplicationContext, 10));
            return;
        }
        if (position == this.mPlayerState.getPlayPosition()) {
            this.playPause();
            return;
        }
        this.mMediaSession.setPlaybackState(this.buildPlaybackState(11));
        this.notifyPlayingMusicItemChanged(this.mPlaylist.get(position), position, true);
    }

    @Override
    public void setPlayMode(@NonNull PlayMode playMode) {
        Preconditions.checkNotNull((Object)((Object)playMode));
        if (playMode == this.mPlayerState.getPlayMode()) {
            return;
        }
        if (this.isPrepared()) {
            assert (this.mMusicPlayer != null);
            this.mMusicPlayer.setLooping(playMode == PlayMode.LOOP);
        }
        this.notifyPlayModeChanged(playMode);
    }

    @Override
    public void setSpeed(float speed) {
        if (speed < 0.1f) {
            speed = 0.1f;
        }
        if (speed > 10.0f) {
            speed = 10.0f;
        }
        if (speed == this.mPlayerState.getSpeed()) {
            return;
        }
        if (this.isPrepared()) {
            assert (this.mMusicPlayer != null);
            this.mMusicPlayer.setSpeed(speed);
            this.notifySpeedChanged(speed, this.mMusicPlayer.getProgress(), SystemClock.elapsedRealtime());
            return;
        }
        this.notifySpeedChanged(speed, this.mPlayerState.getPlayProgress(), SystemClock.elapsedRealtime());
    }

    @Override
    public void setPlaylist(Playlist playlist, final int position, final boolean play) {
        if (position < 0 || position >= playlist.size()) {
            this.notifyError(10, ErrorCode.getErrorMessage(this.mApplicationContext, 10));
            return;
        }
        final MusicItem musicItem = playlist.get(position);
        this.updatePlaylist(playlist, playlist.getAllMusicItem(), new Runnable(){

            @Override
            public void run() {
                AbstractPlayer.this.notifyPlaylistChanged(position);
                AbstractPlayer.this.notifyPlayingMusicItemChanged(musicItem, position, play);
            }
        });
    }

    private void onMusicItemMoved(int fromPosition, int toPosition) {
        int playPosition = this.mPlayerState.getPlayPosition();
        if (this.notInRegion(playPosition, fromPosition, toPosition)) {
            this.notifyPlaylistChanged(playPosition);
            return;
        }
        playPosition = fromPosition < playPosition ? --playPosition : (fromPosition == playPosition ? toPosition : ++playPosition);
        this.mPlayerState.setPlayPosition(playPosition);
    }

    private void onMusicItemInserted(int position) {
        int playPosition = this.mPlayerState.getPlayPosition();
        if (position <= playPosition) {
            ++playPosition;
        }
        this.mPlayerState.setPlayPosition(playPosition);
    }

    private void onMusicItemRemoved(int removePosition, int playPosition) {
        if (removePosition < playPosition) {
            --playPosition;
        } else if (removePosition == playPosition) {
            playPosition = this.getNextPosition(playPosition - 1);
        }
        this.mPlayerState.setPlayPosition(playPosition);
    }

    private boolean notInRegion(int position, int fromPosition, int toPosition) {
        return position > Math.max(fromPosition, toPosition) || position < Math.min(fromPosition, toPosition);
    }

    private void startRecordProgress() {
        this.cancelRecordProgress();
        if (this.mPlayerState.isForbidSeek()) {
            return;
        }
        this.mRecordProgressDisposable = Observable.interval((long)0L, (long)1L, (TimeUnit)TimeUnit.SECONDS, (Scheduler)Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Long>(){

            public void accept(Long aLong) {
                if (AbstractPlayer.this.isPrepared()) {
                    assert (AbstractPlayer.this.mMusicPlayer != null);
                    AbstractPlayer.this.mPlayerStateHelper.updatePlayProgress(AbstractPlayer.this.mMusicPlayer.getProgress(), SystemClock.elapsedRealtime());
                }
            }
        });
    }

    private void cancelRecordProgress() {
        if (this.mRecordProgressDisposable == null || this.mRecordProgressDisposable.isDisposed()) {
            return;
        }
        this.mRecordProgressDisposable.dispose();
    }

    @Override
    public void insertMusicItem(final int position, final @NonNull MusicItem musicItem) {
        if (!this.mPlaylistManager.isPlaylistEditable()) {
            return;
        }
        if (this.mLoadingPlaylist) {
            this.mPlaylistLoadedAction = new Runnable(){

                @Override
                public void run() {
                    AbstractPlayer.this.insertMusicItem(position, musicItem);
                }
            };
            return;
        }
        List<MusicItem> musicItems = this.mPlaylist.getAllMusicItem();
        int index = musicItems.indexOf(musicItem);
        if (index > -1) {
            this.moveMusicItem(index, Math.min(position, this.getPlaylistSize() - 1));
            return;
        }
        musicItems.add(position, musicItem);
        this.onMusicItemInserted(position);
        this.updatePlaylist(this.mPlaylist, musicItems, new Runnable(){

            @Override
            public void run() {
                AbstractPlayer.this.notifyPlaylistChanged(AbstractPlayer.this.mPlayerState.getPlayPosition());
            }
        });
    }

    @Override
    public void appendMusicItem(@NonNull MusicItem musicItem) {
        if (!this.mPlaylistManager.isPlaylistEditable()) {
            return;
        }
        this.insertMusicItem(this.getPlaylistSize(), musicItem);
    }

    @Override
    public void moveMusicItem(final int fromPosition, final int toPosition) {
        if (!this.mPlaylistManager.isPlaylistEditable()) {
            return;
        }
        if (fromPosition == toPosition) {
            return;
        }
        if (this.mLoadingPlaylist) {
            this.mPlaylistLoadedAction = new Runnable(){

                @Override
                public void run() {
                    AbstractPlayer.this.moveMusicItem(fromPosition, toPosition);
                }
            };
            return;
        }
        int size = this.mPlaylist.size();
        if (fromPosition < 0 || fromPosition >= size) {
            throw new IndexOutOfBoundsException("fromPosition: " + fromPosition + ", size: " + size);
        }
        if (toPosition < 0 || toPosition >= size) {
            throw new IndexOutOfBoundsException("toPosition: " + toPosition + ", size: " + size);
        }
        List<MusicItem> musicItems = this.mPlaylist.getAllMusicItem();
        if (toPosition == this.getPlaylistSize() - 1) {
            musicItems.add(musicItems.remove(fromPosition));
        } else {
            MusicItem musicItem = musicItems.get(fromPosition);
            musicItems.add(toPosition, musicItem);
            musicItems.remove(fromPosition < toPosition ? fromPosition : fromPosition + 1);
        }
        this.onMusicItemMoved(fromPosition, toPosition);
        this.updatePlaylist(this.mPlaylist, musicItems, new Runnable(){

            @Override
            public void run() {
                AbstractPlayer.this.notifyPlaylistChanged(AbstractPlayer.this.mPlayerState.getPlayPosition());
            }
        });
    }

    @Override
    public void removeMusicItem(final @NonNull MusicItem musicItem) {
        if (!this.mPlaylistManager.isPlaylistEditable()) {
            return;
        }
        if (this.mLoadingPlaylist) {
            this.mPlaylistLoadedAction = new Runnable(){

                @Override
                public void run() {
                    AbstractPlayer.this.removeMusicItem(musicItem);
                }
            };
            return;
        }
        List<MusicItem> musicItems = this.mPlaylist.getAllMusicItem();
        if (!musicItems.contains(musicItem)) {
            return;
        }
        final int index = musicItems.indexOf(musicItem);
        final int oldPlayPosition = this.mPlayerState.getPlayPosition();
        musicItems.remove(musicItem);
        this.onMusicItemRemoved(index, oldPlayPosition);
        this.updatePlaylist(this.mPlaylist, musicItems, new Runnable(){

            @Override
            public void run() {
                int playPosition = AbstractPlayer.this.mPlayerState.getPlayPosition();
                AbstractPlayer.this.notifyPlaylistChanged(playPosition);
                if (AbstractPlayer.this.mPlaylist.isEmpty()) {
                    AbstractPlayer.this.notifyPlayingMusicItemChanged(null, playPosition, false);
                    AbstractPlayer.this.notifyStopped();
                    return;
                }
                if (index == oldPlayPosition) {
                    playPosition = playPosition < AbstractPlayer.this.mPlaylist.size() ? playPosition : 0;
                    AbstractPlayer.this.notifyPlayingMusicItemChanged(AbstractPlayer.this.mPlaylist.get(playPosition), playPosition, AbstractPlayer.this.isMusicPlayerPlaying());
                }
            }
        });
    }

    @Override
    public void removeMusicItem(final int position) {
        if (!this.mPlaylistManager.isPlaylistEditable()) {
            return;
        }
        if (this.mLoadingPlaylist) {
            this.mPlaylistLoadedAction = new Runnable(){

                @Override
                public void run() {
                    AbstractPlayer.this.removeMusicItem(position);
                }
            };
            return;
        }
        if (position < 0 || position >= this.mPlaylist.size()) {
            return;
        }
        this.removeMusicItem(this.mPlaylist.get(position));
    }

    @Override
    public void setNextPlay(final @NonNull MusicItem musicItem) {
        if (!this.mPlaylistManager.isPlaylistEditable()) {
            return;
        }
        if (musicItem.equals(this.getMusicItem())) {
            return;
        }
        if (this.mLoadingPlaylist) {
            this.mPlaylistLoadedAction = new Runnable(){

                @Override
                public void run() {
                    AbstractPlayer.this.setNextPlay(musicItem);
                }
            };
            return;
        }
        this.insertMusicItem(this.mPlayerState.getPlayPosition() + 1, musicItem);
        this.mConfirmNextPlay = true;
    }

    private void updatePlaylist(Playlist playlist, List<MusicItem> musicItems, Runnable doOnSaved) {
        this.mPlaylist = new Playlist.Builder().setName(playlist.getName()).appendAll(musicItems).setEditable(playlist.isEditable()).setExtra(playlist.getExtra()).build();
        this.mPlaylistManager.save(this.mPlaylist, doOnSaved);
    }

    static interface OnInitializedListener {
        public void onInitialized();
    }

    static interface OnStateChangeListener {
        public void onPreparing();

        public void onPrepared(int var1);

        public void onPlaying(int var1, long var2);

        public void onPaused();

        public void onStalledChanged(boolean var1);

        public void onStopped();

        public void onError(int var1, String var2);

        public void onPlayingMusicItemChanged(@Nullable MusicItem var1);

        public void onPlayModeChanged(@NonNull PlayMode var1);
    }
}

