/*
 * Decompiled with CFR 0.152.
 */
package snow.player.util;

import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import snow.player.audio.MusicItem;
import snow.player.playlist.Playlist;

public class MovablePlaylist {
    private final List<MusicItem> mMusicItems;
    private int mPlayPosition;

    public MovablePlaylist(@NonNull Playlist playlist, int playPosition) {
        Objects.requireNonNull(playlist);
        this.mMusicItems = new ArrayList<MusicItem>(playlist.getAllMusicItem());
        this.mPlayPosition = playPosition;
    }

    public void move(int fromPosition, int toPosition) {
        if (fromPosition == toPosition) {
            return;
        }
        this.mMusicItems.add(toPosition, this.mMusicItems.remove(fromPosition));
        this.updatePlayPosition(fromPosition, toPosition);
    }

    private void updatePlayPosition(int fromPosition, int toPosition) {
        int playPosition = this.mPlayPosition;
        if (this.notInRegion(playPosition, fromPosition, toPosition)) {
            return;
        }
        playPosition = fromPosition < playPosition ? --playPosition : (fromPosition == playPosition ? toPosition : ++playPosition);
        this.mPlayPosition = playPosition;
    }

    private boolean notInRegion(int position, int fromPosition, int toPosition) {
        return position > Math.max(fromPosition, toPosition) || position < Math.min(fromPosition, toPosition);
    }

    public int getPlayPosition() {
        return this.mPlayPosition;
    }

    public MusicItem get(int index) {
        return this.mMusicItems.get(index);
    }

    public int size() {
        return this.mMusicItems.size();
    }

    public boolean isEmpty() {
        return this.mMusicItems.isEmpty();
    }
}

