/*
 * Decompiled with CFR 0.152.
 */
package snow.player.playlist;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import snow.player.audio.MusicItem;
import snow.player.playlist.Playlist;
import snow.player.playlist.PlaylistEditor;

public final class PlaylistEditor__ChannelHelper {
    private static final String KEY_CLASS_NAME = "__class_name";
    private static final String KEY_METHOD_ID = "__method_id";
    private static final String CLASS_NAME = "snow.player.playlist.PlaylistEditor";
    private static final int METHOD_ID_1 = 1;
    private static final int METHOD_ID_2 = 2;
    private static final int METHOD_ID_3 = 3;
    private static final int METHOD_ID_4 = 4;
    private static final int METHOD_ID_5 = 5;
    private static final int METHOD_ID_6 = 6;
    private static final int METHOD_ID_7 = 7;

    private PlaylistEditor__ChannelHelper() {
        throw new AssertionError();
    }

    public static final class Dispatcher
    implements channel.helper.Dispatcher {
        private final WeakReference<PlaylistEditor> callbackWeakReference;

        public Dispatcher(PlaylistEditor callback) {
            this.callbackWeakReference = new WeakReference<PlaylistEditor>(callback);
        }

        public boolean match(Map<String, Object> data) {
            return PlaylistEditor__ChannelHelper.CLASS_NAME.equals(data.get(PlaylistEditor__ChannelHelper.KEY_CLASS_NAME));
        }

        public boolean dispatch(Map<String, Object> data) {
            if (!this.match(data)) {
                return false;
            }
            int methodId = (Integer)data.get(PlaylistEditor__ChannelHelper.KEY_METHOD_ID);
            PlaylistEditor callback = (PlaylistEditor)this.callbackWeakReference.get();
            if (callback == null) {
                return false;
            }
            switch (methodId) {
                case 1: {
                    int METHOD_ID_1_position = (Integer)data.get("position");
                    MusicItem METHOD_ID_1_musicItem = (MusicItem)data.get("musicItem");
                    callback.insertMusicItem(METHOD_ID_1_position, METHOD_ID_1_musicItem);
                    return true;
                }
                case 2: {
                    MusicItem METHOD_ID_2_musicItem = (MusicItem)data.get("musicItem");
                    callback.appendMusicItem(METHOD_ID_2_musicItem);
                    return true;
                }
                case 3: {
                    int METHOD_ID_3_fromPosition = (Integer)data.get("fromPosition");
                    int METHOD_ID_3_toPosition = (Integer)data.get("toPosition");
                    callback.moveMusicItem(METHOD_ID_3_fromPosition, METHOD_ID_3_toPosition);
                    return true;
                }
                case 4: {
                    MusicItem METHOD_ID_4_musicItem = (MusicItem)data.get("musicItem");
                    callback.removeMusicItem(METHOD_ID_4_musicItem);
                    return true;
                }
                case 5: {
                    int METHOD_ID_5_position = (Integer)data.get("position");
                    callback.removeMusicItem(METHOD_ID_5_position);
                    return true;
                }
                case 6: {
                    MusicItem METHOD_ID_6_musicItem = (MusicItem)data.get("musicItem");
                    callback.setNextPlay(METHOD_ID_6_musicItem);
                    return true;
                }
                case 7: {
                    Playlist METHOD_ID_7_playlist = (Playlist)data.get("playlist");
                    int METHOD_ID_7_position = (Integer)data.get("position");
                    boolean METHOD_ID_7_play = (Boolean)data.get("play");
                    callback.setPlaylist(METHOD_ID_7_playlist, METHOD_ID_7_position, METHOD_ID_7_play);
                    return true;
                }
            }
            return false;
        }
    }

    public static final class Emitter
    implements PlaylistEditor {
        private channel.helper.Emitter emitter;

        public Emitter(channel.helper.Emitter emitter) {
            this.emitter = emitter;
        }

        private void sendMessage(int id, Map<String, Object> args) {
            args.put(PlaylistEditor__ChannelHelper.KEY_CLASS_NAME, PlaylistEditor__ChannelHelper.CLASS_NAME);
            args.put(PlaylistEditor__ChannelHelper.KEY_METHOD_ID, id);
            this.emitter.emit(args);
        }

        @Override
        public void insertMusicItem(int position, MusicItem musicItem) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("position", position);
            args.put("musicItem", musicItem);
            this.sendMessage(1, args);
        }

        @Override
        public void appendMusicItem(MusicItem musicItem) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("musicItem", musicItem);
            this.sendMessage(2, args);
        }

        @Override
        public void moveMusicItem(int fromPosition, int toPosition) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("fromPosition", fromPosition);
            args.put("toPosition", toPosition);
            this.sendMessage(3, args);
        }

        @Override
        public void removeMusicItem(MusicItem musicItem) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("musicItem", musicItem);
            this.sendMessage(4, args);
        }

        @Override
        public void removeMusicItem(int position) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("position", position);
            this.sendMessage(5, args);
        }

        @Override
        public void setNextPlay(MusicItem musicItem) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("musicItem", musicItem);
            this.sendMessage(6, args);
        }

        @Override
        public void setPlaylist(Playlist playlist, int position, boolean play) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("playlist", playlist);
            args.put("position", position);
            args.put("play", play);
            this.sendMessage(7, args);
        }
    }
}

