/*
 * Decompiled with CFR 0.152.
 */
package snow.player.helper;

import android.content.Context;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import com.google.common.base.Preconditions;

public final class PhoneCallStateHelper {
    private final Context mApplicationContext;
    private final TelephonyManager mTelephonyManager;
    private final PhoneStateListener mPhoneStateListener;
    private final OnStateChangeListener mCallStateListener;
    private boolean mRegistered;

    public PhoneCallStateHelper(@NonNull Context context, @NonNull OnStateChangeListener listener) {
        Preconditions.checkNotNull((Object)listener);
        this.mApplicationContext = context.getApplicationContext();
        this.mTelephonyManager = (TelephonyManager)context.getSystemService("phone");
        this.mCallStateListener = listener;
        this.mPhoneStateListener = new PhoneStateListener(){

            public void onCallStateChanged(int state, String phoneNumber) {
                switch (state) {
                    case 0: {
                        PhoneCallStateHelper.this.mCallStateListener.onIDLE();
                        break;
                    }
                    case 1: {
                        PhoneCallStateHelper.this.mCallStateListener.onRinging();
                        break;
                    }
                    case 2: {
                        PhoneCallStateHelper.this.mCallStateListener.onOffHook();
                    }
                }
            }
        };
    }

    public boolean isCallIDLE() {
        if (this.noPermission()) {
            return true;
        }
        return this.mTelephonyManager.getCallState() == 0;
    }

    public void registerCallStateListener() {
        if (this.noPermission()) {
            return;
        }
        if (this.mRegistered) {
            return;
        }
        this.mRegistered = true;
        this.addPhoneStartListener();
    }

    public void unregisterCallStateListener() {
        if (this.mRegistered) {
            this.mRegistered = false;
            if (this.noPermission()) {
                return;
            }
            this.removePhoneStateListener();
        }
    }

    private void addPhoneStartListener() {
        this.mTelephonyManager.listen(this.mPhoneStateListener, 32);
    }

    private void removePhoneStateListener() {
        this.mTelephonyManager.listen(this.mPhoneStateListener, 0);
    }

    private boolean noPermission() {
        return ContextCompat.checkSelfPermission((Context)this.mApplicationContext, (String)"android.permission.READ_PHONE_STATE") != 0;
    }

    public static interface OnStateChangeListener {
        public void onIDLE();

        public void onRinging();

        public void onOffHook();
    }
}

