/*
 * Decompiled with CFR 0.152.
 */
package snow.player.helper;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.google.common.base.Preconditions;
import java.lang.ref.WeakReference;

public class NetworkHelper {
    private final Context mApplicationContext;
    private final WeakReference<OnNetworkStateChangeListener> mListenerWeakReference;
    private final ConnectivityManager mConnectivityManager;
    private final BroadcastReceiver mNetworkStateReceiver;
    private ConnectivityManager.NetworkCallback mNetworkCallback;

    private NetworkHelper(Context context, OnNetworkStateChangeListener listener) {
        this.mApplicationContext = context;
        this.mListenerWeakReference = new WeakReference<OnNetworkStateChangeListener>(listener);
        this.mConnectivityManager = (ConnectivityManager)this.mApplicationContext.getSystemService("connectivity");
        this.mNetworkStateReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                OnNetworkStateChangeListener ls = (OnNetworkStateChangeListener)NetworkHelper.this.mListenerWeakReference.get();
                if (ls == null) {
                    return;
                }
                ls.onNetworkStateChanged(NetworkHelper.this.networkAvailable(), NetworkHelper.this.isWifiNetwork());
            }
        };
        if (Build.VERSION.SDK_INT >= 28) {
            this.mNetworkCallback = new ConnectivityManager.NetworkCallback(){

                public void onLosing(@NonNull Network network, int maxMsToLive) {
                    OnNetworkStateChangeListener ls = (OnNetworkStateChangeListener)NetworkHelper.this.mListenerWeakReference.get();
                    if (ls == null) {
                        return;
                    }
                    ls.onNetworkStateChanged(NetworkHelper.this.networkAvailable(), false);
                }

                public void onAvailable(@NonNull Network network) {
                    OnNetworkStateChangeListener ls = (OnNetworkStateChangeListener)NetworkHelper.this.mListenerWeakReference.get();
                    if (ls == null) {
                        return;
                    }
                    ls.onNetworkStateChanged(NetworkHelper.this.networkAvailable(), true);
                }
            };
        }
    }

    public static NetworkHelper newInstance(@NonNull Context context, @NonNull OnNetworkStateChangeListener listener) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)listener);
        return new NetworkHelper(context, listener);
    }

    public boolean networkAvailable() {
        if (Build.VERSION.SDK_INT >= 28) {
            return this.hasNetworkApi28();
        }
        return this.mConnectivityManager.getActiveNetworkInfo() != null;
    }

    @RequiresApi(value=28)
    private boolean hasNetworkApi28() {
        return this.mConnectivityManager.getActiveNetwork() != null;
    }

    public boolean isWifiNetwork() {
        if (Build.VERSION.SDK_INT > 28) {
            return this.isWifiNetworkApi28();
        }
        NetworkInfo networkInfo = this.mConnectivityManager.getActiveNetworkInfo();
        if (networkInfo == null) {
            return false;
        }
        return networkInfo.getType() == 1;
    }

    @RequiresApi(value=28)
    private boolean isWifiNetworkApi28() {
        Network network = this.mConnectivityManager.getActiveNetwork();
        if (network == null) {
            return false;
        }
        NetworkCapabilities capabilities = this.mConnectivityManager.getNetworkCapabilities(network);
        if (capabilities == null) {
            return false;
        }
        return capabilities.hasTransport(1);
    }

    @RequiresApi(value=28)
    private void subscribeNetworkStateApi28() {
        this.mConnectivityManager.registerNetworkCallback(new NetworkRequest.Builder().addTransportType(1).build(), this.mNetworkCallback);
    }

    @RequiresApi(value=28)
    private void unsubscribeNetworkStateApi28() {
        this.mConnectivityManager.unregisterNetworkCallback(this.mNetworkCallback);
    }

    public void subscribeNetworkState() {
        if (Build.VERSION.SDK_INT >= 28) {
            this.subscribeNetworkStateApi28();
            return;
        }
        IntentFilter intentFilter = new IntentFilter("noConnectivity");
        intentFilter.addCategory("android.intent.category.DEFAULT");
        this.mApplicationContext.registerReceiver(this.mNetworkStateReceiver, intentFilter);
    }

    public void unsubscribeNetworkState() {
        if (Build.VERSION.SDK_INT >= 28) {
            this.unsubscribeNetworkStateApi28();
            return;
        }
        this.mApplicationContext.unregisterReceiver(this.mNetworkStateReceiver);
    }

    public static interface OnNetworkStateChangeListener {
        public void onNetworkStateChanged(boolean var1, boolean var2);
    }
}

