/*
 * Decompiled with CFR 0.152.
 */
package snow.player.audio;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import snow.player.R;

public final class MusicItem
implements Parcelable {
    private String musicId;
    private String title;
    private String artist;
    private String album;
    private String uri;
    private String iconUri;
    private int duration;
    private boolean forbidSeek;
    @Nullable
    private Bundle extra;
    private static final String VERSION_1 = "v1";
    private boolean autoDuration;
    public static final Parcelable.Creator<MusicItem> CREATOR = new Parcelable.Creator<MusicItem>(){

        public MusicItem createFromParcel(Parcel source) {
            return new MusicItem(source);
        }

        public MusicItem[] newArray(int size) {
            return new MusicItem[size];
        }
    };

    public MusicItem() {
        this.musicId = "";
        this.title = "";
        this.artist = "";
        this.album = "";
        this.uri = "";
        this.iconUri = "";
        this.duration = 0;
        this.extra = null;
        this.forbidSeek = false;
        this.autoDuration = false;
    }

    public MusicItem(MusicItem source) {
        this.musicId = source.musicId;
        this.title = source.title;
        this.artist = source.artist;
        this.album = source.album;
        this.uri = source.uri;
        this.iconUri = source.iconUri;
        this.duration = source.duration;
        this.forbidSeek = source.forbidSeek;
        this.autoDuration = source.autoDuration;
        if (source.extra != null) {
            this.extra = new Bundle(source.extra);
        }
    }

    @NonNull
    public String getMusicId() {
        return this.musicId;
    }

    public void setMusicId(@NonNull String musicId) {
        Preconditions.checkNotNull((Object)musicId);
        this.musicId = musicId;
    }

    @NonNull
    public String getTitle() {
        return this.title;
    }

    public void setTitle(@NonNull String title) {
        Preconditions.checkNotNull((Object)title);
        this.title = title;
    }

    @NonNull
    public String getArtist() {
        return this.artist;
    }

    public void setArtist(@NonNull String artist) {
        Preconditions.checkNotNull((Object)artist);
        this.artist = artist;
    }

    @NonNull
    public String getAlbum() {
        return this.album;
    }

    public void setAlbum(@NonNull String album) {
        Preconditions.checkNotNull((Object)album);
        this.album = album;
    }

    @NonNull
    public String getUri() {
        return this.uri;
    }

    public void setUri(@NonNull String uri) {
        Preconditions.checkNotNull((Object)uri);
        this.uri = uri;
    }

    @NonNull
    public String getIconUri() {
        return this.iconUri;
    }

    public void setIconUri(@NonNull String iconUri) {
        Preconditions.checkNotNull((Object)iconUri);
        this.iconUri = iconUri;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        if (duration < 0) {
            this.duration = 0;
            return;
        }
        this.duration = duration;
    }

    public boolean isAutoDuration() {
        return this.autoDuration;
    }

    public void setAutoDuration(boolean autoDuration) {
        this.autoDuration = autoDuration;
    }

    public boolean isForbidSeek() {
        return this.forbidSeek;
    }

    public void setForbidSeek(boolean forbidSeek) {
        this.forbidSeek = forbidSeek;
    }

    @Nullable
    public Bundle getExtra() {
        return this.extra;
    }

    public void setExtra(@Nullable Bundle extra) {
        this.extra = extra;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MusicItem)) {
            return false;
        }
        MusicItem other = (MusicItem)o;
        return Objects.equal((Object)this.musicId, (Object)other.musicId) && Objects.equal((Object)this.title, (Object)other.title) && Objects.equal((Object)this.artist, (Object)other.artist) && Objects.equal((Object)this.album, (Object)other.album) && Objects.equal((Object)this.uri, (Object)other.uri) && Objects.equal((Object)this.iconUri, (Object)other.iconUri) && Objects.equal((Object)this.duration, (Object)other.duration) && Objects.equal((Object)this.forbidSeek, (Object)other.forbidSeek) && Objects.equal((Object)this.autoDuration, (Object)other.autoDuration);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.musicId, this.title, this.artist, this.album, this.uri, this.iconUri, this.duration, this.forbidSeek, this.autoDuration});
    }

    public String toString() {
        return "MusicItem{musicId='" + this.musicId + '\'' + ", title='" + this.title + '\'' + ", artist='" + this.artist + '\'' + ", album='" + this.album + '\'' + ", uri='" + this.uri + '\'' + ", iconUri='" + this.iconUri + '\'' + ", duration=" + this.duration + ", forbidSeek=" + this.forbidSeek + ", autoDuration=" + this.autoDuration + '}';
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.musicId);
        dest.writeString(this.title);
        dest.writeString(this.artist);
        dest.writeString(this.album);
        dest.writeString(this.uri);
        dest.writeString(this.iconUri);
        dest.writeInt(this.duration);
        dest.writeByte((byte)(this.forbidSeek ? 1 : 0));
        dest.writeParcelable((Parcelable)this.extra, 0);
        dest.writeString(VERSION_1);
        dest.writeByte((byte)(this.autoDuration ? 1 : 0));
    }

    protected MusicItem(Parcel in) {
        this.musicId = in.readString();
        this.title = in.readString();
        this.artist = in.readString();
        this.album = in.readString();
        this.uri = in.readString();
        this.iconUri = in.readString();
        this.duration = in.readInt();
        this.forbidSeek = in.readByte() == 1;
        this.extra = (Bundle)in.readParcelable(Thread.currentThread().getContextClassLoader());
        this.deserializeByVersion(in, VERSION_1, new Deserialization(){

            @Override
            public void deserialization(Parcel in) {
                MusicItem.this.autoDuration = in.readByte() == 1;
            }
        });
    }

    private void deserializeByVersion(Parcel in, String version, Deserialization deserialization) {
        int pos = in.dataPosition();
        String versionString = in.readString();
        if (version.equals(versionString)) {
            deserialization.deserialization(in);
        } else {
            in.setDataPosition(pos);
        }
    }

    private static interface Deserialization {
        public void deserialization(Parcel var1);
    }

    public static class Builder {
        private String musicId = "";
        private String title = "";
        private String artist = "";
        private String album = "";
        private String uri;
        private String iconUri = "";
        private int duration;
        private boolean forbidSeek = false;
        private Bundle extra;
        private boolean autoDuration = false;

        public Builder() {
        }

        public Builder(@NonNull Context context) {
            Preconditions.checkNotNull((Object)context);
            this.title = context.getString(R.string.snow_music_item_unknown_title);
            this.artist = context.getString(R.string.snow_music_item_unknown_artist);
            this.album = context.getString(R.string.snow_music_item_unknown_album);
        }

        public Builder setMusicId(@NonNull String musicId) {
            Preconditions.checkNotNull((Object)musicId);
            this.musicId = musicId;
            return this;
        }

        public Builder setTitle(@NonNull String title) {
            Preconditions.checkNotNull((Object)title);
            this.title = title;
            return this;
        }

        public Builder setArtist(@NonNull String artist) {
            Preconditions.checkNotNull((Object)artist);
            this.artist = artist;
            return this;
        }

        public Builder setAlbum(@NonNull String album) {
            Preconditions.checkNotNull((Object)album);
            this.album = album;
            return this;
        }

        public Builder setUri(@NonNull String uri) {
            Preconditions.checkNotNull((Object)uri);
            this.uri = uri;
            return this;
        }

        public Builder setIconUri(@NonNull String iconUri) {
            Preconditions.checkNotNull((Object)iconUri);
            this.iconUri = iconUri;
            return this;
        }

        public Builder setDuration(int duration) throws IllegalArgumentException {
            if (duration < 0) {
                this.duration = 0;
                return this;
            }
            this.duration = duration;
            return this;
        }

        public Builder autoDuration() {
            return this.setAutoDuration(true);
        }

        public Builder setAutoDuration(boolean autoDuration) {
            this.autoDuration = autoDuration;
            return this;
        }

        public Builder setForbidSeek(boolean forbidSeek) {
            this.forbidSeek = forbidSeek;
            return this;
        }

        public Builder setExtra(@Nullable Bundle extra) {
            this.extra = extra;
            return this;
        }

        public MusicItem build() {
            MusicItem musicItem = new MusicItem();
            musicItem.setMusicId(this.musicId);
            musicItem.setTitle(this.title);
            musicItem.setArtist(this.artist);
            musicItem.setAlbum(this.album);
            musicItem.setUri(this.uri);
            musicItem.setIconUri(this.iconUri);
            musicItem.setDuration(this.duration);
            musicItem.setForbidSeek(this.forbidSeek);
            musicItem.setExtra(this.extra);
            musicItem.setAutoDuration(this.autoDuration);
            return musicItem;
        }
    }
}

