/*
 * Decompiled with CFR 0.152.
 */
package snow.player;

import android.content.Context;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.common.base.Preconditions;
import com.tencent.mmkv.MMKV;
import snow.player.PlayMode;
import snow.player.PlayerState;
import snow.player.audio.MusicItem;

class PersistentPlayerState
extends PlayerState {
    private static final String KEY_PLAY_PROGRESS = "play_progress";
    private static final String KEY_MUSIC_ITEM = "music_item";
    private static final String KEY_PLAY_POSITION = "position";
    private static final String KEY_PLAY_MODE = "play_mode";
    private static final String KEY_SPEED = "speed";
    private static final String KEY_DURATION = "duration";
    private static final String KEY_WAIT_PLAY_COMPLETE = "wait_play_complete";
    private static final String KEY_VOLUME = "volume";
    private final MMKV mMMKV;

    public PersistentPlayerState(@NonNull Context context, @NonNull String id) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)id);
        MMKV.initialize((Context)context);
        this.mMMKV = MMKV.mmkvWithID((String)("PlayerState:" + id));
        super.setMusicItem((MusicItem)this.mMMKV.decodeParcelable(KEY_MUSIC_ITEM, MusicItem.class));
        super.setPlayPosition(this.mMMKV.decodeInt(KEY_PLAY_POSITION, 0));
        super.setPlayMode(PlayMode.getBySerialId(this.mMMKV.decodeInt(KEY_PLAY_MODE, 0)));
        super.setSpeed(this.mMMKV.getFloat(KEY_SPEED, 1.0f));
        super.setDuration(this.mMMKV.getInt(KEY_DURATION, 0));
        super.setWaitPlayComplete(this.mMMKV.getBoolean(KEY_WAIT_PLAY_COMPLETE, false));
        super.setVolume(this.mMMKV.getFloat(KEY_VOLUME, 1.0f));
        if (this.isForbidSeek()) {
            super.setPlayProgress(0);
            return;
        }
        super.setPlayProgress(this.mMMKV.decodeInt(KEY_PLAY_PROGRESS, 0));
    }

    @Override
    public void setPlayProgress(int playProgress) {
        super.setPlayProgress(playProgress);
        if (this.isForbidSeek()) {
            this.mMMKV.encode(KEY_PLAY_PROGRESS, 0);
            return;
        }
        this.mMMKV.encode(KEY_PLAY_PROGRESS, playProgress);
    }

    @Override
    public void setMusicItem(@Nullable MusicItem musicItem) {
        super.setMusicItem(musicItem);
        if (musicItem == null) {
            this.mMMKV.remove(KEY_MUSIC_ITEM);
            return;
        }
        this.mMMKV.encode(KEY_MUSIC_ITEM, (Parcelable)musicItem);
    }

    @Override
    public void setPlayPosition(int playPosition) {
        super.setPlayPosition(playPosition);
        this.mMMKV.encode(KEY_PLAY_POSITION, playPosition);
    }

    @Override
    public void setPlayMode(@NonNull PlayMode playMode) {
        super.setPlayMode(playMode);
        this.mMMKV.encode(KEY_PLAY_MODE, playMode.serialId);
    }

    @Override
    public void setSpeed(float speed) {
        super.setSpeed(speed);
        this.mMMKV.encode(KEY_SPEED, speed);
    }

    @Override
    public void setDuration(int duration) {
        super.setDuration(duration);
        this.mMMKV.encode(KEY_DURATION, duration);
    }

    @Override
    public void setWaitPlayComplete(boolean waitPlayComplete) {
        super.setWaitPlayComplete(waitPlayComplete);
        this.mMMKV.encode(KEY_WAIT_PLAY_COMPLETE, waitPlayComplete);
    }

    @Override
    public void setVolume(float volume) {
        super.setVolume(volume);
        this.mMMKV.encode(KEY_VOLUME, volume);
    }
}

