/*
 * Decompiled with CFR 0.152.
 */
package snow.player.exo;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.Uri;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.media3.common.MediaItem;
import androidx.media3.common.PlaybackException;
import androidx.media3.common.PlaybackParameters;
import androidx.media3.common.Player;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.ExoPlaybackException;
import androidx.media3.exoplayer.ExoPlayer;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.source.MediaSourceFactory;
import snow.player.audio.MusicPlayer;

public class ExoMusicPlayer
implements MusicPlayer {
    private static final String TAG = "ExoMusicPlayer";
    private ExoPlayer mExoPlayer;
    private Player.Listener mEventListener;
    @Nullable
    private MusicPlayer.OnPreparedListener mPreparedListener;
    @Nullable
    private MusicPlayer.OnCompletionListener mCompletionListener;
    @Nullable
    private MusicPlayer.OnSeekCompleteListener mSeekCompleteListener;
    @Nullable
    private MusicPlayer.OnStalledListener mStalledListener;
    @Nullable
    private MusicPlayer.OnBufferingUpdateListener mBufferingUpdateListener;
    @Nullable
    private MusicPlayer.OnErrorListener mErrorListener;
    @Nullable
    private MusicPlayer.OnRepeatListener mRepeatListener;
    private boolean mStalled;
    private boolean mInvalid;
    private boolean mPreparing;
    private boolean mPlayerReady;
    private float mVolume = 1.0f;

    @Deprecated
    @OptIn(markerClass={UnstableApi.class})
    public ExoMusicPlayer(@NonNull Context context, @NonNull MediaSourceFactory mediaSourceFactory, @NonNull Uri uri) {
        this(context, (MediaSource.Factory)mediaSourceFactory, uri);
    }

    @OptIn(markerClass={UnstableApi.class})
    public ExoMusicPlayer(@NonNull Context context, @NonNull MediaSource.Factory mediaSourceFactory, @NonNull Uri uri) {
        this.initEventListener();
        this.initExoPlayer(context, mediaSourceFactory);
        this.mExoPlayer.setMediaItem(MediaItem.fromUri((Uri)uri));
    }

    @OptIn(markerClass={UnstableApi.class})
    public ExoMusicPlayer(@NonNull Context context, @NonNull Uri uri) {
        this(context, MediaItem.fromUri((Uri)uri));
    }

    @OptIn(markerClass={UnstableApi.class})
    public ExoMusicPlayer(@NonNull Context context, @NonNull MediaItem mediaItem) {
        this.initEventListener();
        this.initExoPlayer(context, null);
        this.mExoPlayer.setMediaItem(mediaItem);
    }

    private void initEventListener() {
        this.mEventListener = new Player.Listener(){

            public void onIsLoadingChanged(boolean isLoading) {
                if (ExoMusicPlayer.this.mBufferingUpdateListener != null) {
                    ExoMusicPlayer.this.mBufferingUpdateListener.onBufferingUpdate((MusicPlayer)ExoMusicPlayer.this, (int)ExoMusicPlayer.this.mExoPlayer.getBufferedPosition(), false);
                }
            }

            public void onPlaybackStateChanged(int state) {
                switch (state) {
                    case 3: {
                        this.onReady();
                        break;
                    }
                    case 2: {
                        ExoMusicPlayer.this.setStalled(true);
                        break;
                    }
                    case 4: {
                        this.onEnd();
                        break;
                    }
                }
            }

            private void onReady() {
                ExoMusicPlayer.this.mPlayerReady = true;
                ExoMusicPlayer.this.notifyPrepared();
                if (ExoMusicPlayer.this.isStalled()) {
                    ExoMusicPlayer.this.setStalled(false);
                }
            }

            private void onEnd() {
                if (ExoMusicPlayer.this.mCompletionListener != null) {
                    ExoMusicPlayer.this.mCompletionListener.onCompletion((MusicPlayer)ExoMusicPlayer.this);
                }
            }

            @OptIn(markerClass={UnstableApi.class})
            public void onPlayerError(@NonNull PlaybackException error) {
                ExoMusicPlayer.this.setInvalid();
                Log.e((String)ExoMusicPlayer.TAG, (String)error.toString());
                error.printStackTrace();
                if (ExoMusicPlayer.this.mErrorListener != null) {
                    ExoMusicPlayer.this.mErrorListener.onError((MusicPlayer)ExoMusicPlayer.this, ExoMusicPlayer.this.toErrorCode(error));
                }
            }

            public void onPositionDiscontinuity(@NonNull Player.PositionInfo oldPosition, @NonNull Player.PositionInfo newPosition, int reason) {
                if (reason == 1 && ExoMusicPlayer.this.mSeekCompleteListener != null) {
                    ExoMusicPlayer.this.mSeekCompleteListener.onSeekComplete((MusicPlayer)ExoMusicPlayer.this);
                }
            }

            public void onMediaItemTransition(@Nullable MediaItem mediaItem, int reason) {
                if (reason == 0 && ExoMusicPlayer.this.mRepeatListener != null) {
                    ExoMusicPlayer.this.mRepeatListener.onRepeat((MusicPlayer)ExoMusicPlayer.this);
                }
            }
        };
    }

    private void setStalled(boolean stalled) {
        this.mStalled = stalled;
        if (this.isPrepared() && this.mStalledListener != null) {
            this.mStalledListener.onStalled(this.mStalled);
        }
    }

    @OptIn(markerClass={UnstableApi.class})
    @SuppressLint(value={"SwitchIntDef"})
    private int toErrorCode(PlaybackException error) {
        if (!(error instanceof ExoPlaybackException)) {
            return 8;
        }
        switch (((ExoPlaybackException)error).type) {
            case 0: {
                return 5;
            }
            case 3: {
                return 3;
            }
            case 1: {
                return 2;
            }
        }
        return 8;
    }

    @OptIn(markerClass={UnstableApi.class})
    private void initExoPlayer(Context context, @Nullable MediaSource.Factory mediaSourceFactory) {
        ExoPlayer.Builder builder = new ExoPlayer.Builder(context).setWakeMode(2).setLooper(Looper.getMainLooper());
        if (mediaSourceFactory != null) {
            builder.setMediaSourceFactory(mediaSourceFactory);
        }
        this.mExoPlayer = builder.build();
        this.mExoPlayer.addListener(this.mEventListener);
    }

    private void notifyPrepared() {
        if (this.mPreparing && this.isPrepared()) {
            this.mPreparing = false;
            this.onPrepared();
        }
    }

    private boolean isPrepared() {
        return this.mPlayerReady;
    }

    private void onPrepared() {
        if (this.mPreparedListener != null) {
            this.mPreparedListener.onPrepared((MusicPlayer)this);
        }
        if (this.mStalled && this.mStalledListener != null) {
            this.mStalledListener.onStalled(true);
        }
    }

    public void prepare() {
        if (this.isInvalid()) {
            return;
        }
        this.mPreparing = true;
        this.mExoPlayer.prepare();
    }

    public void setLooping(boolean looping) {
        if (looping) {
            this.mExoPlayer.setRepeatMode(1);
            return;
        }
        this.mExoPlayer.setRepeatMode(0);
    }

    public boolean isLooping() {
        return this.mExoPlayer.getRepeatMode() == 1;
    }

    public boolean isStalled() {
        return this.mStalled;
    }

    public boolean isPlaying() {
        return this.isPrepared() && (this.mExoPlayer.isPlaying() || this.mExoPlayer.getPlayWhenReady());
    }

    public int getDuration() {
        return (int)this.mExoPlayer.getDuration();
    }

    public int getProgress() {
        return (int)this.mExoPlayer.getCurrentPosition();
    }

    public void start() {
        this.mExoPlayer.setPlayWhenReady(true);
    }

    public void pause() {
        this.mExoPlayer.setPlayWhenReady(false);
    }

    public void stop() {
        this.mExoPlayer.stop();
    }

    public void quiet() {
        float volume = this.mVolume * 0.5f;
        this.mExoPlayer.setVolume(volume);
    }

    public void dismissQuiet() {
        this.mExoPlayer.setVolume(this.mVolume);
    }

    public void release() {
        this.setInvalid();
        this.mExoPlayer.release();
    }

    public void seekTo(int pos) {
        this.mExoPlayer.seekTo((long)pos);
    }

    public void setVolume(float volume) {
        this.mVolume = volume;
        this.mExoPlayer.setVolume(volume);
    }

    public float getVolume() {
        return this.mExoPlayer.getVolume();
    }

    public void setSpeed(float speed) {
        PlaybackParameters parameters = new PlaybackParameters(speed);
        this.mExoPlayer.setPlaybackParameters(parameters);
    }

    public synchronized boolean isInvalid() {
        return this.mInvalid;
    }

    private synchronized void setInvalid() {
        this.mInvalid = true;
    }

    @OptIn(markerClass={UnstableApi.class})
    public int getAudioSessionId() {
        return this.mExoPlayer.getAudioSessionId();
    }

    public void setOnPreparedListener(@Nullable MusicPlayer.OnPreparedListener listener) {
        this.mPreparedListener = listener;
    }

    public void setOnCompletionListener(@Nullable MusicPlayer.OnCompletionListener listener) {
        this.mCompletionListener = listener;
    }

    public void setOnRepeatListener(@Nullable MusicPlayer.OnRepeatListener listener) {
        this.mRepeatListener = listener;
    }

    public void setOnSeekCompleteListener(@Nullable MusicPlayer.OnSeekCompleteListener listener) {
        this.mSeekCompleteListener = listener;
    }

    public void setOnStalledListener(@Nullable MusicPlayer.OnStalledListener listener) {
        this.mStalledListener = listener;
    }

    public void setOnBufferingUpdateListener(@Nullable MusicPlayer.OnBufferingUpdateListener listener) {
        this.mBufferingUpdateListener = listener;
    }

    public void setOnErrorListener(@Nullable MusicPlayer.OnErrorListener listener) {
        this.mErrorListener = listener;
    }
}

