/*
 * Decompiled with CFR 0.152.
 */
package media.helper;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.database.Cursor;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.provider.MediaStore;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import media.helper.ObjectUtil;

public final class MediaStoreHelper {
    private static Executor mExecutor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors() * 2, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            return thread;
        }
    });

    private MediaStoreHelper() {
        throw new AssertionError();
    }

    public static <T> Scanner<T> scanAudio(@NonNull ContentResolver resolver, @NonNull Decoder<T> decoder) {
        ObjectUtil.requireNonNull(resolver);
        ObjectUtil.requireNonNull(decoder);
        return new AudioScanner<T>(resolver, decoder);
    }

    public static <T> Scanner<T> scanVideo(@NonNull ContentResolver resolver, @NonNull Decoder<T> decoder) {
        ObjectUtil.requireNonNull(resolver);
        ObjectUtil.requireNonNull(decoder);
        return new VideoScanner<T>(resolver, decoder);
    }

    public static <T> Scanner<T> scanImages(@NonNull ContentResolver resolver, @NonNull Decoder<T> decoder) {
        ObjectUtil.requireNonNull(resolver);
        ObjectUtil.requireNonNull(decoder);
        return new ImagesScanner<T>(resolver, decoder);
    }

    private static class ImagesScanner<T>
    extends BaseScanner<T> {
        public ImagesScanner(ContentResolver resolver, Decoder<T> decoder) {
            super(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, resolver, decoder);
        }
    }

    private static class VideoScanner<T>
    extends BaseScanner<T> {
        public VideoScanner(ContentResolver resolver, Decoder<T> decoder) {
            super(MediaStore.Video.Media.EXTERNAL_CONTENT_URI, resolver, decoder);
        }
    }

    private static class AudioScanner<T>
    extends BaseScanner<T> {
        public AudioScanner(ContentResolver resolver, Decoder<T> decoder) {
            super(MediaStore.Audio.Media.EXTERNAL_CONTENT_URI, resolver, decoder);
        }
    }

    public static abstract class BaseScanner<T>
    implements Scanner<T> {
        private String[] mProjection;
        private String mSelection;
        private String[] mSelectionArgs;
        private String mSortOrder;
        private Uri mUri;
        private ContentResolver mResolver;
        private Decoder<T> mDecoder;
        private OnScanCallback<T> mCallback;
        private Handler mMainHandler;
        private int mThreshold;
        private boolean mRunning;
        private boolean mCancelled;
        private boolean mFinished;
        private long mLastUpdateTime;

        public BaseScanner(Uri uri, ContentResolver resolver, Decoder<T> decoder) {
            this.mUri = uri;
            this.mResolver = resolver;
            this.mDecoder = decoder;
            this.mThreshold = 200;
            this.mMainHandler = new Handler(Looper.getMainLooper());
        }

        @Override
        public Scanner<T> projection(String[] projection) {
            this.mProjection = projection;
            return this;
        }

        @Override
        public Scanner<T> selection(String selection) {
            this.mSelection = selection;
            return this;
        }

        @Override
        public Scanner<T> selectionArgs(String[] args) {
            this.mSelectionArgs = args;
            return this;
        }

        @Override
        public Scanner<T> sortOrder(String sortOrder) {
            this.mSortOrder = sortOrder;
            return this;
        }

        @Override
        public Scanner<T> updateThreshold(int threshold) {
            this.mThreshold = threshold;
            if (this.mThreshold < 200) {
                this.mThreshold = 200;
            }
            return this;
        }

        protected final synchronized boolean isRunning() {
            return this.mRunning;
        }

        protected final synchronized void setRunning(boolean running) {
            this.mRunning = running;
        }

        protected final synchronized boolean isFinished() {
            return this.mFinished;
        }

        protected final synchronized void setFinished(boolean finished) {
            this.mFinished = finished;
        }

        protected final synchronized boolean isCancelled() {
            return this.mCancelled;
        }

        @Override
        public final synchronized void cancel() {
            this.mCancelled = true;
            this.setRunning(false);
            this.setFinished(true);
        }

        @Override
        public void scan(@NonNull OnScanCallback<T> callback) throws IllegalStateException {
            ObjectUtil.requireNonNull(callback);
            if (this.isRunning()) {
                throw new IllegalStateException("scanner is running.");
            }
            this.mCallback = callback;
            mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    if (BaseScanner.this.isCancelled() || BaseScanner.this.isFinished()) {
                        return;
                    }
                    BaseScanner.this.setRunning(true);
                    BaseScanner.this.setFinished(false);
                    BaseScanner.this.notifyStartScan();
                    Cursor cursor = BaseScanner.this.mResolver.query(BaseScanner.this.mUri, BaseScanner.this.mProjection, BaseScanner.this.mSelection, BaseScanner.this.mSelectionArgs, BaseScanner.this.mSortOrder);
                    if (cursor != null && cursor.moveToFirst()) {
                        BaseScanner.this.forEachCursor(cursor);
                        cursor.close();
                        return;
                    }
                    BaseScanner.this.notifyFinished(new ArrayList());
                }
            });
        }

        private void forEachCursor(Cursor cursor) {
            int progress = 0;
            int max = cursor.getCount();
            ArrayList<T> items = new ArrayList<T>(max);
            do {
                items.add(this.decode(cursor, ++progress, max));
            } while (cursor.moveToNext() && !this.isCancelled());
            this.notifyFinished(items);
        }

        private T decode(Cursor cursor, int progress, int max) {
            T item = this.mDecoder.decode(cursor);
            this.notifyProgressUpdate(progress, max, item);
            return item;
        }

        private void notifyStartScan() {
            this.mMainHandler.post(new Runnable(){

                @Override
                public void run() {
                    BaseScanner.this.mCallback.onStartScan();
                }
            });
        }

        private void notifyProgressUpdate(final int progress, final int max, final T item) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.mLastUpdateTime < (long)this.mThreshold) {
                return;
            }
            if (this.isCancelled() || this.isFinished()) {
                return;
            }
            this.mLastUpdateTime = currentTime;
            this.mMainHandler.post(new Runnable(){

                @Override
                public void run() {
                    BaseScanner.this.mCallback.onUpdateProgress(progress, max, item);
                }
            });
        }

        private void notifyFinished(final List<T> items) {
            this.setFinished(true);
            this.mMainHandler.post(new Runnable(){

                @Override
                public void run() {
                    BaseScanner.this.mCallback.onFinished(items);
                }
            });
        }
    }

    public static abstract class Decoder<T> {
        public abstract T decode(Cursor var1);

        public static int getDateAdded(Cursor cursor) {
            return cursor.getInt(cursor.getColumnIndexOrThrow("date_added"));
        }

        public static int getDateModified(Cursor cursor) {
            return cursor.getInt(cursor.getColumnIndexOrThrow("date_modified"));
        }

        public static String getDisplayName(Cursor cursor) {
            return cursor.getString(cursor.getColumnIndexOrThrow("_display_name"));
        }

        public static String getMimeType(Cursor cursor) {
            return cursor.getString(cursor.getColumnIndexOrThrow("mime_type"));
        }

        public static int getSize(Cursor cursor) {
            return cursor.getInt(cursor.getColumnIndexOrThrow("_size"));
        }

        public static int getDuration(Cursor cursor) {
            return cursor.getInt(cursor.getColumnIndexOrThrow("duration"));
        }

        public static String getTitle(Cursor cursor) {
            return cursor.getString(cursor.getColumnIndexOrThrow("title"));
        }

        public static int getId(Cursor cursor) {
            return cursor.getInt(cursor.getColumnIndexOrThrow("_id"));
        }

        public static String getAudioArtist(Cursor cursor) {
            return cursor.getString(cursor.getColumnIndexOrThrow("artist"));
        }

        public static int getAudioArtistId(Cursor cursor) {
            return cursor.getInt(cursor.getColumnIndexOrThrow("artist_id"));
        }

        public static String getAudioAlbum(Cursor cursor) {
            return cursor.getString(cursor.getColumnIndexOrThrow("album"));
        }

        public static int getAudioAlbumId(Cursor cursor) {
            return cursor.getInt(cursor.getColumnIndexOrThrow("album_id"));
        }

        public static boolean audioIsAlarm(Cursor cursor) {
            return cursor.getInt(cursor.getColumnIndexOrThrow("is_alarm")) != 0;
        }

        @RequiresApi(value=29)
        public static boolean audioIsAudioBook(Cursor cursor) {
            return cursor.getInt(cursor.getColumnIndexOrThrow("is_audiobook")) != 0;
        }

        public static boolean audioIsMusic(Cursor cursor) {
            return cursor.getInt(cursor.getColumnIndexOrThrow("is_music")) != 0;
        }

        public static boolean audioIsNotification(Cursor cursor) {
            return cursor.getInt(cursor.getColumnIndexOrThrow("is_notification")) != 0;
        }

        @RequiresApi(api=29)
        public static boolean audioIsPending(Cursor cursor) {
            return cursor.getInt(cursor.getColumnIndexOrThrow("is_pending")) != 0;
        }

        public static boolean audioIsPodcast(Cursor cursor) {
            return cursor.getInt(cursor.getColumnIndexOrThrow("is_podcast")) != 0;
        }

        public static boolean audioIsRingtone(Cursor cursor) {
            return cursor.getInt(cursor.getColumnIndexOrThrow("is_ringtone")) != 0;
        }

        public static int getAudioTrack(Cursor cursor) {
            return cursor.getInt(cursor.getColumnIndexOrThrow("track"));
        }

        public static int getAudioYear(Cursor cursor) {
            return cursor.getInt(cursor.getColumnIndexOrThrow("year"));
        }

        public static Uri getAudioUri(Cursor cursor) {
            return ContentUris.withAppendedId((Uri)MediaStore.Audio.Media.EXTERNAL_CONTENT_URI, (long)Decoder.getId(cursor));
        }

        @RequiresApi(api=16)
        public static int getVideoWidth(Cursor cursor) {
            return cursor.getInt(cursor.getColumnIndexOrThrow("width"));
        }

        @RequiresApi(api=16)
        public static int getVideoHeight(Cursor cursor) {
            return cursor.getInt(cursor.getColumnIndexOrThrow("height"));
        }

        public static String getVideoCategory(Cursor cursor) {
            return cursor.getString(cursor.getColumnIndexOrThrow("category"));
        }

        public static String getVideoColorRange(Cursor cursor) {
            return cursor.getString(cursor.getColumnIndexOrThrow("description"));
        }

        public static boolean videoIsPrivate(Cursor cursor) {
            return cursor.getInt(cursor.getColumnIndexOrThrow("isprivate")) != 0;
        }

        public static String getVideoLanguage(Cursor cursor) {
            return cursor.getString(cursor.getColumnIndexOrThrow("language"));
        }

        @Deprecated
        public static float getVideoLatitude(Cursor cursor) {
            return cursor.getFloat(cursor.getColumnIndexOrThrow("latitude"));
        }

        @Deprecated
        public static float getVideoLongitude(Cursor cursor) {
            return cursor.getFloat(cursor.getColumnIndexOrThrow("longitude"));
        }

        @Deprecated
        public static int getVideoMiniThumbMagic(Cursor cursor) {
            return cursor.getInt(cursor.getColumnIndexOrThrow("mini_thumb_magic"));
        }

        public static String getVideoTags(Cursor cursor) {
            return cursor.getString(cursor.getColumnIndexOrThrow("tags"));
        }

        public static Uri getVideoUri(Cursor cursor) {
            return ContentUris.withAppendedId((Uri)MediaStore.Video.Media.EXTERNAL_CONTENT_URI, (long)Decoder.getId(cursor));
        }

        @RequiresApi(api=16)
        public static int getImageWidth(Cursor cursor) {
            return cursor.getInt(cursor.getColumnIndexOrThrow("width"));
        }

        @RequiresApi(api=16)
        public static int getImageHeight(Cursor cursor) {
            return cursor.getInt(cursor.getColumnIndexOrThrow("height"));
        }

        public static String getImageDescription(Cursor cursor) {
            return cursor.getString(cursor.getColumnIndexOrThrow("description"));
        }

        public static boolean imageIsPrivate(Cursor cursor) {
            return cursor.getInt(cursor.getColumnIndexOrThrow("isprivate")) != 0;
        }

        @Deprecated
        public static float getImageLatitude(Cursor cursor) {
            return cursor.getFloat(cursor.getColumnIndexOrThrow("latitude"));
        }

        @Deprecated
        public static float getImageLongitude(Cursor cursor) {
            return cursor.getFloat(cursor.getColumnIndexOrThrow("longitude"));
        }

        @Deprecated
        public static int getImageMiniThumbMagic(Cursor cursor) {
            return cursor.getInt(cursor.getColumnIndexOrThrow("mini_thumb_magic"));
        }

        @Deprecated
        public static String getImagePicasaId(Cursor cursor) {
            return cursor.getString(cursor.getColumnIndexOrThrow("picasa_id"));
        }

        public static Uri getImageUri(Cursor cursor) {
            return ContentUris.withAppendedId((Uri)MediaStore.Images.Media.EXTERNAL_CONTENT_URI, (long)Decoder.getId(cursor));
        }
    }

    public static interface OnScanCallback<T> {
        public void onStartScan();

        public void onUpdateProgress(int var1, int var2, T var3);

        public void onFinished(List<T> var1);
    }

    public static interface Scanner<T> {
        public static final int MIN_UPDATE_THRESHOLD = 200;

        public Scanner<T> projection(String[] var1);

        public Scanner<T> selection(String var1);

        public Scanner<T> selectionArgs(String[] var1);

        public Scanner<T> sortOrder(String var1);

        public Scanner<T> updateThreshold(int var1);

        public void cancel();

        public void scan(@NonNull OnScanCallback<T> var1);
    }
}

