/*
 * Decompiled with CFR 0.152.
 */
package media.helper;

import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import android.view.KeyEvent;
import androidx.annotation.NonNull;
import java.util.Timer;
import java.util.TimerTask;

public class HeadsetHookHelper {
    public static final int DEFAULT_CLICK_INTERVAL = 300;
    private ClickCounter mClickCounter;

    public HeadsetHookHelper(@NonNull OnHeadsetHookClickListener listener) {
        this(300, listener);
    }

    public HeadsetHookHelper(int clickInterval, @NonNull OnHeadsetHookClickListener listener) {
        this.mClickCounter = new ClickCounter(clickInterval, listener);
    }

    public boolean handleMediaButton(Intent intent) {
        KeyEvent keyEvent = (KeyEvent)intent.getParcelableExtra("android.intent.extra.KEY_EVENT");
        if (keyEvent == null) {
            return false;
        }
        if (keyEvent.getKeyCode() == 79) {
            this.consumeMediaButtonEvent(keyEvent);
            return true;
        }
        this.mClickCounter.reset();
        return false;
    }

    private void consumeMediaButtonEvent(KeyEvent keyEvent) {
        if (keyEvent.getAction() == 1) {
            this.mClickCounter.putEvent();
        }
    }

    private static class ClickCounter {
        private int mClickInterval;
        private int mCount;
        private Timer mTimer;
        private OnHeadsetHookClickListener mHeadsetHookClickListener;
        private Handler mMainHandler;

        ClickCounter(int clickInterval, OnHeadsetHookClickListener listener) {
            this.mClickInterval = clickInterval;
            this.mHeadsetHookClickListener = listener;
            this.mMainHandler = new Handler(Looper.getMainLooper());
        }

        void reset() {
            this.cancelTimer();
            this.mCount = 0;
        }

        void putEvent() {
            ++this.mCount;
            this.startTimer();
        }

        private void startTimer() {
            this.cancelTimer();
            this.mTimer = new Timer();
            this.mTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    ClickCounter.this.notifyClicked();
                }
            }, this.mClickInterval);
        }

        private void notifyClicked() {
            this.mMainHandler.post(new Runnable(){

                @Override
                public void run() {
                    ClickCounter.this.mHeadsetHookClickListener.onHeadsetHookClicked(ClickCounter.this.mCount);
                    ClickCounter.this.mCount = 0;
                }
            });
        }

        private void cancelTimer() {
            if (this.mTimer != null) {
                this.mTimer.cancel();
            }
        }
    }

    public static interface OnHeadsetHookClickListener {
        public void onHeadsetHookClicked(int var1);
    }
}

