/*
 * Decompiled with CFR 0.152.
 */
package channel.helper.pipe;

import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.NonNull;
import channel.helper.Dispatcher;
import channel.helper.Emitter;
import channel.helper.pipe.MapWrapper;
import java.util.HashMap;
import java.util.Map;

public class MessengerPipe
extends Handler
implements Emitter {
    private static final String TAG = "MessengerPipe";
    private static final String KEY_MAP_WRAPPER = "map_wrapper";
    private Messenger mMessenger;
    private Dispatcher mDispatcher;

    public MessengerPipe(IBinder binder) {
        this.mMessenger = new Messenger(binder);
    }

    public MessengerPipe(Dispatcher dispatcher) {
        this(Looper.getMainLooper(), dispatcher);
    }

    public MessengerPipe(Looper looper, Dispatcher dispatcher) {
        super(looper);
        if (dispatcher == null) {
            throw new IllegalArgumentException("param 'dispatcher' is not null.");
        }
        this.mMessenger = new Messenger((Handler)this);
        this.mDispatcher = dispatcher;
    }

    public void handleMessage(@NonNull Message msg) {
        this.mDispatcher.dispatch(this.getData(msg));
    }

    public void emit(Map<String, Object> data) {
        Message message = Message.obtain();
        Bundle bundle = new Bundle();
        bundle.putParcelable(KEY_MAP_WRAPPER, (Parcelable)new MapWrapper(data));
        message.setData(bundle);
        try {
            this.mMessenger.send(message);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private Map<String, Object> getData(Message dataWrapper) {
        Bundle bundle = dataWrapper.getData();
        if (bundle == null) {
            Log.d((String)TAG, (String)"dataWrapper is empty.");
            return new HashMap<String, Object>();
        }
        bundle.setClassLoader(MapWrapper.class.getClassLoader());
        MapWrapper mapWrapper = (MapWrapper)bundle.getParcelable(KEY_MAP_WRAPPER);
        if (mapWrapper == null) {
            Log.d((String)TAG, (String)"dataWrapper is empty.");
            return new HashMap<String, Object>();
        }
        return mapWrapper.getMap();
    }

    public IBinder getBinder() {
        return this.mMessenger.getBinder();
    }

    public Messenger getMessenger() {
        return this.mMessenger;
    }
}

