/*
 * Decompiled with CFR 0.152.
 */
package channel.helper.pipe;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import androidx.annotation.NonNull;
import channel.helper.Dispatcher;
import channel.helper.Emitter;
import java.util.HashMap;
import java.util.Map;

public class HandlerPipe
extends Handler
implements Emitter {
    private static final String TAG = "HandlerPipe";
    private final Dispatcher mDispatcher;

    public HandlerPipe(Dispatcher dispatcher) {
        this(Looper.getMainLooper(), dispatcher);
    }

    public HandlerPipe(Looper looper, Dispatcher dispatcher) {
        super(looper);
        if (dispatcher == null) {
            throw new IllegalArgumentException("param 'dispatcher' is not null.");
        }
        this.mDispatcher = dispatcher;
    }

    public void emit(Map<String, Object> data) {
        Message message = Message.obtain();
        message.obj = data;
        this.sendMessage(message);
    }

    public void handleMessage(@NonNull Message msg) {
        this.mDispatcher.dispatch(this.getData(msg));
    }

    private Map<String, Object> getData(Message dataWrapper) {
        if (dataWrapper.obj == null) {
            Log.d((String)TAG, (String)"dataWrapper is empty.");
            return new HashMap<String, Object>();
        }
        if (!(dataWrapper.obj instanceof Map)) {
            Log.d((String)TAG, (String)"dataWrapper is empty.");
            return new HashMap<String, Object>();
        }
        return (Map)dataWrapper.obj;
    }
}

