/*
 * Decompiled with CFR 0.152.
 */
package channel.helper.pipe;

import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.media.session.MediaControllerCompat;
import channel.helper.Dispatcher;
import channel.helper.Emitter;
import channel.helper.pipe.MapWrapper;
import java.util.Map;

public final class CustomActionPipe
implements Emitter {
    private static final String ACTION = "channel.helper.pipe.CUSTOM_ACTION";
    private static final String KEY_DATA = "data";
    private MediaControllerCompat.TransportControls mTransportControls;
    private Dispatcher mDispatcher;

    public void emit(Map<String, Object> data) {
        Bundle bundle = new Bundle();
        bundle.putParcelable(KEY_DATA, (Parcelable)new MapWrapper(data));
        this.mTransportControls.sendCustomAction(ACTION, bundle);
    }

    public CustomActionPipe(MediaControllerCompat.TransportControls transportControls) {
        this.mTransportControls = transportControls;
    }

    public CustomActionPipe(Dispatcher dispatcher) {
        this.mDispatcher = dispatcher;
    }

    public boolean dispatch(String action, Bundle data) {
        if (!ACTION.equals(action)) {
            return false;
        }
        MapWrapper wrapper = (MapWrapper)data.getParcelable(KEY_DATA);
        if (wrapper == null) {
            return false;
        }
        return this.mDispatcher.dispatch(wrapper.getMap());
    }
}

