/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import com.noveogroup.android.log.Logger;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

public class AndroidLoggerAdapter
extends MarkerIgnoringBase {
    private final Logger logger;

    public AndroidLoggerAdapter(Logger logger) {
        this.logger = logger;
    }

    private boolean isEnabled(Logger.Level level) {
        return this.logger.isEnabled(level);
    }

    private void log(Logger.Level level, String msg) {
        this.logger.print(level, null, msg);
    }

    private void log(Logger.Level level, String format, Object arg) {
        this.logger.print(level, null, MessageFormatter.format((String)format, (Object)arg).getMessage());
    }

    private void log(Logger.Level level, String format, Object arg1, Object arg2) {
        this.logger.print(level, null, MessageFormatter.format((String)format, (Object)arg1, (Object)arg2).getMessage());
    }

    private void log(Logger.Level level, String format, Object ... arguments) {
        this.logger.print(level, null, MessageFormatter.arrayFormat((String)format, (Object[])arguments).getMessage());
    }

    private void log(Logger.Level level, String msg, Throwable t) {
        this.logger.print(level, t, msg);
    }

    public boolean isTraceEnabled() {
        return this.isEnabled(Logger.Level.VERBOSE);
    }

    public void trace(String msg) {
        this.log(Logger.Level.VERBOSE, msg);
    }

    public void trace(String format, Object arg) {
        this.log(Logger.Level.VERBOSE, format, arg);
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.log(Logger.Level.VERBOSE, format, arg1, arg2);
    }

    public void trace(String format, Object ... arguments) {
        this.log(Logger.Level.VERBOSE, format, arguments);
    }

    public void trace(String msg, Throwable t) {
        this.log(Logger.Level.VERBOSE, msg, t);
    }

    public boolean isDebugEnabled() {
        return this.isEnabled(Logger.Level.DEBUG);
    }

    public void debug(String msg) {
        this.log(Logger.Level.DEBUG, msg);
    }

    public void debug(String format, Object arg) {
        this.log(Logger.Level.DEBUG, format, arg);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.log(Logger.Level.DEBUG, format, arg1, arg2);
    }

    public void debug(String format, Object ... arguments) {
        this.log(Logger.Level.DEBUG, format, arguments);
    }

    public void debug(String msg, Throwable t) {
        this.log(Logger.Level.DEBUG, msg, t);
    }

    public boolean isInfoEnabled() {
        return this.isEnabled(Logger.Level.INFO);
    }

    public void info(String msg) {
        this.log(Logger.Level.INFO, msg);
    }

    public void info(String format, Object arg) {
        this.log(Logger.Level.INFO, format, arg);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.log(Logger.Level.INFO, format, arg1, arg2);
    }

    public void info(String format, Object ... arguments) {
        this.log(Logger.Level.INFO, format, arguments);
    }

    public void info(String msg, Throwable t) {
        this.log(Logger.Level.INFO, msg, t);
    }

    public boolean isWarnEnabled() {
        return this.isEnabled(Logger.Level.WARN);
    }

    public void warn(String msg) {
        this.log(Logger.Level.WARN, msg);
    }

    public void warn(String format, Object arg) {
        this.log(Logger.Level.WARN, format, arg);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.log(Logger.Level.WARN, format, arg1, arg2);
    }

    public void warn(String format, Object ... arguments) {
        this.log(Logger.Level.WARN, format, arguments);
    }

    public void warn(String msg, Throwable t) {
        this.log(Logger.Level.WARN, msg, t);
    }

    public boolean isErrorEnabled() {
        return this.isEnabled(Logger.Level.ERROR);
    }

    public void error(String msg) {
        this.log(Logger.Level.ERROR, msg);
    }

    public void error(String format, Object arg) {
        this.log(Logger.Level.ERROR, format, arg);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.log(Logger.Level.ERROR, format, arg1, arg2);
    }

    public void error(String format, Object ... arguments) {
        this.log(Logger.Level.ERROR, format, arguments);
    }

    public void error(String msg, Throwable t) {
        this.log(Logger.Level.ERROR, msg, t);
    }
}

